/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.storageengine.dataregion.ILastFlushTime;
import org.apache.iotdb.db.storageengine.dataregion.PartitionLastFlushTime;

public class DeviceLastFlushTime
implements ILastFlushTime {
    Map<String, Long> deviceLastFlushTimeMap = new HashMap<String, Long>();

    @Override
    public long getLastFlushTime(String deviceId) {
        if (this.deviceLastFlushTimeMap.containsKey(deviceId)) {
            return this.deviceLastFlushTimeMap.get(deviceId);
        }
        return Long.MIN_VALUE;
    }

    @Override
    public void updateLastFlushTime(String deviceId, long time) {
        this.deviceLastFlushTimeMap.merge(deviceId, time, Math::max);
    }

    @Override
    public ILastFlushTime degradeLastFlushTime() {
        long maxTime = Long.MIN_VALUE;
        for (long time : this.deviceLastFlushTimeMap.values()) {
            maxTime = Math.max(maxTime, time);
        }
        return new PartitionLastFlushTime(maxTime);
    }
}

