/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFile;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFileConfig;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.log.SchemaFileLogReader;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.log.SchemaFileLogWriter;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr.SchemaPageContext;

public class PageIOChannel {
    private final FileChannel channel;
    private final File pmtFile;
    private FileChannel readChannel;
    private final AtomicInteger logCounter;
    private SchemaFileLogWriter logWriter;
    protected FlushPageStrategy flushDirtyPagesStrategy;
    protected SinglePageFlushStrategy singlePageFlushStrategy;

    PageIOChannel(FileChannel channel, File pmtFile, boolean flushWithLogging, String logPath) throws IOException, MetadataException {
        this.channel = channel;
        this.pmtFile = pmtFile;
        this.readChannel = FileChannel.open(pmtFile.toPath(), StandardOpenOption.READ);
        if (flushWithLogging) {
            int pageAcc = (int)this.recoverFromLog(logPath) / 16384;
            this.logWriter = new SchemaFileLogWriter(logPath);
            this.logCounter = new AtomicInteger(pageAcc);
            this.flushDirtyPagesStrategy = this::flushDirtyPagesWithLogging;
            this.singlePageFlushStrategy = this::flushSinglePageWithLogging;
        } else {
            this.logCounter = new AtomicInteger();
            this.logWriter = null;
            this.flushDirtyPagesStrategy = this::flushDirtyPagesWithoutLogging;
            this.singlePageFlushStrategy = this::flushSinglePageWithoutLogging;
        }
    }

    public void renewLogWriter() throws IOException {
        if (this.logWriter != null) {
            this.logWriter = this.logWriter.renew();
        }
    }

    public void closeLogWriter() throws IOException {
        if (this.logWriter != null) {
            this.logWriter.close();
        }
    }

    private long recoverFromLog(String logPath) throws IOException, MetadataException {
        SchemaFileLogReader reader = new SchemaFileLogReader(logPath);
        List<byte[]> res = reader.collectUpdatedEntries();
        for (byte[] entry : res) {
            SchemaPage page = ISchemaPage.loadSchemaPage(ByteBuffer.wrap(entry));
            page.flushPageToChannel(this.channel);
        }
        reader.close();
        if (!res.isEmpty()) {
            try (FileOutputStream outputStream = new FileOutputStream(logPath, true);){
                outputStream.write(new byte[]{-1});
                long l = outputStream.getChannel().size();
                return l;
            }
        }
        return 0L;
    }

    public void loadFromFileToBuffer(ByteBuffer dst, int pageIndex) throws IOException {
        dst.clear();
        if (!this.readChannel.isOpen()) {
            this.readChannel = FileChannel.open(this.pmtFile.toPath(), StandardOpenOption.READ);
        }
        this.readChannel.read(dst, SchemaFile.getPageAddress(pageIndex));
    }

    private void flushDirtyPagesWithLogging(List<ISchemaPage> dirtyPages) throws IOException {
        if (dirtyPages.size() == 0) {
            return;
        }
        if (this.logCounter.get() > SchemaFileConfig.SCHEMA_FILE_LOG_SIZE) {
            this.logWriter = this.logWriter.renew();
            this.logCounter.set(0);
        }
        this.logCounter.addAndGet(dirtyPages.size());
        for (ISchemaPage page : dirtyPages) {
            page.syncPageBuffer();
            this.logWriter.write(page);
        }
        this.logWriter.prepare();
        for (ISchemaPage page : dirtyPages) {
            page.flushPageToChannel(this.channel);
        }
        this.logWriter.commit();
    }

    private void flushSinglePageWithLogging(ISchemaPage page) throws IOException {
        if (this.logCounter.get() > SchemaFileConfig.SCHEMA_FILE_LOG_SIZE) {
            this.logWriter = this.logWriter.renew();
            this.logCounter.set(0);
        }
        this.logCounter.addAndGet(1);
        page.syncPageBuffer();
        this.logWriter.write(page);
        this.logWriter.prepare();
        page.flushPageToChannel(this.channel);
        this.logWriter.commit();
    }

    private void flushDirtyPagesWithoutLogging(List<ISchemaPage> dirtyPages) throws IOException {
        for (ISchemaPage page : dirtyPages) {
            page.syncPageBuffer();
            page.flushPageToChannel(this.channel);
        }
    }

    private void flushSinglePageWithoutLogging(ISchemaPage page) throws IOException {
        page.syncPageBuffer();
        page.flushPageToChannel(this.channel);
    }

    public synchronized void flushMultiPages(SchemaPageContext cxt) throws IOException {
        this.flushDirtyPagesStrategy.apply(cxt.referredPages.values().stream().filter(ISchemaPage::isDirtyPage).collect(Collectors.toList()));
    }

    public void flushSinglePage(ISchemaPage page) throws IOException {
        this.singlePageFlushStrategy.apply(page);
    }

    @FunctionalInterface
    static interface SinglePageFlushStrategy {
        public void apply(ISchemaPage var1) throws IOException;
    }

    @FunctionalInterface
    static interface FlushPageStrategy {
        public void apply(List<ISchemaPage> var1) throws IOException;
    }
}

