/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.binary;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerPointReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.Transformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class BinaryTransformer
extends Transformer {
    protected final LayerPointReader leftPointReader;
    protected final LayerPointReader rightPointReader;
    protected final TSDataType leftPointReaderDataType;
    protected final TSDataType rightPointReaderDataType;
    protected final boolean isLeftPointReaderConstant;
    protected final boolean isRightPointReaderConstant;
    protected final boolean isCurrentConstant;

    protected BinaryTransformer(LayerPointReader leftPointReader, LayerPointReader rightPointReader) {
        this.leftPointReader = leftPointReader;
        this.rightPointReader = rightPointReader;
        this.leftPointReaderDataType = leftPointReader.getDataType();
        this.rightPointReaderDataType = rightPointReader.getDataType();
        this.isLeftPointReaderConstant = leftPointReader.isConstantPointReader();
        this.isRightPointReaderConstant = rightPointReader.isConstantPointReader();
        this.isCurrentConstant = this.isLeftPointReaderConstant && this.isRightPointReaderConstant;
        this.checkType();
    }

    protected abstract void checkType();

    @Override
    public boolean isConstantPointReader() {
        return this.isCurrentConstant;
    }

    @Override
    public YieldableState yieldValue() throws Exception {
        YieldableState leftYieldableState = this.leftPointReader.yield();
        YieldableState rightYieldableState = this.rightPointReader.yield();
        if (YieldableState.NOT_YIELDABLE_NO_MORE_DATA.equals((Object)leftYieldableState) || YieldableState.NOT_YIELDABLE_NO_MORE_DATA.equals((Object)rightYieldableState)) {
            return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
        }
        if (YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA.equals((Object)leftYieldableState) || YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA.equals((Object)rightYieldableState)) {
            return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
        }
        YieldableState timeYieldState = this.yieldTime();
        if (!YieldableState.YIELDABLE.equals((Object)timeYieldState)) {
            return timeYieldState;
        }
        if (this.leftPointReader.isCurrentNull() || this.rightPointReader.isCurrentNull()) {
            this.currentNull = true;
        } else {
            this.transformAndCache();
        }
        this.leftPointReader.readyForNext();
        this.rightPointReader.readyForNext();
        return YieldableState.YIELDABLE;
    }

    private YieldableState yieldTime() throws Exception {
        if (this.isCurrentConstant) {
            return YieldableState.YIELDABLE;
        }
        if (this.isLeftPointReaderConstant) {
            this.cachedTime = this.rightPointReader.currentTime();
            return YieldableState.YIELDABLE;
        }
        if (this.isRightPointReaderConstant) {
            this.cachedTime = this.leftPointReader.currentTime();
            return YieldableState.YIELDABLE;
        }
        long leftTime = this.leftPointReader.currentTime();
        long rightTime = this.rightPointReader.currentTime();
        while (leftTime != rightTime) {
            if (leftTime < rightTime) {
                this.leftPointReader.readyForNext();
                YieldableState leftYieldState = this.leftPointReader.yield();
                if (!YieldableState.YIELDABLE.equals((Object)leftYieldState)) {
                    return leftYieldState;
                }
                leftTime = this.leftPointReader.currentTime();
                continue;
            }
            this.rightPointReader.readyForNext();
            YieldableState rightYieldState = this.rightPointReader.yield();
            if (!YieldableState.YIELDABLE.equals((Object)rightYieldState)) {
                return rightYieldState;
            }
            rightTime = this.rightPointReader.currentTime();
        }
        this.cachedTime = leftTime;
        return YieldableState.YIELDABLE;
    }

    @Override
    protected boolean cacheValue() throws QueryProcessException, IOException {
        if (!this.leftPointReader.next() || !this.rightPointReader.next()) {
            return false;
        }
        if (!this.cacheTime()) {
            return false;
        }
        if (this.leftPointReader.isCurrentNull() || this.rightPointReader.isCurrentNull()) {
            this.currentNull = true;
        } else {
            this.transformAndCache();
        }
        this.leftPointReader.readyForNext();
        this.rightPointReader.readyForNext();
        return true;
    }

    protected abstract void transformAndCache() throws QueryProcessException, IOException;

    private boolean cacheTime() throws IOException, QueryProcessException {
        if (this.isCurrentConstant) {
            return true;
        }
        if (this.isLeftPointReaderConstant) {
            this.cachedTime = this.rightPointReader.currentTime();
            return true;
        }
        if (this.isRightPointReaderConstant) {
            this.cachedTime = this.leftPointReader.currentTime();
            return true;
        }
        long leftTime = this.leftPointReader.currentTime();
        long rightTime = this.rightPointReader.currentTime();
        while (leftTime != rightTime) {
            if (leftTime < rightTime) {
                this.leftPointReader.readyForNext();
                if (!this.leftPointReader.next()) {
                    return false;
                }
                leftTime = this.leftPointReader.currentTime();
                continue;
            }
            this.rightPointReader.readyForNext();
            if (!this.rightPointReader.next()) {
                return false;
            }
            rightTime = this.rightPointReader.currentTime();
        }
        this.cachedTime = leftTime;
        return true;
    }

    protected static double castCurrentValueToDoubleOperand(LayerPointReader layerPointReader, TSDataType layerPointReaderDataType) throws IOException, QueryProcessException {
        switch (layerPointReaderDataType) {
            case INT32: {
                return layerPointReader.currentInt();
            }
            case INT64: {
                return layerPointReader.currentLong();
            }
            case FLOAT: {
                return layerPointReader.currentFloat();
            }
            case DOUBLE: {
                return layerPointReader.currentDouble();
            }
            case BOOLEAN: {
                return layerPointReader.currentBoolean() ? 1.0 : 0.0;
            }
        }
        throw new QueryProcessException("Unsupported data type: " + layerPointReader.getDataType().toString());
    }
}

