/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.crud;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.DataTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.DuplicateInsertException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaValidation;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public abstract class InsertBaseStatement
extends Statement {
    protected PartialPath devicePath;
    protected boolean isAligned;
    protected MeasurementSchema[] measurementSchemas;
    protected String[] measurements;
    protected TSDataType[] dataTypes;
    protected Map<Integer, FailedMeasurementInfo> failedMeasurementIndex2Info;
    List<LogicalViewSchema> logicalViewSchemaList;
    List<Integer> indexOfSourcePathsOfLogicalViews;
    int recordedBeginOfLogicalViewSchemaList = 0;
    int recordedEndOfLogicalViewSchemaList = 0;

    public PartialPath getDevicePath() {
        return this.devicePath;
    }

    public void setDevicePath(PartialPath devicePath) {
        this.devicePath = devicePath;
    }

    public String[] getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(String[] measurements) {
        this.measurements = measurements;
    }

    public MeasurementSchema[] getMeasurementSchemas() {
        return this.measurementSchemas;
    }

    public void setMeasurementSchemas(MeasurementSchema[] measurementSchemas) {
        this.measurementSchemas = measurementSchemas;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public void setAligned(boolean aligned) {
        this.isAligned = aligned;
    }

    public TSDataType[] getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(TSDataType[] dataTypes) {
        this.dataTypes = dataTypes;
    }

    public abstract boolean isEmpty();

    @Override
    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        List<PartialPath> checkedPaths = this.getPaths().stream().distinct().collect(Collectors.toList());
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkFullPathListPermission(userName, checkedPaths, PrivilegeType.WRITE_DATA.ordinal()), checkedPaths, PrivilegeType.WRITE_DATA);
    }

    public abstract ISchemaValidation getSchemaValidation();

    public abstract List<ISchemaValidation> getSchemaValidationList();

    public void updateAfterSchemaValidation() throws QueryProcessException {
    }

    protected void selfCheckDataTypes(int index) throws DataTypeMismatchException, PathNotExistException {
        if (IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
            if (this.measurementSchemas[index] == null) {
                this.markFailedMeasurement(index, (Exception)((Object)new PathNotExistException(this.devicePath.concatNode(this.measurements[index]).getFullPath())));
            } else if (this.dataTypes[index] != this.measurementSchemas[index].getType() && !this.checkAndCastDataType(index, this.measurementSchemas[index].getType())) {
                this.markFailedMeasurement(index, (Exception)((Object)new DataTypeMismatchException(this.devicePath.getFullPath(), this.measurements[index], this.dataTypes[index], this.measurementSchemas[index].getType(), this.getMinTime(), this.getFirstValueOfIndex(index))));
            }
        } else {
            if (this.measurementSchemas[index] == null) {
                throw new PathNotExistException(this.devicePath.concatNode(this.measurements[index]).getFullPath());
            }
            if (this.dataTypes[index] != this.measurementSchemas[index].getType() && !this.checkAndCastDataType(index, this.measurementSchemas[index].getType())) {
                throw new DataTypeMismatchException(this.devicePath.getFullPath(), this.measurements[index], this.dataTypes[index], this.measurementSchemas[index].getType(), this.getMinTime(), this.getFirstValueOfIndex(index));
            }
        }
    }

    protected abstract boolean checkAndCastDataType(int var1, TSDataType var2);

    public abstract long getMinTime();

    public abstract Object getFirstValueOfIndex(int var1);

    public void markFailedMeasurement(int index, Exception cause) {
        throw new UnsupportedOperationException();
    }

    public boolean hasValidMeasurements() {
        for (String o : this.measurements) {
            if (o == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasFailedMeasurements() {
        return this.failedMeasurementIndex2Info != null && !this.failedMeasurementIndex2Info.isEmpty();
    }

    public int getFailedMeasurementNumber() {
        return this.failedMeasurementIndex2Info == null ? 0 : this.failedMeasurementIndex2Info.size();
    }

    public List<String> getFailedMeasurements() {
        return this.failedMeasurementIndex2Info == null ? Collections.emptyList() : this.failedMeasurementIndex2Info.values().stream().map(info -> info.measurement).collect(Collectors.toList());
    }

    public List<Exception> getFailedExceptions() {
        return this.failedMeasurementIndex2Info == null ? Collections.emptyList() : this.failedMeasurementIndex2Info.values().stream().map(info -> info.cause).collect(Collectors.toList());
    }

    public List<String> getFailedMessages() {
        return this.failedMeasurementIndex2Info == null ? Collections.emptyList() : this.failedMeasurementIndex2Info.values().stream().map(info -> {
            Throwable cause = info.cause;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            return cause.getMessage();
        }).collect(Collectors.toList());
    }

    public abstract InsertBaseStatement removeLogicalView();

    public void setFailedMeasurementIndex2Info(Map<Integer, FailedMeasurementInfo> failedMeasurementIndex2Info) {
        this.failedMeasurementIndex2Info = failedMeasurementIndex2Info;
    }

    protected Map<PartialPath, List<Pair<String, Integer>>> getMapFromDeviceToMeasurementAndIndex() {
        boolean[] isLogicalView = new boolean[this.measurements.length];
        int[] indexMapToLogicalViewList = new int[this.measurements.length];
        Arrays.fill(isLogicalView, false);
        if (this.indexOfSourcePathsOfLogicalViews != null) {
            int i = 0;
            while (i < this.indexOfSourcePathsOfLogicalViews.size()) {
                int realIndex = this.indexOfSourcePathsOfLogicalViews.get(i);
                isLogicalView[realIndex] = true;
                indexMapToLogicalViewList[realIndex] = i++;
            }
        }
        HashMap<PartialPath, List<Pair<String, Integer>>> mapFromDeviceToMeasurementAndIndex = new HashMap<PartialPath, List<Pair<String, Integer>>>();
        int i = 0;
        while (i < this.measurements.length) {
            String measurementName;
            PartialPath targetDevicePath;
            if (isLogicalView[i]) {
                int viewIndex = indexMapToLogicalViewList[i];
                targetDevicePath = this.logicalViewSchemaList.get(viewIndex).getSourcePathIfWritable().getDevicePath();
                measurementName = this.logicalViewSchemaList.get(viewIndex).getSourcePathIfWritable().getMeasurement();
            } else {
                targetDevicePath = this.devicePath;
                measurementName = this.measurements[i];
            }
            int index = i++;
            String finalMeasurementName = measurementName;
            mapFromDeviceToMeasurementAndIndex.compute(targetDevicePath, (k, v) -> {
                if (v == null) {
                    ArrayList<Pair> valueList = new ArrayList<Pair>();
                    valueList.add(new Pair((Object)finalMeasurementName, (Object)index));
                    return valueList;
                }
                v.add(new Pair((Object)finalMeasurementName, (Object)index));
                return v;
            });
        }
        InsertBaseStatement.validateMapFromDeviceToMeasurement(mapFromDeviceToMeasurementAndIndex);
        return mapFromDeviceToMeasurementAndIndex;
    }

    protected static void validateMapFromDeviceToMeasurement(Map<PartialPath, List<Pair<String, Integer>>> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<PartialPath, List<Pair<String, Integer>>> entry : map.entrySet()) {
            List<Pair<String, Integer>> measurementList = entry.getValue();
            if (measurementList.size() <= 1) continue;
            HashSet<String> measurementSet = new HashSet<String>();
            for (Pair<String, Integer> thisPair : measurementList) {
                boolean measurementNotExists = measurementSet.add((String)thisPair.left);
                if (measurementNotExists) continue;
                PartialPath devicePath = entry.getKey();
                throw new SemanticException((Throwable)((Object)new DuplicateInsertException(devicePath.getFullPath(), (String)thisPair.left)));
            }
        }
    }

    protected static class FailedMeasurementInfo {
        protected String measurement;
        protected TSDataType dataType;
        protected Object value;
        protected Exception cause;

        public FailedMeasurementInfo(String measurement, TSDataType dataType, Object value, Exception cause) {
            this.measurement = measurement;
            this.dataType = dataType;
            this.value = value;
            this.cause = cause;
        }
    }
}

