/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.load;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.queryengine.execution.load.TsFileData;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFilePieceNode
extends WritePlanNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFilePieceNode.class);
    private File tsFile;
    private long dataSize;
    private List<TsFileData> tsFileDataList;

    public LoadTsFilePieceNode(PlanNodeId id) {
        super(id);
    }

    public LoadTsFilePieceNode(PlanNodeId id, File tsFile) {
        super(id);
        this.tsFile = tsFile;
        this.dataSize = 0L;
        this.tsFileDataList = new ArrayList<TsFileData>();
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public void addTsFileData(TsFileData tsFileData) {
        this.tsFileDataList.add(tsFileData);
        this.dataSize += tsFileData.getDataSize();
    }

    public List<TsFileData> getAllTsFileData() {
        return this.tsFileDataList;
    }

    public File getTsFile() {
        return this.tsFile;
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return null;
    }

    @Override
    public List<PlanNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("clone of load piece TsFile is not implemented");
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return Collections.emptyList();
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        try {
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(byteOutputStream);
            this.serializeAttributes(stream);
            byteBuffer.put(byteOutputStream.toByteArray());
        }
        catch (IOException e) {
            LOGGER.error("Serialize to ByteBuffer error.", (Throwable)e);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.LOAD_TSFILE.serialize(stream);
        ReadWriteIOUtils.write((String)this.tsFile.getPath(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.tsFileDataList.size(), (OutputStream)stream);
        for (TsFileData tsFileData : this.tsFileDataList) {
            try {
                tsFileData.serialize(stream);
            }
            catch (IOException e) {
                LOGGER.error(String.format("Serialize data of TsFile %s error, skip TsFileData %s", this.tsFile.getPath(), tsFileData));
            }
        }
    }

    @Override
    public List<WritePlanNode> splitByPartition(Analysis analysis) {
        throw new NotImplementedException("split load piece TsFile is not implemented");
    }

    public static PlanNode deserialize(ByteBuffer buffer) {
        ByteArrayInputStream stream = new ByteArrayInputStream(buffer.array());
        try {
            ReadWriteIOUtils.readShort((InputStream)stream);
            File tsFile = new File(ReadWriteIOUtils.readString((InputStream)stream));
            LoadTsFilePieceNode pieceNode = new LoadTsFilePieceNode(new PlanNodeId(""), tsFile);
            int tsFileDataSize = ReadWriteIOUtils.readInt((InputStream)stream);
            for (int i = 0; i < tsFileDataSize; ++i) {
                TsFileData tsFileData = TsFileData.deserialize(stream);
                pieceNode.addTsFileData(tsFileData);
            }
            pieceNode.setPlanNodeId(PlanNodeId.deserialize(stream));
            return pieceNode;
        }
        catch (IOException | IllegalPathException | PageException e) {
            LOGGER.error("Deserialize {} error.", (Object)LoadTsFilePieceNode.class.getName(), (Object)e);
            return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadTsFilePieceNode loadTsFilePieceNode = (LoadTsFilePieceNode)o;
        return Objects.equals(this.tsFile, loadTsFilePieceNode.tsFile) && Objects.equals(this.dataSize, loadTsFilePieceNode.dataSize) && Objects.equals(this.tsFileDataList, loadTsFilePieceNode.tsFileDataList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tsFile, this.dataSize, this.tsFileDataList);
    }

    public String toString() {
        return "LoadTsFilePieceNode{tsFile=" + this.tsFile + ", dataSize=" + this.dataSize + '}';
    }
}

