/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.parser;

import com.google.common.collect.ImmutableSet;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TTimedQuota;
import org.apache.iotdb.common.rpc.thrift.ThrottleType;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cq.TimeoutPolicy;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterFactory;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.qp.sql.IoTDBSqlParser;
import org.apache.iotdb.db.qp.sql.IoTDBSqlParserBaseVisitor;
import org.apache.iotdb.db.queryengine.execution.operator.window.WindowType;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.binary.AdditionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.CompareBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.DivisionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.EqualToExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.GreaterEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LessEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.ModuloExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.MultiplicationExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.NonEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.SubtractionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.WhenThenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.NullOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.multi.builtin.BuiltInScalarFunctionHelperFactory;
import org.apache.iotdb.db.queryengine.plan.expression.other.CaseWhenThenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.ternary.BetweenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.InExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.IsNullExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LogicNotExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.NegationExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.RegularExpression;
import org.apache.iotdb.db.queryengine.plan.optimization.LimitOffsetPushDown;
import org.apache.iotdb.db.queryengine.plan.statement.AuthorType;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.component.FillComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.FillPolicy;
import org.apache.iotdb.db.queryengine.plan.statement.component.FromComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByConditionComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByCountComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByLevelComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupBySessionComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByTagComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByTimeComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByVariationComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.HavingCondition;
import org.apache.iotdb.db.queryengine.plan.statement.component.IntoComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.IntoItem;
import org.apache.iotdb.db.queryengine.plan.statement.component.NullOrdering;
import org.apache.iotdb.db.queryengine.plan.statement.component.OrderByComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.queryengine.plan.statement.component.ResultSetFormat;
import org.apache.iotdb.db.queryengine.plan.statement.component.SelectComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.SortItem;
import org.apache.iotdb.db.queryengine.plan.statement.component.WhereCondition;
import org.apache.iotdb.db.queryengine.plan.statement.crud.DeleteDataStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.queryengine.plan.statement.literal.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.statement.literal.DoubleLiteral;
import org.apache.iotdb.db.queryengine.plan.statement.literal.Literal;
import org.apache.iotdb.db.queryengine.plan.statement.literal.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.statement.literal.StringLiteral;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.AlterTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountDatabaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountDevicesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountLevelTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountNodesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountTimeSlotListStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateContinuousQueryStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateFunctionStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateTriggerStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DatabaseSchemaStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DeleteDatabaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DeleteTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DropContinuousQueryStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DropFunctionStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DropTriggerStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.GetRegionIdStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.GetSeriesSlotListStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.GetTimeSlotListStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.MigrateRegionStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.SetTTLStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowChildNodesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowChildPathsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowClusterIdStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowClusterStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowConfigNodesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowContinuousQueriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowCurrentTimestampStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowDataNodesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowDatabaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowDevicesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowFunctionsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowRegionStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowTTLStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowTriggersStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowVariablesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.UnSetTTLStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.CreatePipePluginStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.CreatePipeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.DropPipePluginStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.DropPipeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.ShowPipePluginsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.ShowPipesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.StartPipeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.StopPipeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.AlterSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.CreateSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.DeactivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.DropSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.SetSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowNodesInSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowPathSetTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowPathsUsingTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.UnsetSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.AlterLogicalViewStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.CreateLogicalViewStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.DeleteLogicalViewStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.ShowLogicalViewStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.AuthorStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.ClearCacheStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.ExplainStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.FlushStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.KillQueryStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.LoadConfigurationStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.MergeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.SetSystemStatusStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.ShowQueriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.ShowVersionStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.StartRepairDataStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.StopRepairDataStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.quota.SetSpaceQuotaStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.quota.SetThrottleQuotaStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.quota.ShowSpaceQuotaStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.quota.ShowThrottleQuotaStatement;
import org.apache.iotdb.db.schemaengine.template.TemplateAlterOperationType;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.iotdb.db.utils.constant.SqlConstant;
import org.apache.iotdb.trigger.api.enums.TriggerEvent;
import org.apache.iotdb.trigger.api.enums.TriggerType;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.common.constant.TsFileConstant;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.utils.TimeDuration;

public class ASTVisitor
extends IoTDBSqlParserBaseVisitor<Statement> {
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final String DELETE_RANGE_ERROR_MSG = "For delete statement, where clause can only contain atomic expressions like : time > XXX, time <= XXX, or two atomic expressions connected by 'AND'";
    private static final String DELETE_ONLY_SUPPORT_TIME_EXP_ERROR_MSG = "For delete statement, where clause can only contain time expressions, value filter is not currently supported.";
    private static final String GROUP_BY_COMMON_ONLY_ONE_MSG = "Only one of group by time or group by variation/series/session can be supported at a time";
    private static final String LIMIT_CONFIGURATION_ENABLED_ERROR_MSG = "Limit configuration is not enabled, please enable it first.";
    private static final String NODE_NAME_IN_INTO_PATH_MATCHER = "([a-zA-Z0-9_${}\\u2E80-\\u9FFF]+)";
    private static final Pattern NODE_NAME_IN_INTO_PATH_PATTERN = Pattern.compile("([a-zA-Z0-9_${}\\u2E80-\\u9FFF]+)");
    private static final String IGNORENULL = "IgnoreNull";
    private ZoneId zoneId;
    private boolean useWildcard = false;
    private boolean lastLevelUseWildcard = false;

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public Statement visitSingleStatement(IoTDBSqlParser.SingleStatementContext ctx) {
        Statement statement = (Statement)this.visit((ParseTree)ctx.statement());
        if (ctx.DEBUG() != null) {
            statement.setDebug(true);
        }
        return statement;
    }

    public Statement visitCreateNonAlignedTimeseries(IoTDBSqlParser.CreateNonAlignedTimeseriesContext ctx) {
        CreateTimeSeriesStatement createTimeSeriesStatement = new CreateTimeSeriesStatement();
        createTimeSeriesStatement.setPath(this.parseFullPath(ctx.fullPath()));
        if (ctx.attributeClauses() != null) {
            this.parseAttributeClausesForCreateNonAlignedTimeSeries(ctx.attributeClauses(), createTimeSeriesStatement);
        }
        return createTimeSeriesStatement;
    }

    public Statement visitCreateAlignedTimeseries(IoTDBSqlParser.CreateAlignedTimeseriesContext ctx) {
        CreateAlignedTimeSeriesStatement createAlignedTimeSeriesStatement = new CreateAlignedTimeSeriesStatement();
        createAlignedTimeSeriesStatement.setDevicePath(this.parseFullPath(ctx.fullPath()));
        this.parseAlignedMeasurements(ctx.alignedMeasurements(), createAlignedTimeSeriesStatement);
        return createAlignedTimeSeriesStatement;
    }

    public void parseAlignedMeasurements(IoTDBSqlParser.AlignedMeasurementsContext ctx, CreateAlignedTimeSeriesStatement createAlignedTimeSeriesStatement) {
        for (int i = 0; i < ctx.nodeNameWithoutWildcard().size(); ++i) {
            createAlignedTimeSeriesStatement.addMeasurement(this.parseNodeNameWithoutWildCard(ctx.nodeNameWithoutWildcard(i)));
            this.parseAttributeClausesForCreateAlignedTimeSeries(ctx.attributeClauses(i), createAlignedTimeSeriesStatement);
        }
    }

    public void parseAttributeClausesForCreateNonAlignedTimeSeries(IoTDBSqlParser.AttributeClausesContext ctx, CreateTimeSeriesStatement createTimeSeriesStatement) {
        if (ctx.aliasNodeName() != null) {
            createTimeSeriesStatement.setAlias(this.parseNodeName(ctx.aliasNodeName().nodeName()));
        }
        HashMap<String, String> props = new HashMap<String, String>();
        TSDataType dataType = this.parseDataTypeAttribute(ctx);
        if (dataType != null) {
            props.put("dataType".toLowerCase(), dataType.toString().toLowerCase());
        }
        List attributePairs = ctx.attributePair();
        if (ctx.attributePair(0) != null) {
            for (IoTDBSqlParser.AttributePairContext attributePair : attributePairs) {
                props.put(this.parseAttributeKey(attributePair.attributeKey()).toLowerCase(), this.parseAttributeValue(attributePair.attributeValue()).toLowerCase());
            }
        }
        createTimeSeriesStatement.setProps(props);
        this.checkPropsInCreateTimeSeries(createTimeSeriesStatement);
        if (ctx.tagClause() != null) {
            this.parseTagClause(ctx.tagClause(), createTimeSeriesStatement);
        }
        if (ctx.attributeClause() != null) {
            this.parseAttributeClauseForTimeSeries(ctx.attributeClause(), createTimeSeriesStatement);
        }
    }

    private void checkPropsInCreateTimeSeries(CreateTimeSeriesStatement createTimeSeriesStatement) {
        Map<String, String> props = createTimeSeriesStatement.getProps();
        if (props != null && props.containsKey("dataType".toLowerCase())) {
            String datatypeString = props.get("dataType".toLowerCase()).toUpperCase();
            try {
                createTimeSeriesStatement.setDataType(TSDataType.valueOf((String)datatypeString));
                props.remove("dataType".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("Unsupported datatype: %s", datatypeString));
            }
        }
        if (createTimeSeriesStatement.getDataType() == null) {
            throw new SemanticException("datatype must be declared");
        }
        IoTDBDescriptor ioTDBDescriptor = IoTDBDescriptor.getInstance();
        createTimeSeriesStatement.setEncoding(ioTDBDescriptor.getDefaultEncodingByType(createTimeSeriesStatement.getDataType()));
        if (props != null && props.containsKey("encoding".toLowerCase())) {
            String encodingString = props.get("encoding".toLowerCase()).toUpperCase();
            try {
                createTimeSeriesStatement.setEncoding(TSEncoding.valueOf((String)encodingString));
                props.remove("encoding".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("Unsupported encoding: %s", encodingString));
            }
        }
        createTimeSeriesStatement.setCompressor(TSFileDescriptor.getInstance().getConfig().getCompressor());
        if (props != null && props.containsKey("compression".toLowerCase())) {
            String compressionString = props.get("compression".toLowerCase()).toUpperCase();
            try {
                createTimeSeriesStatement.setCompressor(CompressionType.valueOf((String)compressionString));
                props.remove("compression".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("Unsupported compression: %s", compressionString));
            }
        }
        if (props != null && props.containsKey("compressor".toLowerCase())) {
            String compressorString = props.get("compressor".toLowerCase()).toUpperCase();
            try {
                createTimeSeriesStatement.setCompressor(CompressionType.valueOf((String)compressorString));
                props.remove("compressor".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("Unsupported compression: %s", compressorString));
            }
        }
        createTimeSeriesStatement.setProps(props);
    }

    public void parseAttributeClausesForCreateAlignedTimeSeries(IoTDBSqlParser.AttributeClausesContext ctx, CreateAlignedTimeSeriesStatement createAlignedTimeSeriesStatement) {
        if (ctx.aliasNodeName() != null) {
            createAlignedTimeSeriesStatement.addAliasList(this.parseNodeName(ctx.aliasNodeName().nodeName()));
        } else {
            createAlignedTimeSeriesStatement.addAliasList(null);
        }
        TSDataType dataType = this.parseDataTypeAttribute(ctx);
        createAlignedTimeSeriesStatement.addDataType(dataType);
        HashMap<String, String> props = new HashMap<String, String>();
        if (ctx.attributePair() != null) {
            for (int i = 0; i < ctx.attributePair().size(); ++i) {
                props.put(this.parseAttributeKey(ctx.attributePair(i).attributeKey()).toLowerCase(), this.parseAttributeValue(ctx.attributePair(i).attributeValue()));
            }
        }
        TSEncoding encoding = IoTDBDescriptor.getInstance().getDefaultEncodingByType(dataType);
        if (props.containsKey("encoding".toLowerCase())) {
            String encodingString = ((String)props.get("encoding".toLowerCase())).toUpperCase();
            try {
                encoding = TSEncoding.valueOf((String)encodingString);
                createAlignedTimeSeriesStatement.addEncoding(encoding);
                props.remove("encoding".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported encoding: %s", encodingString));
            }
        } else {
            createAlignedTimeSeriesStatement.addEncoding(encoding);
        }
        CompressionType compressor = TSFileDescriptor.getInstance().getConfig().getCompressor();
        if (props.containsKey("compressor".toLowerCase())) {
            String compressorString = ((String)props.get("compressor".toLowerCase())).toUpperCase();
            try {
                compressor = CompressionType.valueOf((String)compressorString);
                createAlignedTimeSeriesStatement.addCompressor(compressor);
                props.remove("compressor".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported compressor: %s", compressorString));
            }
        } else if (props.containsKey("compression".toLowerCase())) {
            String compressionString = ((String)props.get("compression".toLowerCase())).toUpperCase();
            try {
                compressor = CompressionType.valueOf((String)compressionString);
                createAlignedTimeSeriesStatement.addCompressor(compressor);
                props.remove("compression".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported compression: %s", compressionString));
            }
        } else {
            createAlignedTimeSeriesStatement.addCompressor(compressor);
        }
        if (props.size() > 0) {
            throw new SemanticException("create aligned timeseries: property is not supported yet.");
        }
        if (ctx.tagClause() != null) {
            this.parseTagClause(ctx.tagClause(), createAlignedTimeSeriesStatement);
        } else {
            createAlignedTimeSeriesStatement.addTagsList(null);
        }
        if (ctx.attributeClause() != null) {
            this.parseAttributeClauseForTimeSeries(ctx.attributeClause(), createAlignedTimeSeriesStatement);
        } else {
            createAlignedTimeSeriesStatement.addAttributesList(null);
        }
    }

    public void parseTagClause(IoTDBSqlParser.TagClauseContext ctx, Statement statement) {
        Map<String, String> tags = this.extractMap(ctx.attributePair(), ctx.attributePair(0));
        if (statement instanceof CreateTimeSeriesStatement) {
            ((CreateTimeSeriesStatement)statement).setTags(tags);
        } else if (statement instanceof CreateAlignedTimeSeriesStatement) {
            ((CreateAlignedTimeSeriesStatement)statement).addTagsList(tags);
        } else if (statement instanceof AlterTimeSeriesStatement) {
            ((AlterTimeSeriesStatement)statement).setTagsMap(tags);
        }
    }

    public void parseAttributeClauseForTimeSeries(IoTDBSqlParser.AttributeClauseContext ctx, Statement statement) {
        Map<String, String> attributes = this.extractMap(ctx.attributePair(), ctx.attributePair(0));
        if (statement instanceof CreateTimeSeriesStatement) {
            ((CreateTimeSeriesStatement)statement).setAttributes(attributes);
        } else if (statement instanceof CreateAlignedTimeSeriesStatement) {
            ((CreateAlignedTimeSeriesStatement)statement).addAttributesList(attributes);
        } else if (statement instanceof AlterTimeSeriesStatement) {
            ((AlterTimeSeriesStatement)statement).setAttributesMap(attributes);
        }
    }

    public Statement visitAlterTimeseries(IoTDBSqlParser.AlterTimeseriesContext ctx) {
        AlterTimeSeriesStatement alterTimeSeriesStatement = new AlterTimeSeriesStatement();
        alterTimeSeriesStatement.setPath(this.parseFullPath(ctx.fullPath()));
        this.parseAlterClause(ctx.alterClause(), alterTimeSeriesStatement);
        return alterTimeSeriesStatement;
    }

    private void parseAlterClause(IoTDBSqlParser.AlterClauseContext ctx, AlterTimeSeriesStatement alterTimeSeriesStatement) {
        HashMap<String, String> alterMap = new HashMap<String, String>();
        if (ctx.RENAME() != null) {
            alterTimeSeriesStatement.setAlterType(AlterTimeSeriesStatement.AlterType.RENAME);
            alterMap.put(this.parseAttributeKey(ctx.beforeName), this.parseAttributeKey(ctx.currentName));
        } else if (ctx.SET() != null) {
            alterTimeSeriesStatement.setAlterType(AlterTimeSeriesStatement.AlterType.SET);
            this.setMap(ctx, alterMap);
        } else if (ctx.DROP() != null) {
            alterTimeSeriesStatement.setAlterType(AlterTimeSeriesStatement.AlterType.DROP);
            for (int i = 0; i < ctx.attributeKey().size(); ++i) {
                alterMap.put(this.parseAttributeKey((IoTDBSqlParser.AttributeKeyContext)ctx.attributeKey().get(i)), null);
            }
        } else if (ctx.TAGS() != null) {
            alterTimeSeriesStatement.setAlterType(AlterTimeSeriesStatement.AlterType.ADD_TAGS);
            this.setMap(ctx, alterMap);
        } else if (ctx.ATTRIBUTES() != null) {
            alterTimeSeriesStatement.setAlterType(AlterTimeSeriesStatement.AlterType.ADD_ATTRIBUTES);
            this.setMap(ctx, alterMap);
        } else {
            alterTimeSeriesStatement.setAlterType(AlterTimeSeriesStatement.AlterType.UPSERT);
            if (ctx.aliasClause() != null) {
                this.parseAliasClause(ctx.aliasClause(), alterTimeSeriesStatement);
            }
            if (ctx.tagClause() != null) {
                this.parseTagClause(ctx.tagClause(), alterTimeSeriesStatement);
            }
            if (ctx.attributeClause() != null) {
                this.parseAttributeClauseForTimeSeries(ctx.attributeClause(), alterTimeSeriesStatement);
            }
        }
        alterTimeSeriesStatement.setAlterMap(alterMap);
    }

    public void parseAliasClause(IoTDBSqlParser.AliasClauseContext ctx, AlterTimeSeriesStatement alterTimeSeriesStatement) {
        if (alterTimeSeriesStatement != null && ctx.ALIAS() != null) {
            alterTimeSeriesStatement.setAlias(this.parseAliasNode(ctx.alias()));
        }
    }

    public Statement visitDropTimeseries(IoTDBSqlParser.DropTimeseriesContext ctx) {
        DeleteTimeSeriesStatement deleteTimeSeriesStatement = new DeleteTimeSeriesStatement();
        ArrayList<PartialPath> partialPaths = new ArrayList<PartialPath>();
        for (IoTDBSqlParser.PrefixPathContext prefixPathContext : ctx.prefixPath()) {
            partialPaths.add(this.parsePrefixPath(prefixPathContext));
        }
        deleteTimeSeriesStatement.setPathPatternList(partialPaths);
        return deleteTimeSeriesStatement;
    }

    public Statement visitShowTimeseries(IoTDBSqlParser.ShowTimeseriesContext ctx) {
        boolean orderByHeat = ctx.LATEST() != null;
        ShowTimeSeriesStatement showTimeSeriesStatement = ctx.prefixPath() != null ? new ShowTimeSeriesStatement(this.parsePrefixPath(ctx.prefixPath()), orderByHeat) : new ShowTimeSeriesStatement(new PartialPath(SqlConstant.getSingleRootArray()), orderByHeat);
        if (ctx.timeseriesWhereClause() != null) {
            SchemaFilter schemaFilter = this.parseTimeseriesWhereClause(ctx.timeseriesWhereClause());
            showTimeSeriesStatement.setSchemaFilter(schemaFilter);
        }
        if (ctx.rowPaginationClause() != null) {
            if (ctx.rowPaginationClause().limitClause() != null) {
                showTimeSeriesStatement.setLimit(this.parseLimitClause(ctx.rowPaginationClause().limitClause()));
            }
            if (ctx.rowPaginationClause().offsetClause() != null) {
                showTimeSeriesStatement.setOffset(this.parseOffsetClause(ctx.rowPaginationClause().offsetClause()));
            }
        }
        return showTimeSeriesStatement;
    }

    private SchemaFilter parseTimeseriesWhereClause(IoTDBSqlParser.TimeseriesWhereClauseContext ctx) {
        if (ctx.timeseriesContainsExpression() != null) {
            return SchemaFilterFactory.createPathContainsFilter((String)this.parseStringLiteral(ctx.timeseriesContainsExpression().value.getText()));
        }
        if (ctx.columnEqualsExpression() != null) {
            return this.parseColumnEqualsExpressionContext(ctx.columnEqualsExpression());
        }
        if (ctx.tagContainsExpression() != null) {
            return SchemaFilterFactory.createTagFilter((String)this.parseAttributeKey(ctx.tagContainsExpression().attributeKey()), (String)this.parseStringLiteral(ctx.tagContainsExpression().value.getText()), (boolean)true);
        }
        return SchemaFilterFactory.createTagFilter((String)this.parseAttributeKey(ctx.tagEqualsExpression().attributeKey()), (String)this.parseAttributeValue(ctx.tagEqualsExpression().attributeValue()), (boolean)false);
    }

    private SchemaFilter parseColumnEqualsExpressionContext(IoTDBSqlParser.ColumnEqualsExpressionContext ctx) {
        String column = this.parseAttributeKey(ctx.attributeKey());
        String value = this.parseAttributeValue(ctx.attributeValue());
        if (column.equalsIgnoreCase("dataType")) {
            try {
                TSDataType dataType = TSDataType.valueOf((String)value.toUpperCase());
                return SchemaFilterFactory.createDataTypeFilter((TSDataType)dataType);
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported datatype: %s", value));
            }
        }
        throw new SemanticException("unexpected filter key");
    }

    public Statement visitShowDatabases(IoTDBSqlParser.ShowDatabasesContext ctx) {
        ShowDatabaseStatement showDatabaseStatement = ctx.prefixPath() != null ? new ShowDatabaseStatement(this.parsePrefixPath(ctx.prefixPath())) : new ShowDatabaseStatement(new PartialPath(SqlConstant.getSingleRootArray()));
        showDatabaseStatement.setDetailed(ctx.DETAILS() != null);
        return showDatabaseStatement;
    }

    public Statement visitShowDevices(IoTDBSqlParser.ShowDevicesContext ctx) {
        ShowDevicesStatement showDevicesStatement = ctx.prefixPath() != null ? new ShowDevicesStatement(this.parsePrefixPath(ctx.prefixPath())) : new ShowDevicesStatement(new PartialPath(SqlConstant.getSingleRootArray()));
        if (ctx.devicesWhereClause() != null) {
            showDevicesStatement.setSchemaFilter(this.parseDevicesWhereClause(ctx.devicesWhereClause()));
        }
        if (ctx.rowPaginationClause() != null) {
            if (ctx.rowPaginationClause().limitClause() != null) {
                showDevicesStatement.setLimit(this.parseLimitClause(ctx.rowPaginationClause().limitClause()));
            }
            if (ctx.rowPaginationClause().offsetClause() != null) {
                showDevicesStatement.setOffset(this.parseOffsetClause(ctx.rowPaginationClause().offsetClause()));
            }
        }
        if (ctx.WITH() != null) {
            showDevicesStatement.setSgCol(true);
        }
        return showDevicesStatement;
    }

    private SchemaFilter parseDevicesWhereClause(IoTDBSqlParser.DevicesWhereClauseContext ctx) {
        if (ctx.deviceContainsExpression() != null) {
            return SchemaFilterFactory.createPathContainsFilter((String)this.parseStringLiteral(ctx.deviceContainsExpression().value.getText()));
        }
        String templateName = null;
        boolean isEqual = true;
        if (ctx.templateEqualExpression().operator_is() != null) {
            if (ctx.templateEqualExpression().operator_not() != null) {
                isEqual = false;
            }
        } else {
            templateName = this.parseStringLiteral(ctx.templateEqualExpression().templateName.getText());
            if (ctx.templateEqualExpression().OPERATOR_NEQ() != null) {
                isEqual = false;
            }
        }
        return SchemaFilterFactory.createTemplateNameFilter(templateName, (boolean)isEqual);
    }

    public Statement visitCountDevices(IoTDBSqlParser.CountDevicesContext ctx) {
        PartialPath path = ctx.prefixPath() != null ? this.parsePrefixPath(ctx.prefixPath()) : new PartialPath(SqlConstant.getSingleRootArray());
        return new CountDevicesStatement(path);
    }

    public Statement visitCountTimeseries(IoTDBSqlParser.CountTimeseriesContext ctx) {
        CountStatement statement;
        PartialPath path = ctx.prefixPath() != null ? this.parsePrefixPath(ctx.prefixPath()) : new PartialPath(SqlConstant.getSingleRootArray());
        if (ctx.INTEGER_LITERAL() != null) {
            int level = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
            statement = new CountLevelTimeSeriesStatement(path, level);
        } else {
            statement = new CountTimeSeriesStatement(path);
        }
        if (ctx.timeseriesWhereClause() != null) {
            SchemaFilter schemaFilter = this.parseTimeseriesWhereClause(ctx.timeseriesWhereClause());
            if (statement instanceof CountTimeSeriesStatement) {
                ((CountTimeSeriesStatement)statement).setSchemaFilter(schemaFilter);
            } else if (statement instanceof CountLevelTimeSeriesStatement) {
                ((CountLevelTimeSeriesStatement)statement).setSchemaFilter(schemaFilter);
            }
        }
        return statement;
    }

    public Statement visitCountNodes(IoTDBSqlParser.CountNodesContext ctx) {
        PartialPath path = ctx.prefixPath() != null ? this.parsePrefixPath(ctx.prefixPath()) : new PartialPath(SqlConstant.getSingleRootArray());
        int level = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
        return new CountNodesStatement(path, level);
    }

    public Statement visitCountDatabases(IoTDBSqlParser.CountDatabasesContext ctx) {
        PartialPath path = ctx.prefixPath() != null ? this.parsePrefixPath(ctx.prefixPath()) : new PartialPath(SqlConstant.getSingleRootArray());
        return new CountDatabaseStatement(path);
    }

    public Statement visitShowVersion(IoTDBSqlParser.ShowVersionContext ctx) {
        return new ShowVersionStatement();
    }

    public Statement visitCreateFunction(IoTDBSqlParser.CreateFunctionContext ctx) {
        if (ctx.uriClause() == null) {
            return new CreateFunctionStatement(ASTVisitor.parseIdentifier(ctx.udfName.getText()), this.parseStringLiteral(ctx.className.getText()), false);
        }
        String uriString = this.parseAndValidateURI(ctx.uriClause());
        return new CreateFunctionStatement(ASTVisitor.parseIdentifier(ctx.udfName.getText()), this.parseStringLiteral(ctx.className.getText()), true, uriString);
    }

    private String parseAndValidateURI(IoTDBSqlParser.UriClauseContext ctx) {
        String uriString = this.parseStringLiteral(ctx.uri().getText());
        try {
            new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new SemanticException(String.format("Invalid URI: %s", uriString));
        }
        return uriString;
    }

    public Statement visitDropFunction(IoTDBSqlParser.DropFunctionContext ctx) {
        return new DropFunctionStatement(ASTVisitor.parseIdentifier(ctx.udfName.getText()));
    }

    public Statement visitShowFunctions(IoTDBSqlParser.ShowFunctionsContext ctx) {
        return new ShowFunctionsStatement();
    }

    public Statement visitCreateTrigger(IoTDBSqlParser.CreateTriggerContext ctx) {
        if (ctx.triggerEventClause().DELETE() != null) {
            throw new SemanticException("Trigger does not support DELETE as TRIGGER_EVENT for now.");
        }
        if (ctx.triggerType() == null) {
            throw new SemanticException("Please specify trigger type: STATELESS or STATEFUL.");
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (ctx.triggerAttributeClause() != null) {
            for (IoTDBSqlParser.TriggerAttributeContext triggerAttributeContext : ctx.triggerAttributeClause().triggerAttribute()) {
                attributes.put(this.parseAttributeKey(triggerAttributeContext.key), this.parseAttributeValue(triggerAttributeContext.value));
            }
        }
        if (ctx.uriClause() == null) {
            return new CreateTriggerStatement(ASTVisitor.parseIdentifier(ctx.triggerName.getText()), this.parseStringLiteral(ctx.className.getText()), "", false, ctx.triggerEventClause().BEFORE() != null ? TriggerEvent.BEFORE_INSERT : TriggerEvent.AFTER_INSERT, ctx.triggerType().STATELESS() != null ? TriggerType.STATELESS : TriggerType.STATEFUL, this.parsePrefixPath(ctx.prefixPath()), attributes);
        }
        String uriString = this.parseAndValidateURI(ctx.uriClause());
        return new CreateTriggerStatement(ASTVisitor.parseIdentifier(ctx.triggerName.getText()), this.parseStringLiteral(ctx.className.getText()), uriString, true, ctx.triggerEventClause().BEFORE() != null ? TriggerEvent.BEFORE_INSERT : TriggerEvent.AFTER_INSERT, ctx.triggerType().STATELESS() != null ? TriggerType.STATELESS : TriggerType.STATEFUL, this.parsePrefixPath(ctx.prefixPath()), attributes);
    }

    public Statement visitDropTrigger(IoTDBSqlParser.DropTriggerContext ctx) {
        return new DropTriggerStatement(ASTVisitor.parseIdentifier(ctx.triggerName.getText()));
    }

    public Statement visitShowTriggers(IoTDBSqlParser.ShowTriggersContext ctx) {
        return new ShowTriggersStatement();
    }

    public Statement visitCreatePipePlugin(IoTDBSqlParser.CreatePipePluginContext ctx) {
        return new CreatePipePluginStatement(ctx.pluginName.getText(), this.parseStringLiteral(ctx.className.getText()), this.parseAndValidateURI(ctx.uriClause()));
    }

    public Statement visitDropPipePlugin(IoTDBSqlParser.DropPipePluginContext ctx) {
        return new DropPipePluginStatement(ctx.pluginName.getText());
    }

    public Statement visitShowPipePlugins(IoTDBSqlParser.ShowPipePluginsContext ctx) {
        return new ShowPipePluginsStatement();
    }

    public Statement visitShowChildPaths(IoTDBSqlParser.ShowChildPathsContext ctx) {
        if (ctx.prefixPath() != null) {
            return new ShowChildPathsStatement(this.parsePrefixPath(ctx.prefixPath()));
        }
        return new ShowChildPathsStatement(new PartialPath(SqlConstant.getSingleRootArray()));
    }

    public Statement visitShowChildNodes(IoTDBSqlParser.ShowChildNodesContext ctx) {
        if (ctx.prefixPath() != null) {
            return new ShowChildNodesStatement(this.parsePrefixPath(ctx.prefixPath()));
        }
        return new ShowChildNodesStatement(new PartialPath(SqlConstant.getSingleRootArray()));
    }

    public Statement visitCreateContinuousQuery(IoTDBSqlParser.CreateContinuousQueryContext ctx) {
        CreateContinuousQueryStatement statement = new CreateContinuousQueryStatement();
        statement.setCqId(ASTVisitor.parseIdentifier(ctx.cqId.getText()));
        QueryStatement queryBodyStatement = (QueryStatement)this.visitSelectStatement(ctx.selectStatement());
        queryBodyStatement.setCqQueryBody(true);
        statement.setQueryBodyStatement(queryBodyStatement);
        if (ctx.resampleClause() != null) {
            this.parseResampleClause(ctx.resampleClause(), statement);
        } else {
            QueryStatement queryStatement = statement.getQueryBodyStatement();
            if (!queryStatement.isGroupByTime()) {
                throw new SemanticException("CQ: At least one of the parameters `every_interval` and `group_by_interval` needs to be specified.");
            }
            long interval = queryStatement.getGroupByTimeComponent().getInterval().getTotalDuration(TimestampPrecisionUtils.currPrecision);
            statement.setEveryInterval(interval);
            statement.setStartTimeOffset(interval);
        }
        if (ctx.timeoutPolicyClause() != null) {
            this.parseTimeoutPolicyClause(ctx.timeoutPolicyClause(), statement);
        }
        return statement;
    }

    private void parseResampleClause(IoTDBSqlParser.ResampleClauseContext ctx, CreateContinuousQueryStatement statement) {
        if (ctx.EVERY() != null) {
            statement.setEveryInterval(DateTimeUtils.convertDurationStrToLong(ctx.everyInterval.getText()));
        } else {
            QueryStatement queryStatement = statement.getQueryBodyStatement();
            if (!queryStatement.isGroupByTime()) {
                throw new SemanticException("CQ: At least one of the parameters `every_interval` and `group_by_interval` needs to be specified.");
            }
            statement.setEveryInterval(queryStatement.getGroupByTimeComponent().getInterval().getTotalDuration(TimestampPrecisionUtils.currPrecision));
        }
        if (ctx.BOUNDARY() != null) {
            statement.setBoundaryTime(this.parseTimeValue(ctx.boundaryTime, CommonDateTimeUtils.currentTime()));
        }
        if (ctx.RANGE() != null) {
            statement.setStartTimeOffset(DateTimeUtils.convertDurationStrToLong(ctx.startTimeOffset.getText()));
            if (ctx.endTimeOffset != null) {
                statement.setEndTimeOffset(DateTimeUtils.convertDurationStrToLong(ctx.endTimeOffset.getText()));
            }
        } else {
            statement.setStartTimeOffset(statement.getEveryInterval());
        }
    }

    private void parseTimeoutPolicyClause(IoTDBSqlParser.TimeoutPolicyClauseContext ctx, CreateContinuousQueryStatement statement) {
        if (ctx.DISCARD() != null) {
            statement.setTimeoutPolicy(TimeoutPolicy.DISCARD);
        }
    }

    public Statement visitDropContinuousQuery(IoTDBSqlParser.DropContinuousQueryContext ctx) {
        return new DropContinuousQueryStatement(ASTVisitor.parseIdentifier(ctx.cqId.getText()));
    }

    public Statement visitShowContinuousQueries(IoTDBSqlParser.ShowContinuousQueriesContext ctx) {
        return new ShowContinuousQueriesStatement();
    }

    public Statement visitCreateLogicalView(IoTDBSqlParser.CreateLogicalViewContext ctx) {
        CreateLogicalViewStatement createLogicalViewStatement = new CreateLogicalViewStatement();
        this.parseViewTargetPaths(ctx.viewTargetPaths(), createLogicalViewStatement::setTargetFullPaths, createLogicalViewStatement::setTargetPathsGroup, createLogicalViewStatement::setTargetIntoItem);
        this.parseViewSourcePaths(ctx.viewSourcePaths(), createLogicalViewStatement::setSourceFullPaths, createLogicalViewStatement::setSourcePathsGroup, createLogicalViewStatement::setSourceQueryStatement);
        return createLogicalViewStatement;
    }

    public Statement visitDropLogicalView(IoTDBSqlParser.DropLogicalViewContext ctx) {
        DeleteLogicalViewStatement deleteLogicalViewStatement = new DeleteLogicalViewStatement();
        ArrayList<PartialPath> partialPaths = new ArrayList<PartialPath>();
        for (IoTDBSqlParser.PrefixPathContext prefixPathContext : ctx.prefixPath()) {
            partialPaths.add(this.parsePrefixPath(prefixPathContext));
        }
        deleteLogicalViewStatement.setPathPatternList(partialPaths);
        return deleteLogicalViewStatement;
    }

    public Statement visitShowLogicalView(IoTDBSqlParser.ShowLogicalViewContext ctx) {
        ShowLogicalViewStatement showLogicalViewStatement = ctx.prefixPath() != null ? new ShowLogicalViewStatement(this.parsePrefixPath(ctx.prefixPath())) : new ShowLogicalViewStatement(new PartialPath(SqlConstant.getSingleRootArray()));
        if (ctx.timeseriesWhereClause() != null) {
            SchemaFilter schemaFilter = this.parseTimeseriesWhereClause(ctx.timeseriesWhereClause());
            showLogicalViewStatement.setSchemaFilter(schemaFilter);
        }
        if (ctx.rowPaginationClause() != null) {
            if (ctx.rowPaginationClause().limitClause() != null) {
                showLogicalViewStatement.setLimit(this.parseLimitClause(ctx.rowPaginationClause().limitClause()));
            }
            if (ctx.rowPaginationClause().offsetClause() != null) {
                showLogicalViewStatement.setOffset(this.parseOffsetClause(ctx.rowPaginationClause().offsetClause()));
            }
        }
        return showLogicalViewStatement;
    }

    public Statement visitRenameLogicalView(IoTDBSqlParser.RenameLogicalViewContext ctx) {
        throw new SemanticException("Renaming view is not supported.");
    }

    public Statement visitAlterLogicalView(IoTDBSqlParser.AlterLogicalViewContext ctx) {
        if (ctx.alterClause() == null) {
            AlterLogicalViewStatement alterLogicalViewStatement = new AlterLogicalViewStatement();
            this.parseViewTargetPaths(ctx.viewTargetPaths(), alterLogicalViewStatement::setTargetFullPaths, alterLogicalViewStatement::setTargetPathsGroup, intoItem -> {
                if (intoItem != null) {
                    throw new SemanticException("Can not use char '$' or into item in alter view statement.");
                }
            });
            this.parseViewSourcePaths(ctx.viewSourcePaths(), alterLogicalViewStatement::setSourceFullPaths, alterLogicalViewStatement::setSourcePathsGroup, alterLogicalViewStatement::setSourceQueryStatement);
            return alterLogicalViewStatement;
        }
        AlterTimeSeriesStatement alterTimeSeriesStatement = new AlterTimeSeriesStatement(true);
        alterTimeSeriesStatement.setPath(this.parseFullPath(ctx.fullPath()));
        this.parseAlterClause(ctx.alterClause(), alterTimeSeriesStatement);
        if (alterTimeSeriesStatement.getAlias() != null) {
            throw new SemanticException("View doesn't support alias.");
        }
        return alterTimeSeriesStatement;
    }

    private PartialPath parseViewPrefixPathWithInto(IoTDBSqlParser.PrefixPathContext ctx) {
        List nodeNames = ctx.nodeName();
        String[] path = new String[nodeNames.size() + 1];
        path[0] = ctx.ROOT().getText();
        for (int i = 0; i < nodeNames.size(); ++i) {
            path[i + 1] = ASTVisitor.parseNodeStringInIntoPath(((IoTDBSqlParser.NodeNameContext)nodeNames.get(i)).getText());
        }
        return new PartialPath(path);
    }

    private PartialPath parseViewSuffixPatWithInto(IoTDBSqlParser.ViewSuffixPathsContext ctx) {
        List nodeNamesWithoutStar = ctx.nodeNameWithoutWildcard();
        String[] nodeList = new String[nodeNamesWithoutStar.size()];
        for (int i = 0; i < nodeNamesWithoutStar.size(); ++i) {
            nodeList[i] = ASTVisitor.parseNodeStringInIntoPath(((IoTDBSqlParser.NodeNameWithoutWildcardContext)nodeNamesWithoutStar.get(i)).getText());
        }
        return new PartialPath(nodeList);
    }

    private PartialPath parseViewSuffixPath(IoTDBSqlParser.ViewSuffixPathsContext ctx) {
        List nodeNamesWithoutStar = ctx.nodeNameWithoutWildcard();
        String[] nodeList = new String[nodeNamesWithoutStar.size()];
        for (int i = 0; i < nodeNamesWithoutStar.size(); ++i) {
            nodeList[i] = this.parseNodeNameWithoutWildCard((IoTDBSqlParser.NodeNameWithoutWildcardContext)nodeNamesWithoutStar.get(i));
        }
        return new PartialPath(nodeList);
    }

    private void parseViewTargetPaths(IoTDBSqlParser.ViewTargetPathsContext ctx, Consumer<List<PartialPath>> setTargetFullPaths, BiConsumer<PartialPath, List<PartialPath>> setTargetPathsGroup, Consumer<IntoItem> setTargetIntoItem) {
        if (ctx.fullPath() != null && !ctx.fullPath().isEmpty()) {
            List fullPathContextList = ctx.fullPath();
            ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
            for (IoTDBSqlParser.FullPathContext pathContext : fullPathContextList) {
                pathList.add(this.parseFullPath(pathContext));
            }
            setTargetFullPaths.accept(pathList);
        }
        if (ctx.prefixPath() != null && ctx.viewSuffixPaths() != null && !ctx.viewSuffixPaths().isEmpty()) {
            IoTDBSqlParser.PrefixPathContext prefixPathContext = ctx.prefixPath();
            List suffixPathContextList = ctx.viewSuffixPaths();
            ArrayList<PartialPath> suffixPathList = new ArrayList<PartialPath>();
            PartialPath prefixPath = null;
            boolean isMultipleCreating = false;
            try {
                prefixPath = this.parsePrefixPath(prefixPathContext);
                for (Object suffixPathContext : suffixPathContextList) {
                    suffixPathList.add(this.parseViewSuffixPath((IoTDBSqlParser.ViewSuffixPathsContext)suffixPathContext));
                }
            }
            catch (SemanticException e) {
                isMultipleCreating = true;
                suffixPathList.clear();
            }
            if (!isMultipleCreating) {
                setTargetPathsGroup.accept(prefixPath, suffixPathList);
            } else {
                prefixPath = this.parseViewPrefixPathWithInto(prefixPathContext);
                for (Object suffixPathContext : suffixPathContextList) {
                    suffixPathList.add(this.parseViewSuffixPatWithInto((IoTDBSqlParser.ViewSuffixPathsContext)suffixPathContext));
                }
                ArrayList<String> intoMeasurementList = new ArrayList<String>();
                for (PartialPath path : suffixPathList) {
                    intoMeasurementList.add(path.toString());
                }
                IntoItem intoItem = new IntoItem(prefixPath, intoMeasurementList, false);
                setTargetIntoItem.accept(intoItem);
            }
        }
    }

    private void parseViewSourcePaths(IoTDBSqlParser.ViewSourcePathsContext ctx, Consumer<List<PartialPath>> setSourceFullPaths, BiConsumer<PartialPath, List<PartialPath>> setSourcePathsGroup, Consumer<QueryStatement> setSourceQueryStatement) {
        if (ctx.fullPath() != null && !ctx.fullPath().isEmpty()) {
            List fullPathContextList = ctx.fullPath();
            ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
            for (IoTDBSqlParser.FullPathContext pathContext : fullPathContextList) {
                pathList.add(this.parseFullPath(pathContext));
            }
            setSourceFullPaths.accept(pathList);
        }
        if (ctx.prefixPath() != null && ctx.viewSuffixPaths() != null && !ctx.viewSuffixPaths().isEmpty()) {
            IoTDBSqlParser.PrefixPathContext prefixPathContext = ctx.prefixPath();
            PartialPath prefixPath = this.parsePrefixPath(prefixPathContext);
            List suffixPathContextList = ctx.viewSuffixPaths();
            ArrayList<PartialPath> suffixPathList = new ArrayList<PartialPath>();
            for (IoTDBSqlParser.ViewSuffixPathsContext suffixPathContext : suffixPathContextList) {
                suffixPathList.add(this.parseViewSuffixPath(suffixPathContext));
            }
            setSourcePathsGroup.accept(prefixPath, suffixPathList);
        }
        if (ctx.selectClause() != null && ctx.fromClause() != null) {
            QueryStatement queryStatement = new QueryStatement();
            queryStatement.setSelectComponent(this.parseSelectClause(ctx.selectClause(), queryStatement));
            queryStatement.setFromComponent(this.parseFromClause(ctx.fromClause()));
            setSourceQueryStatement.accept(queryStatement);
        }
    }

    public Statement visitSelectStatement(IoTDBSqlParser.SelectStatementContext ctx) {
        QueryStatement queryStatement = new QueryStatement();
        queryStatement.setSelectComponent(this.parseSelectClause(ctx.selectClause(), queryStatement));
        queryStatement.setFromComponent(this.parseFromClause(ctx.fromClause()));
        if (ctx.intoClause() != null) {
            queryStatement.setIntoComponent(this.parseIntoClause(ctx.intoClause()));
        }
        if (ctx.whereClause() != null) {
            queryStatement.setWhereCondition(this.parseWhereClause(ctx.whereClause()));
        }
        if (ctx.groupByClause() != null) {
            HashSet<String> groupByKeys = new HashSet<String>();
            List groupByAttributes = ctx.groupByClause().groupByAttributeClause();
            for (IoTDBSqlParser.GroupByAttributeClauseContext groupByAttribute : groupByAttributes) {
                if (groupByAttribute.TIME() != null || groupByAttribute.interval != null) {
                    if (groupByKeys.contains("COMMON")) {
                        throw new SemanticException(GROUP_BY_COMMON_ONLY_ONE_MSG);
                    }
                    groupByKeys.add("COMMON");
                    queryStatement.setGroupByTimeComponent(this.parseGroupByTimeClause(groupByAttribute));
                    continue;
                }
                if (groupByAttribute.LEVEL() != null) {
                    if (groupByKeys.contains("LEVEL")) {
                        throw new SemanticException("duplicated group by key: LEVEL");
                    }
                    groupByKeys.add("LEVEL");
                    queryStatement.setGroupByLevelComponent(this.parseGroupByLevelClause(groupByAttribute));
                    continue;
                }
                if (groupByAttribute.TAGS() != null) {
                    if (groupByKeys.contains("TAGS")) {
                        throw new SemanticException("duplicated group by key: TAGS");
                    }
                    groupByKeys.add("TAGS");
                    queryStatement.setGroupByTagComponent(this.parseGroupByTagClause(groupByAttribute));
                    continue;
                }
                if (groupByAttribute.VARIATION() != null) {
                    if (groupByKeys.contains("COMMON")) {
                        throw new SemanticException(GROUP_BY_COMMON_ONLY_ONE_MSG);
                    }
                    groupByKeys.add("COMMON");
                    queryStatement.setGroupByComponent(this.parseGroupByClause(groupByAttribute, WindowType.VARIATION_WINDOW));
                    continue;
                }
                if (groupByAttribute.CONDITION() != null) {
                    if (groupByKeys.contains("COMMON")) {
                        throw new SemanticException(GROUP_BY_COMMON_ONLY_ONE_MSG);
                    }
                    groupByKeys.add("COMMON");
                    queryStatement.setGroupByComponent(this.parseGroupByClause(groupByAttribute, WindowType.CONDITION_WINDOW));
                    continue;
                }
                if (groupByAttribute.SESSION() != null) {
                    if (groupByKeys.contains("COMMON")) {
                        throw new SemanticException(GROUP_BY_COMMON_ONLY_ONE_MSG);
                    }
                    groupByKeys.add("COMMON");
                    queryStatement.setGroupByComponent(this.parseGroupByClause(groupByAttribute, WindowType.SESSION_WINDOW));
                    continue;
                }
                if (groupByAttribute.COUNT() != null) {
                    if (groupByKeys.contains("COMMON")) {
                        throw new SemanticException(GROUP_BY_COMMON_ONLY_ONE_MSG);
                    }
                    groupByKeys.add("COMMON");
                    queryStatement.setGroupByComponent(this.parseGroupByClause(groupByAttribute, WindowType.COUNT_WINDOW));
                    continue;
                }
                throw new SemanticException("Unknown GROUP BY type.");
            }
        }
        if (ctx.havingClause() != null) {
            queryStatement.setHavingCondition(this.parseHavingClause(ctx.havingClause()));
        }
        if (ctx.orderByClause() != null) {
            queryStatement.setOrderByComponent(this.parseOrderByClause(ctx.orderByClause(), (ImmutableSet<String>)ImmutableSet.of((Object)"TIME", (Object)"DEVICE", (Object)"TIMESERIES")));
        }
        if (ctx.fillClause() != null) {
            queryStatement.setFillComponent(this.parseFillClause(ctx.fillClause()));
        }
        if (ctx.alignByClause() != null) {
            queryStatement.setResultSetFormat(this.parseAlignBy(ctx.alignByClause()));
        }
        if (ctx.paginationClause() != null) {
            if (ctx.paginationClause().seriesPaginationClause() != null) {
                if (ctx.paginationClause().seriesPaginationClause().slimitClause() != null) {
                    queryStatement.setSeriesLimit(this.parseSLimitClause(ctx.paginationClause().seriesPaginationClause().slimitClause()));
                }
                if (ctx.paginationClause().seriesPaginationClause().soffsetClause() != null) {
                    queryStatement.setSeriesOffset(this.parseSOffsetClause(ctx.paginationClause().seriesPaginationClause().soffsetClause()));
                }
            }
            if (ctx.paginationClause().rowPaginationClause() != null) {
                if (ctx.paginationClause().rowPaginationClause().limitClause() != null) {
                    queryStatement.setRowLimit(this.parseLimitClause(ctx.paginationClause().rowPaginationClause().limitClause()));
                }
                if (ctx.paginationClause().rowPaginationClause().offsetClause() != null) {
                    queryStatement.setRowOffset(this.parseOffsetClause(ctx.paginationClause().rowPaginationClause().offsetClause()));
                }
                if (LimitOffsetPushDown.canPushDownLimitOffsetToGroupByTime(queryStatement)) {
                    LimitOffsetPushDown.pushDownLimitOffsetToTimeParameter(queryStatement);
                }
            }
        }
        queryStatement.setUseWildcard(this.useWildcard);
        queryStatement.setLastLevelUseWildcard(this.lastLevelUseWildcard);
        return queryStatement;
    }

    private SelectComponent parseSelectClause(IoTDBSqlParser.SelectClauseContext ctx, QueryStatement queryStatement) {
        SelectComponent selectComponent = new SelectComponent(this.zoneId);
        if (ctx.LAST() != null) {
            selectComponent.setHasLast(true);
        }
        HashMap<String, Expression> aliasToColumnMap = new HashMap<String, Expression>();
        for (IoTDBSqlParser.ResultColumnContext resultColumnContext : ctx.resultColumn()) {
            ResultColumn resultColumn = this.parseResultColumn(resultColumnContext);
            if (resultColumn.getExpression().getExpressionString().equals("__endTime")) {
                queryStatement.setOutputEndTime(true);
                continue;
            }
            if (resultColumn.hasAlias()) {
                String alias = resultColumn.getAlias();
                if (aliasToColumnMap.containsKey(alias)) {
                    throw new SemanticException("duplicate alias in select clause");
                }
                aliasToColumnMap.put(alias, resultColumn.getExpression());
            }
            selectComponent.addResultColumn(resultColumn);
        }
        selectComponent.setAliasToColumnMap(aliasToColumnMap);
        return selectComponent;
    }

    private ResultColumn parseResultColumn(IoTDBSqlParser.ResultColumnContext resultColumnContext) {
        Expression expression = this.parseExpression(resultColumnContext.expression(), false);
        if (expression.isConstantOperand()) {
            throw new SemanticException("Constant operand is not allowed: " + expression);
        }
        String alias = null;
        if (resultColumnContext.AS() != null) {
            alias = this.parseAlias(resultColumnContext.alias());
        }
        ResultColumn.ColumnType columnType = ExpressionAnalyzer.identifyOutputColumnType(expression, true);
        return new ResultColumn(expression, alias, columnType);
    }

    private FromComponent parseFromClause(IoTDBSqlParser.FromClauseContext ctx) {
        FromComponent fromComponent = new FromComponent();
        List prefixFromPaths = ctx.prefixPath();
        for (IoTDBSqlParser.PrefixPathContext prefixFromPath : prefixFromPaths) {
            PartialPath path = this.parsePrefixPath(prefixFromPath);
            fromComponent.addPrefixPath(path);
        }
        return fromComponent;
    }

    private IntoComponent parseIntoClause(IoTDBSqlParser.IntoClauseContext ctx) {
        ArrayList<IntoItem> intoItems = new ArrayList<IntoItem>();
        for (IoTDBSqlParser.IntoItemContext intoItemContext : ctx.intoItem()) {
            intoItems.add(this.parseIntoItem(intoItemContext));
        }
        return new IntoComponent(intoItems);
    }

    private IntoItem parseIntoItem(IoTDBSqlParser.IntoItemContext intoItemContext) {
        boolean isAligned = intoItemContext.ALIGNED() != null;
        PartialPath intoDevice = this.parseIntoPath(intoItemContext.intoPath());
        List<String> intoMeasurements = intoItemContext.nodeNameInIntoPath().stream().map(this::parseNodeNameInIntoPath).collect(Collectors.toList());
        return new IntoItem(intoDevice, intoMeasurements, isAligned);
    }

    private PartialPath parseIntoPath(IoTDBSqlParser.IntoPathContext intoPathContext) {
        if (intoPathContext instanceof IoTDBSqlParser.FullPathInIntoPathContext) {
            return this.parseFullPathInIntoPath((IoTDBSqlParser.FullPathInIntoPathContext)intoPathContext);
        }
        List nodeNames = ((IoTDBSqlParser.SuffixPathInIntoPathContext)intoPathContext).nodeNameInIntoPath();
        String[] path = new String[nodeNames.size()];
        for (int i = 0; i < nodeNames.size(); ++i) {
            path[i] = this.parseNodeNameInIntoPath((IoTDBSqlParser.NodeNameInIntoPathContext)nodeNames.get(i));
        }
        return new PartialPath(path);
    }

    private WhereCondition parseWhereClause(IoTDBSqlParser.WhereClauseContext ctx) {
        Expression predicate = this.parseExpression(ctx.expression(), true);
        return new WhereCondition(predicate);
    }

    private GroupByTimeComponent parseGroupByTimeClause(IoTDBSqlParser.GroupByAttributeClauseContext ctx) {
        GroupByTimeComponent groupByTimeComponent = new GroupByTimeComponent();
        if (ctx.timeRange() != null) {
            this.parseTimeRangeForGroupByTime(ctx.timeRange(), groupByTimeComponent);
            groupByTimeComponent.setLeftCRightO(ctx.timeRange().LS_BRACKET() != null);
        }
        groupByTimeComponent.setInterval(DateTimeUtils.constructTimeDuration(ctx.interval.getText()));
        groupByTimeComponent.setOriginalInterval(ctx.interval.getText());
        if (groupByTimeComponent.getInterval().monthDuration == 0 && groupByTimeComponent.getInterval().nonMonthDuration == 0L) {
            throw new SemanticException("The second parameter time interval should be a positive integer.");
        }
        if (ctx.step != null) {
            groupByTimeComponent.setSlidingStep(DateTimeUtils.constructTimeDuration(ctx.step.getText()));
            groupByTimeComponent.setOriginalSlidingStep(ctx.step.getText());
        } else {
            groupByTimeComponent.setSlidingStep(groupByTimeComponent.getInterval());
            groupByTimeComponent.setOriginalSlidingStep(groupByTimeComponent.getOriginalInterval());
        }
        TimeDuration slidingStep = groupByTimeComponent.getSlidingStep();
        if (slidingStep.containsMonth() && Math.ceil((double)(groupByTimeComponent.getEndTime() - groupByTimeComponent.getStartTime()) / (double)slidingStep.getMinTotalDuration(TimestampPrecisionUtils.currPrecision)) >= 10000.0) {
            throw new SemanticException("The time windows may exceed 10000, please ensure your input.");
        }
        if (groupByTimeComponent.getSlidingStep().monthDuration == 0 && groupByTimeComponent.getSlidingStep().nonMonthDuration == 0L) {
            throw new SemanticException("The third parameter time slidingStep should be a positive integer.");
        }
        return groupByTimeComponent;
    }

    private void parseTimeRangeForGroupByTime(IoTDBSqlParser.TimeRangeContext timeRange, GroupByTimeComponent groupByClauseComponent) {
        long currentTime = CommonDateTimeUtils.currentTime();
        long startTime = this.parseTimeValue(timeRange.timeValue(0), currentTime);
        long endTime = this.parseTimeValue(timeRange.timeValue(1), currentTime);
        groupByClauseComponent.setStartTime(startTime);
        groupByClauseComponent.setEndTime(endTime);
        if (startTime >= endTime) {
            throw new SemanticException("Start time should be smaller than endTime in GroupBy");
        }
    }

    private GroupByComponent parseGroupByClause(IoTDBSqlParser.GroupByAttributeClauseContext ctx, WindowType windowType) {
        boolean ignoringNull = true;
        if (ctx.attributePair() != null && !ctx.attributePair().isEmpty() && ctx.attributePair().key.getText().equalsIgnoreCase(IGNORENULL)) {
            ignoringNull = Boolean.parseBoolean(ctx.attributePair().value.getText());
        }
        List expressions = ctx.expression();
        if (windowType == WindowType.VARIATION_WINDOW) {
            IoTDBSqlParser.ExpressionContext expressionContext = (IoTDBSqlParser.ExpressionContext)expressions.get(0);
            GroupByVariationComponent groupByVariationComponent = new GroupByVariationComponent();
            Expression expression = this.parseExpression(expressionContext, true);
            if (expression.isConstantOperand()) {
                throw new SemanticException(String.format("Constant operand [%s] is not allowed in group by variation, there should be an expression", expression.getExpressionString()));
            }
            groupByVariationComponent.setControlColumnExpression(expression);
            groupByVariationComponent.setDelta(ctx.delta == null ? 0.0 : Double.parseDouble(ctx.delta.getText()));
            groupByVariationComponent.setIgnoringNull(ignoringNull);
            return groupByVariationComponent;
        }
        if (windowType == WindowType.CONDITION_WINDOW) {
            IoTDBSqlParser.ExpressionContext conditionExpressionContext = (IoTDBSqlParser.ExpressionContext)expressions.get(0);
            GroupByConditionComponent groupByConditionComponent = new GroupByConditionComponent();
            groupByConditionComponent.setControlColumnExpression(this.parseExpression(conditionExpressionContext, true));
            if (expressions.size() != 2) {
                throw new SemanticException("Keep threshold in group by condition should be set");
            }
            groupByConditionComponent.setKeepExpression(this.parseExpression((IoTDBSqlParser.ExpressionContext)expressions.get(1), true));
            groupByConditionComponent.setIgnoringNull(ignoringNull);
            return groupByConditionComponent;
        }
        if (windowType == WindowType.SESSION_WINDOW) {
            long interval = DateTimeUtils.convertDurationStrToLong(ctx.timeInterval.getText());
            return new GroupBySessionComponent(interval);
        }
        if (windowType == WindowType.COUNT_WINDOW) {
            IoTDBSqlParser.ExpressionContext countExpressionContext = (IoTDBSqlParser.ExpressionContext)expressions.get(0);
            long countNumber = Long.parseLong(ctx.countNumber.getText());
            GroupByCountComponent groupByCountComponent = new GroupByCountComponent(countNumber);
            Expression expression = this.parseExpression(countExpressionContext, true);
            if (expression.isConstantOperand()) {
                throw new SemanticException(String.format("Constant operand [%s] is not allowed in group by count, there should be an expression", expression.getExpressionString()));
            }
            groupByCountComponent.setControlColumnExpression(expression);
            groupByCountComponent.setIgnoringNull(ignoringNull);
            return groupByCountComponent;
        }
        throw new SemanticException("Unsupported window type");
    }

    private GroupByLevelComponent parseGroupByLevelClause(IoTDBSqlParser.GroupByAttributeClauseContext ctx) {
        GroupByLevelComponent groupByLevelComponent = new GroupByLevelComponent();
        int[] levels = new int[ctx.INTEGER_LITERAL().size()];
        for (int i = 0; i < ctx.INTEGER_LITERAL().size(); ++i) {
            levels[i] = Integer.parseInt(((TerminalNode)ctx.INTEGER_LITERAL().get(i)).getText());
        }
        groupByLevelComponent.setLevels(levels);
        return groupByLevelComponent;
    }

    private GroupByTagComponent parseGroupByTagClause(IoTDBSqlParser.GroupByAttributeClauseContext ctx) {
        LinkedHashSet<String> tagKeys = new LinkedHashSet<String>();
        for (IoTDBSqlParser.IdentifierContext identifierContext : ctx.identifier()) {
            String key = ASTVisitor.parseIdentifier(identifierContext.getText());
            if (tagKeys.contains(key)) {
                throw new SemanticException("duplicated key in GROUP BY TAGS: " + key);
            }
            tagKeys.add(key);
        }
        return new GroupByTagComponent(new ArrayList<String>(tagKeys));
    }

    private HavingCondition parseHavingClause(IoTDBSqlParser.HavingClauseContext ctx) {
        Expression predicate = this.parseExpression(ctx.expression(), true);
        return new HavingCondition(predicate);
    }

    private OrderByComponent parseOrderByClause(IoTDBSqlParser.OrderByClauseContext ctx, ImmutableSet<String> limitSet) {
        OrderByComponent orderByComponent = new OrderByComponent();
        HashSet<String> sortKeySet = new HashSet<String>();
        for (IoTDBSqlParser.OrderByAttributeClauseContext orderByAttributeClauseContext : ctx.orderByAttributeClause()) {
            if (orderByComponent.isUnique()) break;
            SortItem sortItem = this.parseOrderByAttributeClause(orderByAttributeClauseContext, limitSet);
            String sortKey = sortItem.getSortKey();
            if (sortKeySet.contains(sortKey)) continue;
            sortKeySet.add(sortKey);
            if (sortItem.isExpression()) {
                orderByComponent.addExpressionSortItem(sortItem);
                continue;
            }
            orderByComponent.addSortItem(sortItem);
        }
        return orderByComponent;
    }

    private SortItem parseOrderByAttributeClause(IoTDBSqlParser.OrderByAttributeClauseContext ctx, ImmutableSet<String> limitSet) {
        if (ctx.sortKey() != null) {
            String sortKey = ctx.sortKey().getText().toUpperCase();
            if (!limitSet.contains((Object)sortKey)) {
                throw new SemanticException(String.format("ORDER BY: sort key[%s] is not contained in '%s'", sortKey, limitSet));
            }
            return new SortItem(sortKey, ctx.DESC() != null ? Ordering.DESC : Ordering.ASC);
        }
        Expression sortExpression = this.parseExpression(ctx.expression(), true);
        return new SortItem(sortExpression, ctx.DESC() != null ? Ordering.DESC : Ordering.ASC, ctx.FIRST() != null ? NullOrdering.FIRST : NullOrdering.LAST);
    }

    public FillComponent parseFillClause(IoTDBSqlParser.FillClauseContext ctx) {
        FillComponent fillComponent = new FillComponent();
        if (ctx.LINEAR() != null) {
            fillComponent.setFillPolicy(FillPolicy.LINEAR);
        } else if (ctx.PREVIOUS() != null) {
            fillComponent.setFillPolicy(FillPolicy.PREVIOUS);
        } else if (ctx.constant() != null) {
            fillComponent.setFillPolicy(FillPolicy.VALUE);
            Literal fillValue = this.parseLiteral(ctx.constant());
            fillComponent.setFillValue(fillValue);
        } else {
            throw new SemanticException("Unknown FILL type.");
        }
        if (ctx.interval != null) {
            if (fillComponent.getFillPolicy() != FillPolicy.PREVIOUS) {
                throw new SemanticException("Only FILL(PREVIOUS) support specifying the time duration threshold.");
            }
            fillComponent.setTimeDurationThreshold(DateTimeUtils.constructTimeDuration(ctx.interval.getText()));
        }
        return fillComponent;
    }

    private Literal parseLiteral(IoTDBSqlParser.ConstantContext constantContext) {
        String text = constantContext.getText();
        if (constantContext.boolean_literal() != null) {
            return new BooleanLiteral(text);
        }
        if (constantContext.STRING_LITERAL() != null) {
            return new StringLiteral(this.parseStringLiteral(text));
        }
        if (constantContext.INTEGER_LITERAL() != null) {
            return new LongLiteral(text);
        }
        if (constantContext.realLiteral() != null) {
            return new DoubleLiteral(text);
        }
        if (constantContext.dateExpression() != null) {
            return new LongLiteral(this.parseDateExpression(constantContext.dateExpression()));
        }
        throw new SemanticException("Unsupported constant value in FILL: " + text);
    }

    private long parseLimitClause(IoTDBSqlParser.LimitClauseContext ctx) {
        long limit;
        try {
            limit = Long.parseLong(ctx.INTEGER_LITERAL().getText());
        }
        catch (NumberFormatException e) {
            throw new SemanticException("Out of range. LIMIT <N>: N should be Int64.");
        }
        if (limit <= 0L) {
            throw new SemanticException("LIMIT <N>: N should be greater than 0.");
        }
        return limit;
    }

    private long parseOffsetClause(IoTDBSqlParser.OffsetClauseContext ctx) {
        long offset;
        try {
            offset = Long.parseLong(ctx.INTEGER_LITERAL().getText());
        }
        catch (NumberFormatException e) {
            throw new SemanticException("Out of range. OFFSET <OFFSETValue>: OFFSETValue should be Int64.");
        }
        if (offset < 0L) {
            throw new SemanticException("OFFSET <OFFSETValue>: OFFSETValue should >= 0.");
        }
        return offset;
    }

    private int parseSLimitClause(IoTDBSqlParser.SlimitClauseContext ctx) {
        int slimit;
        try {
            slimit = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
        }
        catch (NumberFormatException e) {
            throw new SemanticException("Out of range. SLIMIT <SN>: SN should be Int32.");
        }
        if (slimit <= 0) {
            throw new SemanticException("SLIMIT <SN>: SN should be greater than 0.");
        }
        return slimit;
    }

    public int parseSOffsetClause(IoTDBSqlParser.SoffsetClauseContext ctx) {
        int soffset;
        try {
            soffset = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
        }
        catch (NumberFormatException e) {
            throw new SemanticException("Out of range. SOFFSET <SOFFSETValue>: SOFFSETValue should be Int32.");
        }
        if (soffset < 0) {
            throw new SemanticException("SOFFSET <SOFFSETValue>: SOFFSETValue should >= 0.");
        }
        return soffset;
    }

    private ResultSetFormat parseAlignBy(IoTDBSqlParser.AlignByClauseContext ctx) {
        if (ctx.DEVICE() != null) {
            return ResultSetFormat.ALIGN_BY_DEVICE;
        }
        return ResultSetFormat.ALIGN_BY_TIME;
    }

    public Statement visitInsertStatement(IoTDBSqlParser.InsertStatementContext ctx) {
        InsertStatement insertStatement = new InsertStatement();
        insertStatement.setDevice(this.parsePrefixPath(ctx.prefixPath()));
        int timeIndex = this.parseInsertColumnSpec(ctx.insertColumnsSpec(), insertStatement);
        this.parseInsertValuesSpec(ctx.insertValuesSpec(), insertStatement, timeIndex);
        insertStatement.setAligned(ctx.ALIGNED() != null);
        return insertStatement;
    }

    private int parseInsertColumnSpec(IoTDBSqlParser.InsertColumnsSpecContext ctx, InsertStatement insertStatement) {
        ArrayList<String> measurementList = new ArrayList<String>();
        int timeIndex = -1;
        int size = ctx.insertColumn().size();
        for (int i = 0; i < size; ++i) {
            String measurement = this.parseInsertColumn(ctx.insertColumn(i));
            if ("time".equalsIgnoreCase(measurement) || "timestamp".equalsIgnoreCase(measurement)) {
                if (timeIndex != -1) {
                    throw new SemanticException("One row should only have one time value");
                }
                timeIndex = i;
                continue;
            }
            measurementList.add(measurement);
        }
        if (measurementList.isEmpty()) {
            throw new SemanticException("InsertStatement should contain at least one measurement");
        }
        insertStatement.setMeasurementList(measurementList.toArray(new String[0]));
        return timeIndex;
    }

    private String parseInsertColumn(IoTDBSqlParser.InsertColumnContext columnContext) {
        return ASTVisitor.parseNodeString(columnContext.getText());
    }

    private void parseInsertValuesSpec(IoTDBSqlParser.InsertValuesSpecContext ctx, InsertStatement insertStatement, int timeIndex) {
        List rows = ctx.row();
        if (timeIndex == -1 && rows.size() != 1) {
            throw new SemanticException("need timestamps when insert multi rows");
        }
        ArrayList<String[]> valuesList = new ArrayList<String[]>();
        long[] timeArray = new long[rows.size()];
        int size = rows.size();
        for (int i = 0; i < size; ++i) {
            long timestamp;
            IoTDBSqlParser.RowContext row = (IoTDBSqlParser.RowContext)rows.get(i);
            ArrayList<String> valueList = new ArrayList<String>();
            if (timeIndex == -1) {
                timestamp = CommonDateTimeUtils.currentTime();
            } else {
                timestamp = this.parseTimeValue(row.constant(timeIndex));
                TimestampPrecisionUtils.checkTimestampPrecision(timestamp);
            }
            timeArray[i] = timestamp;
            List values = row.constant();
            int columnCount = values.size();
            for (int j = 0; j < columnCount; ++j) {
                if (j == timeIndex) continue;
                if (((IoTDBSqlParser.ConstantContext)values.get(j)).STRING_LITERAL() != null) {
                    valueList.add(this.parseStringLiteralInInsertValue(((IoTDBSqlParser.ConstantContext)values.get(j)).getText()));
                    continue;
                }
                valueList.add(((IoTDBSqlParser.ConstantContext)values.get(j)).getText());
            }
            valuesList.add(valueList.toArray(new String[0]));
        }
        insertStatement.setTimes(timeArray);
        insertStatement.setValuesList(valuesList);
    }

    private long parseTimeValue(IoTDBSqlParser.ConstantContext constant) {
        if (constant.INTEGER_LITERAL() != null) {
            try {
                if (constant.MINUS() != null) {
                    return -Long.parseLong(constant.INTEGER_LITERAL().getText());
                }
                return Long.parseLong(constant.INTEGER_LITERAL().getText());
            }
            catch (NumberFormatException e) {
                throw new SemanticException(String.format("Can not parse %s to long value", constant.INTEGER_LITERAL().getText()));
            }
        }
        if (constant.dateExpression() != null) {
            return this.parseDateExpression(constant.dateExpression(), CommonDateTimeUtils.currentTime());
        }
        throw new SemanticException(String.format("Can not parse %s to time", constant));
    }

    public Statement visitLoadFile(IoTDBSqlParser.LoadFileContext ctx) {
        try {
            LoadTsFileStatement loadTsFileStatement = new LoadTsFileStatement(this.parseStringLiteral(ctx.fileName.getText()));
            if (ctx.loadFileAttributeClauses() != null) {
                for (IoTDBSqlParser.LoadFileAttributeClauseContext attributeContext : ctx.loadFileAttributeClauses().loadFileAttributeClause()) {
                    this.parseLoadFileAttributeClause(loadTsFileStatement, attributeContext);
                }
            }
            return loadTsFileStatement;
        }
        catch (FileNotFoundException e) {
            throw new SemanticException(e.getMessage());
        }
    }

    private void parseLoadFileAttributeClause(LoadTsFileStatement loadTsFileStatement, IoTDBSqlParser.LoadFileAttributeClauseContext ctx) {
        if (ctx.ONSUCCESS() != null) {
            loadTsFileStatement.setDeleteAfterLoad(ctx.DELETE() != null);
        } else if (ctx.SGLEVEL() != null) {
            loadTsFileStatement.setDatabaseLevel(Integer.parseInt(ctx.INTEGER_LITERAL().getText()));
        } else if (ctx.VERIFY() != null) {
            loadTsFileStatement.setVerifySchema(Boolean.parseBoolean(ctx.boolean_literal().getText()));
        } else {
            throw new SemanticException(String.format("Load tsfile format %s error, please input AUTOREGISTER | SGLEVEL | VERIFY.", ctx.getText()));
        }
    }

    private PartialPath parseFullPath(IoTDBSqlParser.FullPathContext ctx) {
        List nodeNamesWithoutStar = ctx.nodeNameWithoutWildcard();
        String[] path = new String[nodeNamesWithoutStar.size() + 1];
        int i = 0;
        if (ctx.ROOT() != null) {
            path[0] = ctx.ROOT().getText();
        }
        for (IoTDBSqlParser.NodeNameWithoutWildcardContext nodeNameWithoutStar : nodeNamesWithoutStar) {
            path[++i] = this.parseNodeNameWithoutWildCard(nodeNameWithoutStar);
        }
        return new PartialPath(path);
    }

    private PartialPath parseFullPathInExpression(IoTDBSqlParser.FullPathInExpressionContext ctx, boolean canUseFullPath) {
        List nodeNames = ctx.nodeName();
        int size = nodeNames.size();
        if (ctx.ROOT() != null) {
            if (!canUseFullPath) {
                throw new SemanticException("Path can not start with root in select clause.");
            }
            ++size;
        }
        String[] path = new String[size];
        if (ctx.ROOT() != null) {
            path[0] = ctx.ROOT().getText();
            for (int i = 0; i < nodeNames.size(); ++i) {
                path[i + 1] = this.parseNodeName((IoTDBSqlParser.NodeNameContext)nodeNames.get(i));
            }
        } else {
            for (int i = 0; i < nodeNames.size(); ++i) {
                path[i] = this.parseNodeName((IoTDBSqlParser.NodeNameContext)nodeNames.get(i));
            }
        }
        if (!(this.lastLevelUseWildcard || nodeNames.isEmpty() || ((IoTDBSqlParser.NodeNameContext)nodeNames.get(nodeNames.size() - 1)).wildcard().isEmpty())) {
            this.lastLevelUseWildcard = true;
        }
        return new PartialPath(path);
    }

    private PartialPath parseFullPathInIntoPath(IoTDBSqlParser.FullPathInIntoPathContext ctx) {
        List nodeNames = ctx.nodeNameInIntoPath();
        String[] path = new String[nodeNames.size() + 1];
        int i = 0;
        if (ctx.ROOT() != null) {
            path[0] = ctx.ROOT().getText();
        }
        for (IoTDBSqlParser.NodeNameInIntoPathContext nodeName : nodeNames) {
            path[++i] = this.parseNodeNameInIntoPath(nodeName);
        }
        return new PartialPath(path);
    }

    private PartialPath parsePrefixPath(IoTDBSqlParser.PrefixPathContext ctx) {
        List nodeNames = ctx.nodeName();
        String[] path = new String[nodeNames.size() + 1];
        path[0] = ctx.ROOT().getText();
        for (int i = 0; i < nodeNames.size(); ++i) {
            path[i + 1] = this.parseNodeName((IoTDBSqlParser.NodeNameContext)nodeNames.get(i));
        }
        return new PartialPath(path);
    }

    private String parseNodeName(IoTDBSqlParser.NodeNameContext ctx) {
        if (!this.useWildcard && !ctx.wildcard().isEmpty()) {
            this.useWildcard = true;
        }
        return ASTVisitor.parseNodeString(ctx.getText());
    }

    private String parseNodeNameWithoutWildCard(IoTDBSqlParser.NodeNameWithoutWildcardContext ctx) {
        return ASTVisitor.parseNodeString(ctx.getText());
    }

    private String parseNodeNameInIntoPath(IoTDBSqlParser.NodeNameInIntoPathContext ctx) {
        return ASTVisitor.parseNodeStringInIntoPath(ctx.getText());
    }

    public static String parseNodeString(String nodeName) {
        if (nodeName.equals("*") || nodeName.equals("**")) {
            return nodeName;
        }
        if (nodeName.startsWith("`") && nodeName.endsWith("`")) {
            return PathUtils.removeBackQuotesIfNecessary((String)nodeName);
        }
        ASTVisitor.checkNodeName(nodeName);
        return nodeName;
    }

    private static String parseNodeStringInIntoPath(String nodeName) {
        if (nodeName.equals("::")) {
            return nodeName;
        }
        if (nodeName.startsWith("`") && nodeName.endsWith("`")) {
            return nodeName;
        }
        ASTVisitor.checkNodeNameInIntoPath(nodeName);
        return nodeName;
    }

    private static void checkNodeName(String src) {
        if (!TsFileConstant.NODE_NAME_PATTERN.matcher(src).matches()) {
            throw new SemanticException(String.format("%s is illegal, unquoted node name can only consist of digits, characters and underscore, or start or end with wildcard", src));
        }
    }

    private static void checkNodeNameInIntoPath(String src) {
        if (!NODE_NAME_IN_INTO_PATH_PATTERN.matcher(src).matches()) {
            throw new SemanticException(String.format("%s is illegal, unquoted node name in select into clause can only consist of digits, characters, $, { and }", src));
        }
    }

    private static void checkIdentifier(String src) {
        if (!TsFileConstant.IDENTIFIER_PATTERN.matcher(src).matches() || PathUtils.isRealNumber((String)src)) {
            throw new SemanticException(String.format("%s is illegal, identifier not enclosed with backticks can only consist of digits, characters and underscore.", src));
        }
    }

    public long parseDateFormat(String timestampStr) {
        if (timestampStr == null || "".equals(timestampStr.trim())) {
            throw new SemanticException("input timestamp cannot be empty");
        }
        if (timestampStr.equalsIgnoreCase("now()")) {
            return CommonDateTimeUtils.currentTime();
        }
        try {
            return DateTimeUtils.convertDatetimeStrToLong(timestampStr, this.zoneId);
        }
        catch (Exception e) {
            throw new SemanticException(String.format("Input time format %s error. Input like yyyy-MM-dd HH:mm:ss, yyyy-MM-ddTHH:mm:ss or refer to user document for more info.", timestampStr));
        }
    }

    public long parseDateFormat(String timestampStr, long currentTime) {
        if (timestampStr == null || "".equals(timestampStr.trim())) {
            throw new SemanticException("input timestamp cannot be empty");
        }
        if (timestampStr.equalsIgnoreCase("now()")) {
            return currentTime;
        }
        try {
            return DateTimeUtils.convertDatetimeStrToLong(timestampStr, this.zoneId);
        }
        catch (Exception e) {
            throw new SemanticException(String.format("Input time format %s error. Input like yyyy-MM-dd HH:mm:ss, yyyy-MM-ddTHH:mm:ss or refer to user document for more info.", timestampStr));
        }
    }

    private String parseStringLiteral(String src) {
        if (2 <= src.length()) {
            String unWrappedString = src.substring(1, src.length() - 1);
            if (src.charAt(0) == '\"' && src.charAt(src.length() - 1) == '\"') {
                String replaced = unWrappedString.replace("\"\"", "\"");
                return replaced.length() == 0 ? "" : replaced;
            }
            if (src.charAt(0) == '\'' && src.charAt(src.length() - 1) == '\'') {
                String replaced = unWrappedString.replace("''", "'");
                return replaced.length() == 0 ? "" : replaced;
            }
        }
        return src;
    }

    private String parseStringLiteralInInsertValue(String src) {
        if (2 <= src.length() && (src.charAt(0) == '\"' && src.charAt(src.length() - 1) == '\"' || src.charAt(0) == '\'' && src.charAt(src.length() - 1) == '\'')) {
            return "'" + this.parseStringLiteral(src) + "'";
        }
        return src;
    }

    public static String parseIdentifier(String src) {
        if (src.startsWith("`") && src.endsWith("`")) {
            return src.substring(1, src.length() - 1).replace("``", "`");
        }
        ASTVisitor.checkIdentifier(src);
        return src;
    }

    private String parseAlias(IoTDBSqlParser.AliasContext ctx) {
        String alias = ctx.constant() != null ? this.parseConstant(ctx.constant()) : ASTVisitor.parseIdentifier(ctx.identifier().getText());
        return alias;
    }

    private String parseAliasNode(IoTDBSqlParser.AliasContext ctx) {
        String alias;
        if (ctx.constant() != null) {
            alias = this.parseConstant(ctx.constant());
            if (PathUtils.isRealNumber((String)alias) || !TsFileConstant.IDENTIFIER_PATTERN.matcher(alias).matches()) {
                throw new SemanticException("Not support for this alias, Please enclose in back quotes.");
            }
        } else {
            alias = ASTVisitor.parseNodeString(ctx.identifier().getText());
        }
        return alias;
    }

    public Statement visitCreateUser(IoTDBSqlParser.CreateUserContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorType.CREATE_USER);
        authorStatement.setUserName(ASTVisitor.parseIdentifier(ctx.userName.getText()));
        authorStatement.setPassWord(this.parseStringLiteral(ctx.password.getText()));
        return authorStatement;
    }

    public Statement visitCreateRole(IoTDBSqlParser.CreateRoleContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorType.CREATE_ROLE);
        authorStatement.setRoleName(ASTVisitor.parseIdentifier(ctx.roleName.getText()));
        return authorStatement;
    }

    public Statement visitAlterUser(IoTDBSqlParser.AlterUserContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorType.UPDATE_USER);
        authorStatement.setUserName(ASTVisitor.parseIdentifier(ctx.userName.getText()));
        authorStatement.setNewPassword(this.parseStringLiteral(ctx.password.getText()));
        return authorStatement;
    }

    public Statement visitGrantUser(IoTDBSqlParser.GrantUserContext ctx) {
        String[] privileges = this.parsePrivilege(ctx.privileges());
        List<PartialPath> nodeNameList = ctx.prefixPath().stream().map(this::parsePrefixPath).distinct().collect(Collectors.toList());
        this.checkGrantRevokePrivileges(privileges, nodeNameList);
        String[] priviParsed = this.parsePrivilege(privileges);
        AuthorStatement authorStatement = new AuthorStatement(AuthorType.GRANT_USER);
        authorStatement.setUserName(ASTVisitor.parseIdentifier(ctx.userName.getText()));
        authorStatement.setPrivilegeList(priviParsed);
        authorStatement.setNodeNameList(nodeNameList);
        authorStatement.setGrantOpt(ctx.grantOpt() != null);
        return authorStatement;
    }

    public Statement visitGrantRole(IoTDBSqlParser.GrantRoleContext ctx) {
        String[] privileges = this.parsePrivilege(ctx.privileges());
        List<PartialPath> nodeNameList = ctx.prefixPath().stream().map(this::parsePrefixPath).distinct().collect(Collectors.toList());
        this.checkGrantRevokePrivileges(privileges, nodeNameList);
        String[] priviParsed = this.parsePrivilege(privileges);
        AuthorStatement authorStatement = new AuthorStatement(AuthorType.GRANT_ROLE);
        authorStatement.setRoleName(ASTVisitor.parseIdentifier(ctx.roleName.getText()));
        authorStatement.setPrivilegeList(priviParsed);
        authorStatement.setNodeNameList(nodeNameList);
        authorStatement.setGrantOpt(ctx.grantOpt() != null);
        return authorStatement;
    }

    public Statement visitGrantRoleToUser(IoTDBSqlParser.GrantRoleToUserContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorType.GRANT_USER_ROLE);
        authorStatement.setRoleName(ASTVisitor.parseIdentifier(ctx.roleName.getText()));
        authorStatement.setUserName(ASTVisitor.parseIdentifier(ctx.userName.getText()));
        return authorStatement;
    }

    public Statement visitRevokeUser(IoTDBSqlParser.RevokeUserContext ctx) {
        String[] privileges = this.parsePrivilege(ctx.privileges());
        List<PartialPath> nodeNameList = ctx.prefixPath().stream().map(this::parsePrefixPath).distinct().collect(Collectors.toList());
        this.checkGrantRevokePrivileges(privileges, nodeNameList);
        String[] priviParsed = this.parsePrivilege(privileges);
        AuthorStatement authorStatement = new AuthorStatement(AuthorType.REVOKE_USER);
        authorStatement.setUserName(ASTVisitor.parseIdentifier(ctx.userName.getText()));
        authorStatement.setPrivilegeList(priviParsed);
        authorStatement.setNodeNameList(nodeNameList);
        return authorStatement;
    }

    public Statement visitRevokeRole(IoTDBSqlParser.RevokeRoleContext ctx) {
        String[] privileges = this.parsePrivilege(ctx.privileges());
        List<PartialPath> nodeNameList = ctx.prefixPath().stream().map(this::parsePrefixPath).distinct().collect(Collectors.toList());
        this.checkGrantRevokePrivileges(privileges, nodeNameList);
        String[] priviParsed = this.parsePrivilege(privileges);
        AuthorStatement authorStatement = new AuthorStatement(AuthorType.REVOKE_ROLE);
        authorStatement.setRoleName(ASTVisitor.parseIdentifier(ctx.roleName.getText()));
        authorStatement.setPrivilegeList(priviParsed);
        authorStatement.setNodeNameList(nodeNameList);
        return authorStatement;
    }

    private void checkGrantRevokePrivileges(String[] privileges, List<PartialPath> nodeNameList) {
        if (nodeNameList.isEmpty()) {
            throw new SemanticException("Statement needs target paths");
        }
        boolean hasSystemPri = false;
        String errorPrivilegeName = "";
        for (String privilege : privileges) {
            if (!"ALL".equalsIgnoreCase(privilege) && ("READ".equalsIgnoreCase(privilege) || "WRITE".equalsIgnoreCase(privilege) || PrivilegeType.valueOf((String)privilege.toUpperCase()).isPathRelevant())) continue;
            hasSystemPri = true;
            errorPrivilegeName = privilege.toUpperCase();
            break;
        }
        if (hasSystemPri && (nodeNameList.size() != 1 || !nodeNameList.contains(new PartialPath(SchemaConstant.ALL_RESULT_NODES)))) {
            throw new SemanticException(String.format("[%s] can only be set on path: root.**", errorPrivilegeName));
        }
    }

    private String[] parsePrivilege(String[] privileges) {
        HashSet<String> privSet = new HashSet<String>();
        for (String priv : privileges) {
            if (priv.equalsIgnoreCase("READ")) {
                privSet.add("READ_SCHEMA");
                privSet.add("READ_DATA");
                continue;
            }
            if (priv.equalsIgnoreCase("WRITE")) {
                privSet.add("WRITE_DATA");
                privSet.add("WRITE_SCHEMA");
                continue;
            }
            if (priv.equalsIgnoreCase("ALL")) {
                for (PrivilegeType type : PrivilegeType.values()) {
                    privSet.add(type.toString());
                }
                continue;
            }
            privSet.add(priv);
        }
        return privSet.toArray(new String[0]);
    }

    public Statement visitRevokeRoleFromUser(IoTDBSqlParser.RevokeRoleFromUserContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorType.REVOKE_USER_ROLE);
        authorStatement.setRoleName(ASTVisitor.parseIdentifier(ctx.roleName.getText()));
        authorStatement.setUserName(ASTVisitor.parseIdentifier(ctx.userName.getText()));
        return authorStatement;
    }

    public Statement visitDropUser(IoTDBSqlParser.DropUserContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorType.DROP_USER);
        authorStatement.setUserName(ASTVisitor.parseIdentifier(ctx.userName.getText()));
        return authorStatement;
    }

    public Statement visitDropRole(IoTDBSqlParser.DropRoleContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorType.DROP_ROLE);
        authorStatement.setRoleName(ASTVisitor.parseIdentifier(ctx.roleName.getText()));
        return authorStatement;
    }

    public Statement visitListUser(IoTDBSqlParser.ListUserContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorType.LIST_USER);
        if (ctx.roleName != null) {
            authorStatement.setRoleName(ASTVisitor.parseIdentifier(ctx.roleName.getText()));
        }
        return authorStatement;
    }

    public Statement visitListRole(IoTDBSqlParser.ListRoleContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorType.LIST_ROLE);
        if (ctx.userName != null) {
            authorStatement.setUserName(ASTVisitor.parseIdentifier(ctx.userName.getText()));
        }
        return authorStatement;
    }

    public Statement visitListPrivilegesUser(IoTDBSqlParser.ListPrivilegesUserContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorType.LIST_USER_PRIVILEGE);
        authorStatement.setUserName(ASTVisitor.parseIdentifier(ctx.userName.getText()));
        return authorStatement;
    }

    public Statement visitListPrivilegesRole(IoTDBSqlParser.ListPrivilegesRoleContext ctx) {
        AuthorStatement authorStatement = new AuthorStatement(AuthorType.LIST_ROLE_PRIVILEGE);
        authorStatement.setRoleName(ASTVisitor.parseIdentifier(ctx.roleName.getText()));
        return authorStatement;
    }

    private String[] parsePrivilege(IoTDBSqlParser.PrivilegesContext ctx) {
        List privilegeList = ctx.privilegeValue();
        ArrayList<String> privileges = new ArrayList<String>();
        for (IoTDBSqlParser.PrivilegeValueContext privilegeValue : privilegeList) {
            privileges.add(privilegeValue.getText());
        }
        return privileges.toArray(new String[0]);
    }

    public Statement visitCreateDatabase(IoTDBSqlParser.CreateDatabaseContext ctx) {
        DatabaseSchemaStatement databaseSchemaStatement = new DatabaseSchemaStatement(DatabaseSchemaStatement.DatabaseSchemaStatementType.CREATE);
        PartialPath path = this.parsePrefixPath(ctx.prefixPath());
        databaseSchemaStatement.setDatabasePath(path);
        if (ctx.databaseAttributesClause() != null) {
            this.parseDatabaseAttributesClause(databaseSchemaStatement, ctx.databaseAttributesClause());
        }
        return databaseSchemaStatement;
    }

    public Statement visitAlterDatabase(IoTDBSqlParser.AlterDatabaseContext ctx) {
        DatabaseSchemaStatement databaseSchemaStatement = new DatabaseSchemaStatement(DatabaseSchemaStatement.DatabaseSchemaStatementType.ALTER);
        PartialPath path = this.parsePrefixPath(ctx.prefixPath());
        databaseSchemaStatement.setDatabasePath(path);
        this.parseDatabaseAttributesClause(databaseSchemaStatement, ctx.databaseAttributesClause());
        return databaseSchemaStatement;
    }

    private void parseDatabaseAttributesClause(DatabaseSchemaStatement databaseSchemaStatement, IoTDBSqlParser.DatabaseAttributesClauseContext ctx) {
        for (IoTDBSqlParser.DatabaseAttributeClauseContext attribute : ctx.databaseAttributeClause()) {
            IoTDBSqlParser.DatabaseAttributeKeyContext attributeKey = attribute.databaseAttributeKey();
            if (attributeKey.TTL() != null) {
                long ttl = Long.parseLong(attribute.INTEGER_LITERAL().getText());
                databaseSchemaStatement.setTtl(ttl);
                continue;
            }
            if (attributeKey.SCHEMA_REPLICATION_FACTOR() != null) {
                int schemaReplicationFactor = Integer.parseInt(attribute.INTEGER_LITERAL().getText());
                databaseSchemaStatement.setSchemaReplicationFactor(schemaReplicationFactor);
                continue;
            }
            if (attributeKey.DATA_REPLICATION_FACTOR() != null) {
                int dataReplicationFactor = Integer.parseInt(attribute.INTEGER_LITERAL().getText());
                databaseSchemaStatement.setDataReplicationFactor(dataReplicationFactor);
                continue;
            }
            if (attributeKey.TIME_PARTITION_INTERVAL() != null) {
                long timePartitionInterval = Long.parseLong(attribute.INTEGER_LITERAL().getText());
                databaseSchemaStatement.setTimePartitionInterval(timePartitionInterval);
                continue;
            }
            if (attributeKey.SCHEMA_REGION_GROUP_NUM() != null) {
                int schemaRegionGroupNum = Integer.parseInt(attribute.INTEGER_LITERAL().getText());
                databaseSchemaStatement.setSchemaRegionGroupNum(schemaRegionGroupNum);
                continue;
            }
            if (attributeKey.DATA_REGION_GROUP_NUM() == null) continue;
            int dataRegionGroupNum = Integer.parseInt(attribute.INTEGER_LITERAL().getText());
            databaseSchemaStatement.setDataRegionGroupNum(dataRegionGroupNum);
        }
    }

    public Statement visitSetTTL(IoTDBSqlParser.SetTTLContext ctx) {
        SetTTLStatement setTTLStatement = new SetTTLStatement();
        PartialPath path = this.parsePrefixPath(ctx.prefixPath());
        long ttl = Long.parseLong(ctx.INTEGER_LITERAL().getText());
        setTTLStatement.setDatabasePath(path);
        setTTLStatement.setTTL(ttl);
        return setTTLStatement;
    }

    public Statement visitUnsetTTL(IoTDBSqlParser.UnsetTTLContext ctx) {
        UnSetTTLStatement unSetTTLStatement = new UnSetTTLStatement();
        PartialPath partialPath = this.parsePrefixPath(ctx.prefixPath());
        unSetTTLStatement.setDatabasePath(partialPath);
        return unSetTTLStatement;
    }

    public Statement visitShowTTL(IoTDBSqlParser.ShowTTLContext ctx) {
        ShowTTLStatement showTTLStatement = new ShowTTLStatement();
        for (IoTDBSqlParser.PrefixPathContext prefixPathContext : ctx.prefixPath()) {
            PartialPath partialPath = this.parsePrefixPath(prefixPathContext);
            showTTLStatement.addPathPatterns(partialPath);
        }
        return showTTLStatement;
    }

    public Statement visitShowAllTTL(IoTDBSqlParser.ShowAllTTLContext ctx) {
        ShowTTLStatement showTTLStatement = new ShowTTLStatement();
        showTTLStatement.setAll(true);
        return showTTLStatement;
    }

    public Statement visitShowVariables(IoTDBSqlParser.ShowVariablesContext ctx) {
        return new ShowVariablesStatement();
    }

    public Statement visitShowCluster(IoTDBSqlParser.ShowClusterContext ctx) {
        ShowClusterStatement showClusterStatement = new ShowClusterStatement();
        if (ctx.DETAILS() != null) {
            showClusterStatement.setDetails(true);
        }
        return showClusterStatement;
    }

    public Statement visitShowClusterId(IoTDBSqlParser.ShowClusterIdContext ctx) {
        return new ShowClusterIdStatement();
    }

    public Statement visitDropDatabase(IoTDBSqlParser.DropDatabaseContext ctx) {
        DeleteDatabaseStatement dropDatabaseStatement = new DeleteDatabaseStatement();
        List prefixPathContexts = ctx.prefixPath();
        ArrayList<String> paths = new ArrayList<String>();
        for (IoTDBSqlParser.PrefixPathContext prefixPathContext : prefixPathContexts) {
            paths.add(this.parsePrefixPath(prefixPathContext).getFullPath());
        }
        dropDatabaseStatement.setPrefixPath(paths);
        return dropDatabaseStatement;
    }

    public Statement visitExplain(IoTDBSqlParser.ExplainContext ctx) {
        QueryStatement queryStatement = (QueryStatement)this.visitSelectStatement(ctx.selectStatement());
        return new ExplainStatement(queryStatement);
    }

    public Statement visitDeleteStatement(IoTDBSqlParser.DeleteStatementContext ctx) {
        DeleteDataStatement statement = new DeleteDataStatement();
        List prefixPaths = ctx.prefixPath();
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
        for (IoTDBSqlParser.PrefixPathContext prefixPath : prefixPaths) {
            pathList.add(this.parsePrefixPath(prefixPath));
        }
        statement.setPathList(pathList);
        if (ctx.whereClause() != null) {
            WhereCondition whereCondition = this.parseWhereClause(ctx.whereClause());
            TimeRange timeRange = this.parseDeleteTimeRange(whereCondition.getPredicate());
            statement.setTimeRange(timeRange);
        } else {
            statement.setTimeRange(new TimeRange(Long.MIN_VALUE, Long.MAX_VALUE));
        }
        return statement;
    }

    private TimeRange parseDeleteTimeRange(Expression predicate) {
        if (predicate instanceof LogicAndExpression) {
            TimeRange leftTimeRange = this.parseDeleteTimeRange(((LogicAndExpression)predicate).getLeftExpression());
            TimeRange rightTimeRange = this.parseDeleteTimeRange(((LogicAndExpression)predicate).getRightExpression());
            return new TimeRange(Math.max(leftTimeRange.getMin(), rightTimeRange.getMin()), Math.min(leftTimeRange.getMax(), rightTimeRange.getMax()));
        }
        if (predicate instanceof CompareBinaryExpression) {
            if (((CompareBinaryExpression)predicate).getLeftExpression() instanceof TimestampOperand) {
                return this.parseTimeRangeForDeleteTimeRange(predicate.getExpressionType(), ((CompareBinaryExpression)predicate).getLeftExpression(), ((CompareBinaryExpression)predicate).getRightExpression());
            }
            return this.parseTimeRangeForDeleteTimeRange(predicate.getExpressionType(), ((CompareBinaryExpression)predicate).getRightExpression(), ((CompareBinaryExpression)predicate).getLeftExpression());
        }
        throw new SemanticException(DELETE_RANGE_ERROR_MSG);
    }

    private TimeRange parseTimeRangeForDeleteTimeRange(ExpressionType expressionType, Expression timeExpression, Expression valueExpression) {
        if (!(timeExpression instanceof TimestampOperand) || !(valueExpression instanceof ConstantOperand)) {
            throw new SemanticException(DELETE_ONLY_SUPPORT_TIME_EXP_ERROR_MSG);
        }
        if (((ConstantOperand)valueExpression).getDataType() != TSDataType.INT64) {
            throw new SemanticException("The datatype of timestamp should be LONG.");
        }
        long time = Long.parseLong(((ConstantOperand)valueExpression).getValueString());
        switch (expressionType) {
            case LESS_THAN: {
                return new TimeRange(Long.MIN_VALUE, time - 1L);
            }
            case LESS_EQUAL: {
                return new TimeRange(Long.MIN_VALUE, time);
            }
            case GREATER_THAN: {
                return new TimeRange(time + 1L, Long.MAX_VALUE);
            }
            case GREATER_EQUAL: {
                return new TimeRange(time, Long.MAX_VALUE);
            }
            case EQUAL_TO: {
                return new TimeRange(time, time);
            }
        }
        throw new SemanticException(DELETE_RANGE_ERROR_MSG);
    }

    public String parseFilePath(String src) {
        return src.substring(1, src.length() - 1);
    }

    private Expression parseExpression(IoTDBSqlParser.ExpressionContext context, boolean canUseFullPath) {
        if (context.unaryInBracket != null) {
            return this.parseExpression(context.unaryInBracket, canUseFullPath);
        }
        if (context.expressionAfterUnaryOperator != null) {
            if (context.MINUS() != null) {
                return new NegationExpression(this.parseExpression(context.expressionAfterUnaryOperator, canUseFullPath));
            }
            if (context.operator_not() != null) {
                return new LogicNotExpression(this.parseExpression(context.expressionAfterUnaryOperator, canUseFullPath));
            }
            return this.parseExpression(context.expressionAfterUnaryOperator, canUseFullPath);
        }
        if (context.leftExpression != null && context.rightExpression != null) {
            Expression leftExpression = this.parseExpression(context.leftExpression, canUseFullPath);
            Expression rightExpression = this.parseExpression(context.rightExpression, canUseFullPath);
            if (context.STAR() != null) {
                return new MultiplicationExpression(leftExpression, rightExpression);
            }
            if (context.DIV() != null) {
                return new DivisionExpression(leftExpression, rightExpression);
            }
            if (context.MOD() != null) {
                return new ModuloExpression(leftExpression, rightExpression);
            }
            if (context.PLUS() != null) {
                return new AdditionExpression(leftExpression, rightExpression);
            }
            if (context.MINUS() != null) {
                return new SubtractionExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_GT() != null) {
                return new GreaterThanExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_GTE() != null) {
                return new GreaterEqualExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_LT() != null) {
                return new LessThanExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_LTE() != null) {
                return new LessEqualExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_DEQ() != null || context.OPERATOR_SEQ() != null) {
                return new EqualToExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_NEQ() != null) {
                return new NonEqualExpression(leftExpression, rightExpression);
            }
            if (context.operator_and() != null) {
                return new LogicAndExpression(leftExpression, rightExpression);
            }
            if (context.operator_or() != null) {
                return new LogicOrExpression(leftExpression, rightExpression);
            }
            throw new UnsupportedOperationException();
        }
        if (context.unaryBeforeRegularOrLikeExpression != null) {
            if (context.REGEXP() != null) {
                return this.parseRegularExpression(context, canUseFullPath);
            }
            if (context.LIKE() != null) {
                return this.parseLikeExpression(context, canUseFullPath);
            }
            throw new UnsupportedOperationException();
        }
        if (context.unaryBeforeIsNullExpression != null) {
            return this.parseIsNullExpression(context, canUseFullPath);
        }
        if (context.firstExpression != null && context.secondExpression != null && context.thirdExpression != null) {
            Expression firstExpression = this.parseExpression(context.firstExpression, canUseFullPath);
            Expression secondExpression = this.parseExpression(context.secondExpression, canUseFullPath);
            Expression thirdExpression = this.parseExpression(context.thirdExpression, canUseFullPath);
            if (context.operator_between() != null) {
                return new BetweenExpression(firstExpression, secondExpression, thirdExpression, context.operator_not() != null);
            }
            throw new UnsupportedOperationException();
        }
        if (context.unaryBeforeInExpression != null) {
            return this.parseInExpression(context, canUseFullPath);
        }
        if (context.scalarFunctionExpression() != null) {
            return this.parseScalarFunctionExpression(context.scalarFunctionExpression(), canUseFullPath);
        }
        if (context.functionName() != null) {
            return this.parseFunctionExpression(context, canUseFullPath);
        }
        if (context.fullPathInExpression() != null) {
            return new TimeSeriesOperand(this.parseFullPathInExpression(context.fullPathInExpression(), canUseFullPath));
        }
        if (context.time != null) {
            return new TimestampOperand();
        }
        if (context.constant() != null && !context.constant().isEmpty()) {
            return this.parseConstantOperand(context.constant(0));
        }
        if (context.caseWhenThenExpression() != null) {
            return this.parseCaseWhenThenExpression(context.caseWhenThenExpression(), canUseFullPath);
        }
        throw new UnsupportedOperationException();
    }

    private Expression parseScalarFunctionExpression(IoTDBSqlParser.ScalarFunctionExpressionContext context, boolean canUseFullPath) {
        if (context.CAST() != null) {
            return this.parseCastFunction(context, canUseFullPath);
        }
        if (context.REPLACE() != null) {
            return this.parseReplaceFunction(context, canUseFullPath);
        }
        if (context.ROUND() != null) {
            return this.parseRoundFunction(context, canUseFullPath);
        }
        if (context.SUBSTRING() != null) {
            return this.parseSubStrFunction(context, canUseFullPath);
        }
        throw new UnsupportedOperationException();
    }

    private Expression parseCastFunction(IoTDBSqlParser.ScalarFunctionExpressionContext castClause, boolean canUseFullPath) {
        FunctionExpression functionExpression = new FunctionExpression("CAST");
        functionExpression.addExpression(this.parseExpression(castClause.castInput, canUseFullPath));
        functionExpression.addAttribute("type", this.parseAttributeValue(castClause.attributeValue()));
        return functionExpression;
    }

    private Expression parseReplaceFunction(IoTDBSqlParser.ScalarFunctionExpressionContext replaceClause, boolean canUseFullPath) {
        FunctionExpression functionExpression = new FunctionExpression("REPLACE");
        functionExpression.addExpression(this.parseExpression(replaceClause.text, canUseFullPath));
        functionExpression.addAttribute("FROM", this.parseStringLiteral(replaceClause.from.getText()));
        functionExpression.addAttribute("TO", this.parseStringLiteral(replaceClause.to.getText()));
        return functionExpression;
    }

    private Expression parseSubStrFunction(IoTDBSqlParser.ScalarFunctionExpressionContext subStrClause, boolean canUseFullPath) {
        FunctionExpression functionExpression = new FunctionExpression("SUBSTRING");
        IoTDBSqlParser.SubStringExpressionContext subStringExpression = subStrClause.subStringExpression();
        functionExpression.addExpression(this.parseExpression(subStringExpression.input, canUseFullPath));
        if (subStringExpression.startPosition != null) {
            functionExpression.addAttribute("startPosition", subStringExpression.startPosition.getText());
            if (subStringExpression.length != null) {
                functionExpression.addAttribute("length", subStringExpression.length.getText());
            }
        }
        if (subStringExpression.from != null) {
            functionExpression.addAttribute("isStandard", "0");
            functionExpression.addAttribute("startPosition", this.parseStringLiteral(subStringExpression.from.getText()));
            if (subStringExpression.forLength != null) {
                functionExpression.addAttribute("length", subStringExpression.forLength.getText());
            }
        }
        return functionExpression;
    }

    private Expression parseRoundFunction(IoTDBSqlParser.ScalarFunctionExpressionContext roundClause, boolean canUseFullPath) {
        FunctionExpression functionExpression = new FunctionExpression("ROUND");
        functionExpression.addExpression(this.parseExpression(roundClause.input, canUseFullPath));
        if (roundClause.places != null) {
            functionExpression.addAttribute("PLACES", this.parseConstant(roundClause.constant()));
        }
        return functionExpression;
    }

    private CaseWhenThenExpression parseCaseWhenThenExpression(IoTDBSqlParser.CaseWhenThenExpressionContext context, boolean canUseFullPath) {
        Expression caseExpression = null;
        boolean simpleCase = false;
        if (context.caseExpression != null) {
            caseExpression = this.parseExpression(context.caseExpression, canUseFullPath);
            simpleCase = true;
        }
        ArrayList<WhenThenExpression> whenThenList = new ArrayList<WhenThenExpression>();
        if (simpleCase) {
            for (IoTDBSqlParser.WhenThenExpressionContext whenThenExpressionContext : context.whenThenExpression()) {
                Expression when = this.parseExpression(whenThenExpressionContext.whenExpression, canUseFullPath);
                Expression then = this.parseExpression(whenThenExpressionContext.thenExpression, canUseFullPath);
                EqualToExpression comparison = new EqualToExpression(caseExpression, when);
                whenThenList.add(new WhenThenExpression(comparison, then));
            }
        } else {
            for (IoTDBSqlParser.WhenThenExpressionContext whenThenExpressionContext : context.whenThenExpression()) {
                whenThenList.add(new WhenThenExpression(this.parseExpression(whenThenExpressionContext.whenExpression, canUseFullPath), this.parseExpression(whenThenExpressionContext.thenExpression, canUseFullPath)));
            }
        }
        Expression elseExpression = new NullOperand();
        if (context.elseExpression != null) {
            elseExpression = this.parseExpression(context.elseExpression, canUseFullPath);
        }
        return new CaseWhenThenExpression(whenThenList, elseExpression);
    }

    private Expression parseFunctionExpression(IoTDBSqlParser.ExpressionContext functionClause, boolean canUseFullPath) {
        FunctionExpression functionExpression = new FunctionExpression(ASTVisitor.parseIdentifier(functionClause.functionName().getText()));
        boolean hasNonPureConstantSubExpression = false;
        for (IoTDBSqlParser.ExpressionContext expression : functionClause.expression()) {
            Expression subexpression = this.parseExpression(expression, canUseFullPath);
            if (!subexpression.isConstantOperand()) {
                hasNonPureConstantSubExpression = true;
            }
            if (subexpression instanceof EqualToExpression) {
                Expression subLeftExpression = ((EqualToExpression)subexpression).getLeftExpression();
                Expression subRightExpression = ((EqualToExpression)subexpression).getRightExpression();
                if (!(!subLeftExpression.isConstantOperand() || subRightExpression.isConstantOperand() && ((ConstantOperand)subRightExpression).getDataType().equals((Object)TSDataType.TEXT))) {
                    throw new SemanticException("Attributes of functions should be quoted with '' or \"\"");
                }
                if (subLeftExpression.isConstantOperand() && subRightExpression.isConstantOperand()) {
                    functionExpression.addAttribute(((ConstantOperand)subLeftExpression).getValueString(), ((ConstantOperand)subRightExpression).getValueString());
                    continue;
                }
                functionExpression.addExpression(subexpression);
                continue;
            }
            functionExpression.addExpression(subexpression);
        }
        if (!hasNonPureConstantSubExpression) {
            throw new SemanticException("Invalid function expression, all the arguments are constant operands: " + functionClause.getText());
        }
        if (functionExpression.isBuiltInAggregationFunctionExpression()) {
            this.checkAggregationFunctionInput(functionExpression);
        } else if (functionExpression.isBuiltInScalarFunction()) {
            this.checkBuiltInScalarFunctionInput(functionExpression);
        }
        return functionExpression;
    }

    private void checkAggregationFunctionInput(FunctionExpression functionExpression) {
        String functionName;
        switch (functionName = functionExpression.getFunctionName().toLowerCase()) {
            case "min_time": 
            case "max_time": 
            case "count": 
            case "count_time": 
            case "min_value": 
            case "last_value": 
            case "first_value": 
            case "max_value": 
            case "extreme": 
            case "avg": 
            case "sum": 
            case "time_duration": 
            case "mode": 
            case "stddev": 
            case "stddev_pop": 
            case "stddev_samp": 
            case "variance": 
            case "var_pop": 
            case "var_samp": {
                ASTVisitor.checkFunctionExpressionInputSize(functionExpression.getExpressionString(), functionExpression.getExpressions().size(), 1);
                return;
            }
            case "count_if": {
                ASTVisitor.checkFunctionExpressionInputSize(functionExpression.getExpressionString(), functionExpression.getExpressions().size(), 2);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid Aggregation function: " + functionExpression.getFunctionName());
    }

    private void checkBuiltInScalarFunctionInput(FunctionExpression functionExpression) {
        BuiltInScalarFunctionHelperFactory.createHelper(functionExpression.getFunctionName()).checkBuiltInScalarFunctionInputSize(functionExpression);
    }

    public static void checkFunctionExpressionInputSize(String expressionString, int actual, int ... expected) {
        for (int expect : expected) {
            if (expect != actual) continue;
            return;
        }
        throw new SemanticException(String.format("Error size of input expressions. expression: %s, actual size: %s, expected size: %s.", expressionString, actual, Arrays.toString(expected)));
    }

    private Expression parseRegularExpression(IoTDBSqlParser.ExpressionContext context, boolean canUseFullPath) {
        return new RegularExpression(this.parseExpression(context.unaryBeforeRegularOrLikeExpression, canUseFullPath), this.parseStringLiteral(context.STRING_LITERAL().getText()), false);
    }

    private Expression parseLikeExpression(IoTDBSqlParser.ExpressionContext context, boolean canUseFullPath) {
        return new LikeExpression(this.parseExpression(context.unaryBeforeRegularOrLikeExpression, canUseFullPath), this.parseStringLiteral(context.STRING_LITERAL().getText()), false);
    }

    private Expression parseIsNullExpression(IoTDBSqlParser.ExpressionContext context, boolean canUseFullPath) {
        return new IsNullExpression(this.parseExpression(context.unaryBeforeIsNullExpression, canUseFullPath), context.operator_not() != null);
    }

    private Expression parseInExpression(IoTDBSqlParser.ExpressionContext context, boolean canUseFullPath) {
        Expression childExpression = this.parseExpression(context.unaryBeforeInExpression, canUseFullPath);
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        for (IoTDBSqlParser.ConstantContext constantContext : context.constant()) {
            values.add(this.parseConstant(constantContext));
        }
        return new InExpression(childExpression, context.operator_not() != null, values);
    }

    private String parseConstant(IoTDBSqlParser.ConstantContext constantContext) {
        String text = constantContext.getText();
        if (constantContext.boolean_literal() != null || constantContext.INTEGER_LITERAL() != null || constantContext.realLiteral() != null) {
            return text;
        }
        if (constantContext.STRING_LITERAL() != null) {
            return this.parseStringLiteral(text);
        }
        if (constantContext.dateExpression() != null) {
            return String.valueOf(this.parseDateExpression(constantContext.dateExpression()));
        }
        throw new IllegalArgumentException("Unsupported constant value: " + text);
    }

    private Expression parseConstantOperand(IoTDBSqlParser.ConstantContext constantContext) {
        String text = constantContext.getText();
        if (constantContext.boolean_literal() != null) {
            return new ConstantOperand(TSDataType.BOOLEAN, text);
        }
        if (constantContext.STRING_LITERAL() != null) {
            return new ConstantOperand(TSDataType.TEXT, this.parseStringLiteral(text));
        }
        if (constantContext.INTEGER_LITERAL() != null) {
            return new ConstantOperand(TSDataType.INT64, text);
        }
        if (constantContext.realLiteral() != null) {
            return this.parseRealLiteral(text);
        }
        if (constantContext.dateExpression() != null) {
            return new ConstantOperand(TSDataType.INT64, String.valueOf(this.parseDateExpression(constantContext.dateExpression())));
        }
        throw new SemanticException("Unsupported constant operand: " + text);
    }

    private Expression parseRealLiteral(String value) {
        return new ConstantOperand(CONFIG.getFloatingStringInferType().equals((Object)TSDataType.DOUBLE) ? TSDataType.DOUBLE : TSDataType.FLOAT, value);
    }

    private Long parseDateExpression(IoTDBSqlParser.DateExpressionContext ctx) {
        long time = this.parseDateFormat(ctx.getChild(0).getText());
        for (int i = 1; i < ctx.getChildCount(); i += 2) {
            if ("+".equals(ctx.getChild(i).getText())) {
                time += DateTimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText(), false);
                continue;
            }
            time -= DateTimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText(), false);
        }
        return time;
    }

    private Long parseDateExpression(IoTDBSqlParser.DateExpressionContext ctx, long currentTime) {
        long time = this.parseDateFormat(ctx.getChild(0).getText(), currentTime);
        for (int i = 1; i < ctx.getChildCount(); i += 2) {
            if ("+".equals(ctx.getChild(i).getText())) {
                time += DateTimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText(), false);
                continue;
            }
            time -= DateTimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText(), false);
        }
        return time;
    }

    private long parseTimeValue(IoTDBSqlParser.TimeValueContext ctx, long currentTime) {
        if (ctx.INTEGER_LITERAL() != null) {
            try {
                if (ctx.MINUS() != null) {
                    return -Long.parseLong(ctx.INTEGER_LITERAL().getText());
                }
                return Long.parseLong(ctx.INTEGER_LITERAL().getText());
            }
            catch (NumberFormatException e) {
                throw new SemanticException(String.format("Can not parse %s to long value", ctx.INTEGER_LITERAL().getText()));
            }
        }
        if (ctx.dateExpression() != null) {
            return this.parseDateExpression(ctx.dateExpression(), currentTime);
        }
        return this.parseDateFormat(ctx.datetimeLiteral().getText(), currentTime);
    }

    private void setMap(IoTDBSqlParser.AlterClauseContext ctx, Map<String, String> alterMap) {
        List tagsList = ctx.attributePair();
        if (ctx.attributePair(0) != null) {
            for (IoTDBSqlParser.AttributePairContext attributePair : tagsList) {
                String key = this.parseAttributeKey(attributePair.attributeKey());
                alterMap.computeIfPresent(key, (k, v) -> {
                    throw new SemanticException(String.format("There's duplicate [%s] in tag or attribute clause.", k));
                });
                alterMap.put(key, this.parseAttributeValue(attributePair.attributeValue()));
            }
        }
    }

    private Map<String, String> extractMap(List<IoTDBSqlParser.AttributePairContext> attributePair2, IoTDBSqlParser.AttributePairContext attributePair3) {
        HashMap<String, String> tags = new HashMap<String, String>(attributePair2.size());
        if (attributePair3 != null) {
            for (IoTDBSqlParser.AttributePairContext attributePair : attributePair2) {
                String key = this.parseAttributeKey(attributePair.attributeKey());
                tags.computeIfPresent(key, (k, v) -> {
                    throw new SemanticException(String.format("There's duplicate [%s] in tag or attribute clause.", k));
                });
                tags.put(key, this.parseAttributeValue(attributePair.attributeValue()));
            }
        }
        return tags;
    }

    private String parseAttributeKey(IoTDBSqlParser.AttributeKeyContext ctx) {
        if (ctx.constant() != null) {
            return this.parseStringLiteral(ctx.getText());
        }
        return ASTVisitor.parseIdentifier(ctx.getText());
    }

    private String parseAttributeValue(IoTDBSqlParser.AttributeValueContext ctx) {
        if (ctx.constant() != null) {
            return this.parseStringLiteral(ctx.getText());
        }
        return ASTVisitor.parseIdentifier(ctx.getText());
    }

    public Statement visitMerge(IoTDBSqlParser.MergeContext ctx) {
        MergeStatement mergeStatement = new MergeStatement(StatementType.MERGE);
        if (ctx.CLUSTER() != null && !IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
            throw new SemanticException("MERGE ON CLUSTER is not supported in standalone mode");
        }
        mergeStatement.setOnCluster(ctx.LOCAL() == null);
        return mergeStatement;
    }

    public Statement visitFullMerge(IoTDBSqlParser.FullMergeContext ctx) {
        MergeStatement mergeStatement = new MergeStatement(StatementType.FULL_MERGE);
        if (ctx.CLUSTER() != null && !IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
            throw new SemanticException("FULL MERGE ON CLUSTER is not supported in standalone mode");
        }
        mergeStatement.setOnCluster(ctx.LOCAL() == null);
        return mergeStatement;
    }

    public Statement visitFlush(IoTDBSqlParser.FlushContext ctx) {
        FlushStatement flushStatement = new FlushStatement(StatementType.FLUSH);
        ArrayList<PartialPath> storageGroups = null;
        if (ctx.boolean_literal() != null) {
            flushStatement.setSeq(Boolean.parseBoolean(ctx.boolean_literal().getText()));
        }
        if (ctx.CLUSTER() != null && !IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
            throw new SemanticException("FLUSH ON CLUSTER is not supported in standalone mode");
        }
        flushStatement.setOnCluster(ctx.LOCAL() == null);
        if (ctx.prefixPath(0) != null) {
            storageGroups = new ArrayList<PartialPath>();
            for (IoTDBSqlParser.PrefixPathContext prefixPathContext : ctx.prefixPath()) {
                storageGroups.add(this.parsePrefixPath(prefixPathContext));
            }
        }
        flushStatement.setStorageGroups(storageGroups);
        return flushStatement;
    }

    public Statement visitClearCache(IoTDBSqlParser.ClearCacheContext ctx) {
        ClearCacheStatement clearCacheStatement = new ClearCacheStatement(StatementType.CLEAR_CACHE);
        if (ctx.CLUSTER() != null && !IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
            throw new SemanticException("CLEAR CACHE ON CLUSTER is not supported in standalone mode");
        }
        clearCacheStatement.setOnCluster(ctx.LOCAL() == null);
        return clearCacheStatement;
    }

    public Statement visitStartRepairData(IoTDBSqlParser.StartRepairDataContext ctx) {
        StartRepairDataStatement startRepairDataStatement = new StartRepairDataStatement(StatementType.START_REPAIR_DATA);
        if (ctx.CLUSTER() != null && !IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
            throw new SemanticException("START REPAIR DATA ON CLUSTER is not supported in standalone mode");
        }
        startRepairDataStatement.setOnCluster(ctx.LOCAL() == null);
        return startRepairDataStatement;
    }

    public Statement visitStopRepairData(IoTDBSqlParser.StopRepairDataContext ctx) {
        StopRepairDataStatement stopRepairDataStatement = new StopRepairDataStatement(StatementType.STOP_REPAIR_DATA);
        if (ctx.CLUSTER() != null && !IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
            throw new SemanticException("STOP REPAIR DATA ON CLUSTER is not supported in standalone mode");
        }
        stopRepairDataStatement.setOnCluster(ctx.LOCAL() == null);
        return stopRepairDataStatement;
    }

    public Statement visitLoadConfiguration(IoTDBSqlParser.LoadConfigurationContext ctx) {
        LoadConfigurationStatement loadConfigurationStatement = new LoadConfigurationStatement(StatementType.LOAD_CONFIGURATION);
        if (ctx.CLUSTER() != null && !IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
            throw new SemanticException("LOAD CONFIGURATION ON CLUSTER is not supported in standalone mode");
        }
        loadConfigurationStatement.setOnCluster(ctx.LOCAL() == null);
        return loadConfigurationStatement;
    }

    public Statement visitSetSystemStatus(IoTDBSqlParser.SetSystemStatusContext ctx) {
        SetSystemStatusStatement setSystemStatusStatement = new SetSystemStatusStatement();
        if (ctx.CLUSTER() != null && !IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
            throw new SemanticException("SET SYSTEM STATUS ON CLUSTER is not supported in standalone mode");
        }
        setSystemStatusStatement.setOnCluster(ctx.LOCAL() == null);
        if (ctx.RUNNING() != null) {
            setSystemStatusStatement.setStatus(NodeStatus.Running);
        } else if (ctx.READONLY() != null) {
            setSystemStatusStatement.setStatus(NodeStatus.ReadOnly);
        } else {
            throw new SemanticException("Unknown system status in set system command.");
        }
        return setSystemStatusStatement;
    }

    public Statement visitKillQuery(IoTDBSqlParser.KillQueryContext ctx) {
        if (ctx.queryId != null) {
            return new KillQueryStatement(this.parseStringLiteral(ctx.queryId.getText()));
        }
        return new KillQueryStatement();
    }

    public Statement visitShowQueries(IoTDBSqlParser.ShowQueriesContext ctx) {
        ShowQueriesStatement showQueriesStatement = new ShowQueriesStatement();
        if (ctx.whereClause() != null) {
            showQueriesStatement.setWhereCondition(this.parseWhereClause(ctx.whereClause()));
        }
        if (ctx.orderByClause() != null) {
            showQueriesStatement.setOrderByComponent(this.parseOrderByClause(ctx.orderByClause(), (ImmutableSet<String>)ImmutableSet.of((Object)"TIME", (Object)"QUERYID", (Object)"DATANODEID", (Object)"ELAPSEDTIME", (Object)"STATEMENT")));
        }
        if (ctx.rowPaginationClause() != null) {
            if (ctx.rowPaginationClause().limitClause() != null) {
                showQueriesStatement.setRowLimit(this.parseLimitClause(ctx.rowPaginationClause().limitClause()));
            }
            if (ctx.rowPaginationClause().offsetClause() != null) {
                showQueriesStatement.setRowOffset(this.parseOffsetClause(ctx.rowPaginationClause().offsetClause()));
            }
        }
        showQueriesStatement.setZoneId(this.zoneId);
        return showQueriesStatement;
    }

    public Statement visitShowRegions(IoTDBSqlParser.ShowRegionsContext ctx) {
        ShowRegionStatement showRegionStatement = new ShowRegionStatement();
        if (ctx.DATA() != null) {
            showRegionStatement.setRegionType(TConsensusGroupType.DataRegion);
        } else if (ctx.SCHEMA() != null) {
            showRegionStatement.setRegionType(TConsensusGroupType.SchemaRegion);
        } else {
            showRegionStatement.setRegionType(null);
        }
        if (ctx.OF() != null) {
            ArrayList<PartialPath> storageGroups = null;
            if (ctx.prefixPath(0) != null) {
                storageGroups = new ArrayList<PartialPath>();
                for (IoTDBSqlParser.PrefixPathContext prefixPathContext : ctx.prefixPath()) {
                    storageGroups.add(this.parsePrefixPath(prefixPathContext));
                }
            }
            showRegionStatement.setStorageGroups(storageGroups);
        } else {
            showRegionStatement.setStorageGroups(null);
        }
        if (ctx.ON() != null) {
            ArrayList<Integer> nodeIds = new ArrayList<Integer>();
            for (TerminalNode nodeid : ctx.INTEGER_LITERAL()) {
                nodeIds.add(Integer.parseInt(nodeid.getText()));
            }
            showRegionStatement.setNodeIds(nodeIds);
        } else {
            showRegionStatement.setNodeIds(null);
        }
        return showRegionStatement;
    }

    public Statement visitShowDataNodes(IoTDBSqlParser.ShowDataNodesContext ctx) {
        return new ShowDataNodesStatement();
    }

    public Statement visitShowConfigNodes(IoTDBSqlParser.ShowConfigNodesContext ctx) {
        return new ShowConfigNodesStatement();
    }

    public Statement visitCreateSchemaTemplate(IoTDBSqlParser.CreateSchemaTemplateContext ctx) {
        String name = ASTVisitor.parseIdentifier(ctx.templateName.getText());
        ArrayList<List<String>> measurementsList = new ArrayList<List<String>>();
        ArrayList<List<TSDataType>> dataTypesList = new ArrayList<List<TSDataType>>();
        ArrayList<List<TSEncoding>> encodingsList = new ArrayList<List<TSEncoding>>();
        ArrayList<List<CompressionType>> compressorsList = new ArrayList<List<CompressionType>>();
        if (ctx.ALIGNED() != null) {
            ArrayList<String> measurements = new ArrayList<String>();
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
            ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
            ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
            for (IoTDBSqlParser.TemplateMeasurementClauseContext templateClauseContext : ctx.templateMeasurementClause()) {
                measurements.add(this.parseNodeNameWithoutWildCard(templateClauseContext.nodeNameWithoutWildcard()));
                this.parseAttributeClauseForSchemaTemplate(templateClauseContext.attributeClauses(), dataTypes, encodings, compressors);
            }
            measurementsList.add(measurements);
            dataTypesList.add(dataTypes);
            encodingsList.add(encodings);
            compressorsList.add(compressors);
        } else {
            for (IoTDBSqlParser.TemplateMeasurementClauseContext templateClauseContext : ctx.templateMeasurementClause()) {
                ArrayList<String> measurements = new ArrayList<String>();
                ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
                ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
                ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
                measurements.add(this.parseNodeNameWithoutWildCard(templateClauseContext.nodeNameWithoutWildcard()));
                this.parseAttributeClauseForSchemaTemplate(templateClauseContext.attributeClauses(), dataTypes, encodings, compressors);
                measurementsList.add(measurements);
                dataTypesList.add(dataTypes);
                encodingsList.add(encodings);
                compressorsList.add(compressors);
            }
        }
        return new CreateSchemaTemplateStatement(name, measurementsList, dataTypesList, encodingsList, compressorsList, ctx.ALIGNED() != null);
    }

    public Statement visitAlterSchemaTemplate(IoTDBSqlParser.AlterSchemaTemplateContext ctx) {
        String name = ASTVisitor.parseIdentifier(ctx.templateName.getText());
        ArrayList<String> measurements = new ArrayList<String>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
        for (IoTDBSqlParser.TemplateMeasurementClauseContext templateClauseContext : ctx.templateMeasurementClause()) {
            measurements.add(this.parseNodeNameWithoutWildCard(templateClauseContext.nodeNameWithoutWildcard()));
            this.parseAttributeClauseForSchemaTemplate(templateClauseContext.attributeClauses(), dataTypes, encodings, compressors);
        }
        return new AlterSchemaTemplateStatement(name, measurements, dataTypes, encodings, compressors, TemplateAlterOperationType.EXTEND_TEMPLATE);
    }

    void parseAttributeClauseForSchemaTemplate(IoTDBSqlParser.AttributeClausesContext ctx, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) {
        if (ctx.aliasNodeName() != null) {
            throw new SemanticException("Device Template: alias is not supported yet.");
        }
        TSDataType dataType = this.parseDataTypeAttribute(ctx);
        dataTypes.add(dataType);
        HashMap<String, String> props = new HashMap<String, String>();
        if (ctx.attributePair() != null) {
            for (int i = 0; i < ctx.attributePair().size(); ++i) {
                props.put(this.parseAttributeKey(ctx.attributePair(i).attributeKey()).toLowerCase(), this.parseAttributeValue(ctx.attributePair(i).attributeValue()));
            }
        }
        TSEncoding encoding = IoTDBDescriptor.getInstance().getDefaultEncodingByType(dataType);
        if (props.containsKey("encoding".toLowerCase())) {
            String encodingString = ((String)props.get("encoding".toLowerCase())).toUpperCase();
            try {
                encoding = TSEncoding.valueOf((String)encodingString);
                encodings.add(encoding);
                props.remove("encoding".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("Unsupported encoding: %s", encodingString));
            }
        } else {
            encodings.add(encoding);
        }
        CompressionType compressor = TSFileDescriptor.getInstance().getConfig().getCompressor();
        if (props.containsKey("compressor".toLowerCase())) {
            String compressorString = ((String)props.get("compressor".toLowerCase())).toUpperCase();
            try {
                compressor = CompressionType.valueOf((String)compressorString);
                compressors.add(compressor);
                props.remove("compressor".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("Unsupported compressor: %s", compressorString));
            }
        } else if (props.containsKey("compression".toLowerCase())) {
            String compressionString = ((String)props.get("compression".toLowerCase())).toUpperCase();
            try {
                compressor = CompressionType.valueOf((String)compressionString);
                compressors.add(compressor);
                props.remove("compression".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("Unsupported compression: %s", compressionString));
            }
        } else {
            compressors.add(compressor);
        }
        if (props.size() > 0) {
            throw new SemanticException("Device Template: property is not supported yet.");
        }
        if (ctx.tagClause() != null) {
            throw new SemanticException("Device Template: tag is not supported yet.");
        }
        if (ctx.attributeClause() != null) {
            throw new SemanticException("Device Template: attribute is not supported yet.");
        }
    }

    private TSDataType parseDataTypeAttribute(IoTDBSqlParser.AttributeClausesContext ctx) {
        TSDataType dataType = null;
        if (ctx.dataType != null) {
            if (ctx.attributeKey() != null && !this.parseAttributeKey(ctx.attributeKey()).equalsIgnoreCase("dataType")) {
                throw new SemanticException("Expecting datatype");
            }
            String dataTypeString = ctx.dataType.getText().toUpperCase();
            try {
                dataType = TSDataType.valueOf((String)dataTypeString);
            }
            catch (Exception e) {
                throw new SemanticException(String.format("Unsupported datatype: %s", dataTypeString));
            }
        }
        return dataType;
    }

    public Statement visitShowSchemaTemplates(IoTDBSqlParser.ShowSchemaTemplatesContext ctx) {
        return new ShowSchemaTemplateStatement();
    }

    public Statement visitShowNodesInSchemaTemplate(IoTDBSqlParser.ShowNodesInSchemaTemplateContext ctx) {
        String templateName = ASTVisitor.parseIdentifier(ctx.templateName.getText());
        return new ShowNodesInSchemaTemplateStatement(templateName);
    }

    public Statement visitSetSchemaTemplate(IoTDBSqlParser.SetSchemaTemplateContext ctx) {
        String templateName = ASTVisitor.parseIdentifier(ctx.templateName.getText());
        return new SetSchemaTemplateStatement(templateName, this.parsePrefixPath(ctx.prefixPath()));
    }

    public Statement visitShowPathsSetSchemaTemplate(IoTDBSqlParser.ShowPathsSetSchemaTemplateContext ctx) {
        String templateName = ASTVisitor.parseIdentifier(ctx.templateName.getText());
        return new ShowPathSetTemplateStatement(templateName);
    }

    public Statement visitCreateTimeseriesUsingSchemaTemplate(IoTDBSqlParser.CreateTimeseriesUsingSchemaTemplateContext ctx) {
        ActivateTemplateStatement statement = new ActivateTemplateStatement();
        statement.setPath(this.parsePrefixPath(ctx.prefixPath()));
        return statement;
    }

    public Statement visitShowPathsUsingSchemaTemplate(IoTDBSqlParser.ShowPathsUsingSchemaTemplateContext ctx) {
        PartialPath pathPattern = ctx.prefixPath() == null ? new PartialPath(SqlConstant.getSingleRootArray()) : this.parsePrefixPath(ctx.prefixPath());
        return new ShowPathsUsingTemplateStatement(pathPattern, ASTVisitor.parseIdentifier(ctx.templateName.getText()));
    }

    public Statement visitDropTimeseriesOfSchemaTemplate(IoTDBSqlParser.DropTimeseriesOfSchemaTemplateContext ctx) {
        DeactivateTemplateStatement statement = new DeactivateTemplateStatement();
        if (ctx.templateName != null) {
            statement.setTemplateName(ASTVisitor.parseIdentifier(ctx.templateName.getText()));
        }
        ArrayList<PartialPath> pathPatternList = new ArrayList<PartialPath>();
        for (IoTDBSqlParser.PrefixPathContext prefixPathContext : ctx.prefixPath()) {
            pathPatternList.add(this.parsePrefixPath(prefixPathContext));
        }
        statement.setPathPatternList(pathPatternList);
        return statement;
    }

    public Statement visitUnsetSchemaTemplate(IoTDBSqlParser.UnsetSchemaTemplateContext ctx) {
        String templateName = ASTVisitor.parseIdentifier(ctx.templateName.getText());
        PartialPath path = this.parsePrefixPath(ctx.prefixPath());
        return new UnsetSchemaTemplateStatement(templateName, path);
    }

    public Statement visitDropSchemaTemplate(IoTDBSqlParser.DropSchemaTemplateContext ctx) {
        return new DropSchemaTemplateStatement(ASTVisitor.parseIdentifier(ctx.templateName.getText()));
    }

    public Map<String, String> parseSyncAttributeClauses(IoTDBSqlParser.SyncAttributeClausesContext ctx) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        List attributePairs = ctx.attributePair();
        if (ctx.attributePair(0) != null) {
            for (IoTDBSqlParser.AttributePairContext attributePair : attributePairs) {
                attributes.put(this.parseAttributeKey(attributePair.attributeKey()).toLowerCase(), this.parseAttributeValue(attributePair.attributeValue()).toLowerCase());
            }
        }
        return attributes;
    }

    public Statement visitCreatePipe(IoTDBSqlParser.CreatePipeContext ctx) {
        CreatePipeStatement createPipeStatement = new CreatePipeStatement(StatementType.CREATE_PIPE);
        if (ctx.pipeName == null) {
            throw new SemanticException("Not support for this sql in CREATEPIPE, please enter pipe name.");
        }
        createPipeStatement.setPipeName(ctx.pipeName.getText());
        if (ctx.extractorAttributesClause() != null) {
            createPipeStatement.setExtractorAttributes(this.parseExtractorAttributesClause(ctx.extractorAttributesClause()));
        } else {
            createPipeStatement.setExtractorAttributes(new HashMap<String, String>());
        }
        if (ctx.processorAttributesClause() != null) {
            createPipeStatement.setProcessorAttributes(this.parseProcessorAttributesClause(ctx.processorAttributesClause()));
        } else {
            createPipeStatement.setProcessorAttributes(new HashMap<String, String>());
        }
        createPipeStatement.setConnectorAttributes(this.parseConnectorAttributesClause(ctx.connectorAttributesClause()));
        return createPipeStatement;
    }

    private Map<String, String> parseExtractorAttributesClause(IoTDBSqlParser.ExtractorAttributesClauseContext ctx) {
        HashMap<String, String> collectorMap = new HashMap<String, String>();
        for (IoTDBSqlParser.ExtractorAttributeClauseContext singleCtx : ctx.extractorAttributeClause()) {
            collectorMap.put(this.parseStringLiteral(singleCtx.extractorKey.getText()), this.parseStringLiteral(singleCtx.extractorValue.getText()));
        }
        return collectorMap;
    }

    private Map<String, String> parseProcessorAttributesClause(IoTDBSqlParser.ProcessorAttributesClauseContext ctx) {
        HashMap<String, String> processorMap = new HashMap<String, String>();
        for (IoTDBSqlParser.ProcessorAttributeClauseContext singleCtx : ctx.processorAttributeClause()) {
            processorMap.put(this.parseStringLiteral(singleCtx.processorKey.getText()), this.parseStringLiteral(singleCtx.processorValue.getText()));
        }
        return processorMap;
    }

    private Map<String, String> parseConnectorAttributesClause(IoTDBSqlParser.ConnectorAttributesClauseContext ctx) {
        HashMap<String, String> connectorMap = new HashMap<String, String>();
        for (IoTDBSqlParser.ConnectorAttributeClauseContext singleCtx : ctx.connectorAttributeClause()) {
            connectorMap.put(this.parseStringLiteral(singleCtx.connectorKey.getText()), this.parseStringLiteral(singleCtx.connectorValue.getText()));
        }
        return connectorMap;
    }

    public Statement visitDropPipe(IoTDBSqlParser.DropPipeContext ctx) {
        DropPipeStatement dropPipeStatement = new DropPipeStatement(StatementType.DROP_PIPE);
        if (ctx.pipeName == null) {
            throw new SemanticException("Not support for this sql in DROP PIPE, please enter pipename.");
        }
        dropPipeStatement.setPipeName(ctx.pipeName.getText());
        return dropPipeStatement;
    }

    public Statement visitStartPipe(IoTDBSqlParser.StartPipeContext ctx) {
        StartPipeStatement startPipeStatement = new StartPipeStatement(StatementType.START_PIPE);
        if (ctx.pipeName == null) {
            throw new SemanticException("Not support for this sql in START PIPE, please enter pipename.");
        }
        startPipeStatement.setPipeName(ctx.pipeName.getText());
        return startPipeStatement;
    }

    public Statement visitStopPipe(IoTDBSqlParser.StopPipeContext ctx) {
        StopPipeStatement stopPipeStatement = new StopPipeStatement(StatementType.STOP_PIPE);
        if (ctx.pipeName == null) {
            throw new SemanticException("Not support for this sql in STOP PIPE, please enter pipename.");
        }
        stopPipeStatement.setPipeName(ctx.pipeName.getText());
        return stopPipeStatement;
    }

    public Statement visitShowPipes(IoTDBSqlParser.ShowPipesContext ctx) {
        ShowPipesStatement showPipesStatement = new ShowPipesStatement();
        if (ctx.pipeName != null) {
            showPipesStatement.setPipeName(ASTVisitor.parseIdentifier(ctx.pipeName.getText()));
        }
        showPipesStatement.setWhereClause(ctx.CONNECTOR() != null);
        return showPipesStatement;
    }

    public Statement visitGetRegionId(IoTDBSqlParser.GetRegionIdContext ctx) {
        TConsensusGroupType type = ctx.DATA() == null ? TConsensusGroupType.SchemaRegion : TConsensusGroupType.DataRegion;
        GetRegionIdStatement getRegionIdStatement = new GetRegionIdStatement(type);
        if (ctx.database != null) {
            getRegionIdStatement.setDatabase(ctx.database.getText());
        } else {
            getRegionIdStatement.setDevice(ctx.device.getText());
        }
        getRegionIdStatement.setStartTimeStamp(-1L);
        getRegionIdStatement.setEndTimeStamp(Long.MAX_VALUE);
        if (ctx.timeRangeExpression != null) {
            Expression timeRangeExpression = this.parseExpression(ctx.timeRangeExpression, true);
            getRegionIdStatement = this.parseTimeRangeExpression(timeRangeExpression, getRegionIdStatement);
        }
        return getRegionIdStatement;
    }

    public GetRegionIdStatement parseTimeRangeExpression(Expression timeRangeExpression, GetRegionIdStatement getRegionIdStatement) {
        List<Expression> result = timeRangeExpression.getExpressions();
        if (timeRangeExpression.getExpressionType() == ExpressionType.LOGIC_AND) {
            getRegionIdStatement = this.parseTimeRangeExpression(result.get(0), getRegionIdStatement);
            getRegionIdStatement = this.parseTimeRangeExpression(result.get(1), getRegionIdStatement);
        } else if (result.get(0).getExpressionType() == ExpressionType.TIMESTAMP && result.get(1) instanceof ConstantOperand && ((ConstantOperand)result.get(1)).getDataType() == TSDataType.INT64) {
            ExpressionType tmpType = timeRangeExpression.getExpressionType();
            long timestamp = Long.parseLong(((ConstantOperand)result.get(1)).getValueString());
            switch (tmpType) {
                case EQUAL_TO: {
                    getRegionIdStatement.setStartTimeStamp(Math.max(getRegionIdStatement.getStartTimeStamp(), timestamp));
                    getRegionIdStatement.setEndTimeStamp(Math.min(getRegionIdStatement.getEndTimeStamp(), timestamp));
                    break;
                }
                case GREATER_EQUAL: {
                    getRegionIdStatement.setStartTimeStamp(Math.max(getRegionIdStatement.getStartTimeStamp(), timestamp));
                    break;
                }
                case GREATER_THAN: {
                    getRegionIdStatement.setStartTimeStamp(Math.max(getRegionIdStatement.getStartTimeStamp(), timestamp + 1L));
                    break;
                }
                case LESS_EQUAL: {
                    getRegionIdStatement.setEndTimeStamp(Math.min(getRegionIdStatement.getEndTimeStamp(), timestamp));
                    break;
                }
                case LESS_THAN: {
                    getRegionIdStatement.setEndTimeStamp(Math.min(getRegionIdStatement.getEndTimeStamp(), timestamp - 1L));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        } else {
            throw new SemanticException("Get region id statement\u2018 expression must be a time expression");
        }
        return getRegionIdStatement;
    }

    public Statement visitGetSeriesSlotList(IoTDBSqlParser.GetSeriesSlotListContext ctx) {
        TConsensusGroupType type = ctx.DATA() == null ? TConsensusGroupType.SchemaRegion : TConsensusGroupType.DataRegion;
        return new GetSeriesSlotListStatement(ctx.database.getText(), type);
    }

    public Statement visitGetTimeSlotList(IoTDBSqlParser.GetTimeSlotListContext ctx) {
        long timestamp;
        GetTimeSlotListStatement getTimeSlotListStatement = new GetTimeSlotListStatement();
        if (ctx.database != null) {
            getTimeSlotListStatement.setDatabase(ctx.database.getText());
        } else if (ctx.device != null) {
            getTimeSlotListStatement.setDevice(ctx.device.getText());
        } else if (ctx.regionId != null) {
            getTimeSlotListStatement.setRegionId(Integer.parseInt(ctx.regionId.getText()));
        }
        if (ctx.startTime != null) {
            timestamp = this.parseTimeValue(ctx.startTime, CommonDateTimeUtils.currentTime());
            getTimeSlotListStatement.setStartTime(timestamp);
        }
        if (ctx.endTime != null) {
            timestamp = this.parseTimeValue(ctx.endTime, CommonDateTimeUtils.currentTime());
            getTimeSlotListStatement.setEndTime(timestamp);
        }
        return getTimeSlotListStatement;
    }

    public Statement visitCountTimeSlotList(IoTDBSqlParser.CountTimeSlotListContext ctx) {
        CountTimeSlotListStatement countTimeSlotListStatement = new CountTimeSlotListStatement();
        if (ctx.database != null) {
            countTimeSlotListStatement.setDatabase(ctx.database.getText());
        } else if (ctx.device != null) {
            countTimeSlotListStatement.setDevice(ctx.device.getText());
        } else if (ctx.regionId != null) {
            countTimeSlotListStatement.setRegionId(Integer.parseInt(ctx.regionId.getText()));
        }
        if (ctx.startTime != null) {
            countTimeSlotListStatement.setStartTime(Long.parseLong(ctx.startTime.getText()));
        }
        if (ctx.endTime != null) {
            countTimeSlotListStatement.setEndTime(Long.parseLong(ctx.endTime.getText()));
        }
        return countTimeSlotListStatement;
    }

    public Statement visitMigrateRegion(IoTDBSqlParser.MigrateRegionContext ctx) {
        return new MigrateRegionStatement(Integer.parseInt(ctx.regionId.getText()), Integer.parseInt(ctx.fromId.getText()), Integer.parseInt(ctx.toId.getText()));
    }

    public Statement visitSetSpaceQuota(IoTDBSqlParser.SetSpaceQuotaContext ctx) {
        if (!IoTDBDescriptor.getInstance().getConfig().isQuotaEnable()) {
            throw new SemanticException(LIMIT_CONFIGURATION_ENABLED_ERROR_MSG);
        }
        SetSpaceQuotaStatement setSpaceQuotaStatement = new SetSpaceQuotaStatement();
        List prefixPathContexts = ctx.prefixPath();
        ArrayList<String> paths = new ArrayList<String>();
        for (IoTDBSqlParser.PrefixPathContext prefixPathContext : prefixPathContexts) {
            paths.add(this.parsePrefixPath(prefixPathContext).getFullPath());
        }
        setSpaceQuotaStatement.setPrefixPathList(paths);
        HashMap<String, String> quotas = new HashMap<String, String>();
        for (IoTDBSqlParser.AttributePairContext attributePair : ctx.attributePair()) {
            quotas.put(this.parseAttributeKey(attributePair.attributeKey()), this.parseAttributeValue(attributePair.attributeValue()));
        }
        quotas.keySet().forEach(quotaType -> {
            switch (quotaType) {
                case "devices": {
                    break;
                }
                case "timeseries": {
                    break;
                }
                case "disk": {
                    break;
                }
                default: {
                    throw new SemanticException("Wrong space quota type: " + quotaType);
                }
            }
        });
        if (quotas.containsKey("devices")) {
            if (((String)quotas.get("devices")).equals("unlimited")) {
                setSpaceQuotaStatement.setDeviceNum(-1L);
            } else {
                if (Long.parseLong((String)quotas.get("devices")) <= 0L) {
                    throw new SemanticException("Please set the number of devices greater than 0");
                }
                setSpaceQuotaStatement.setDeviceNum(Long.parseLong((String)quotas.get("devices")));
            }
        }
        if (quotas.containsKey("timeseries")) {
            if (((String)quotas.get("timeseries")).equals("unlimited")) {
                setSpaceQuotaStatement.setTimeSeriesNum(-1L);
            } else {
                if (Long.parseLong((String)quotas.get("timeseries")) <= 0L) {
                    throw new SemanticException("Please set the number of timeseries greater than 0");
                }
                setSpaceQuotaStatement.setTimeSeriesNum(Long.parseLong((String)quotas.get("timeseries")));
            }
        }
        if (quotas.containsKey("disk")) {
            if (((String)quotas.get("disk")).equals("unlimited")) {
                setSpaceQuotaStatement.setDiskSize(-1L);
            } else {
                setSpaceQuotaStatement.setDiskSize(this.parseSpaceQuotaSizeUnit((String)quotas.get("disk")));
            }
        }
        return setSpaceQuotaStatement;
    }

    public Statement visitSetThrottleQuota(IoTDBSqlParser.SetThrottleQuotaContext ctx) {
        Object split;
        TTimedQuota timedQuota;
        if (!IoTDBDescriptor.getInstance().getConfig().isQuotaEnable()) {
            throw new SemanticException(LIMIT_CONFIGURATION_ENABLED_ERROR_MSG);
        }
        if (ASTVisitor.parseIdentifier(ctx.userName.getText()).equals("root")) {
            throw new SemanticException("Cannot set throttle quota for user root.");
        }
        SetThrottleQuotaStatement setThrottleQuotaStatement = new SetThrottleQuotaStatement();
        setThrottleQuotaStatement.setUserName(ASTVisitor.parseIdentifier(ctx.userName.getText()));
        HashMap<String, String> quotas = new HashMap<String, String>();
        HashMap<ThrottleType, TTimedQuota> throttleLimit = new HashMap<ThrottleType, TTimedQuota>();
        for (IoTDBSqlParser.AttributePairContext attributePair : ctx.attributePair()) {
            quotas.put(this.parseAttributeKey(attributePair.attributeKey()), this.parseAttributeValue(attributePair.attributeValue()));
        }
        if (quotas.containsKey("request")) {
            String request = (String)quotas.get("request");
            if (request.equals("unlimited")) {
                timedQuota = new TTimedQuota(1000L, Long.MAX_VALUE);
            } else {
                split = request.toLowerCase().split("req/");
                if (Long.parseLong(split[0]) < 0L) {
                    throw new SemanticException("Please set the number of requests greater than 0");
                }
                timedQuota = new TTimedQuota(this.parseThrottleQuotaTimeUnit(split[1]), Long.parseLong((String)split[0]));
            }
            if (quotas.get("type") == null) {
                throttleLimit.put(ThrottleType.REQUEST_NUMBER, timedQuota);
            } else {
                switch ((String)quotas.get("type")) {
                    case "read": {
                        throttleLimit.put(ThrottleType.READ_NUMBER, timedQuota);
                        break;
                    }
                    case "write": {
                        throttleLimit.put(ThrottleType.WRITE_NUMBER, timedQuota);
                        break;
                    }
                    default: {
                        throw new SemanticException("Please set the correct request type: " + (String)quotas.get("type"));
                    }
                }
            }
        }
        if (quotas.containsKey("size")) {
            String size = (String)quotas.get("size");
            if (size.equals("unlimited")) {
                timedQuota = new TTimedQuota(1000L, Long.MAX_VALUE);
            } else {
                split = size.toLowerCase().split("/");
                timedQuota = new TTimedQuota(this.parseThrottleQuotaTimeUnit(split[1]), this.parseThrottleQuotaSizeUnit((String)split[0]));
            }
            if (quotas.get("type") == null) {
                throttleLimit.put(ThrottleType.REQUEST_SIZE, timedQuota);
            } else {
                switch ((String)quotas.get("type")) {
                    case "read": {
                        throttleLimit.put(ThrottleType.READ_SIZE, timedQuota);
                        break;
                    }
                    case "write": {
                        throttleLimit.put(ThrottleType.WRITE_SIZE, timedQuota);
                        break;
                    }
                    default: {
                        throw new SemanticException("Please set the correct request type: " + (String)quotas.get("type"));
                    }
                }
            }
        }
        if (quotas.containsKey("mem")) {
            String mem = (String)quotas.get("mem");
            if (mem.equals("unlimited")) {
                setThrottleQuotaStatement.setMemLimit(-1L);
            } else {
                setThrottleQuotaStatement.setMemLimit(this.parseThrottleQuotaSizeUnit(mem));
            }
        }
        if (quotas.containsKey("cpu")) {
            String cpuLimit = (String)quotas.get("cpu");
            if (cpuLimit.contains("unlimited")) {
                setThrottleQuotaStatement.setCpuLimit(-1);
            } else {
                int cpuNum = Integer.parseInt(cpuLimit);
                if (cpuNum <= 0) {
                    throw new SemanticException("Please set the number of cpu greater than 0");
                }
                setThrottleQuotaStatement.setCpuLimit(cpuNum);
            }
        }
        setThrottleQuotaStatement.setThrottleLimit(throttleLimit);
        return setThrottleQuotaStatement;
    }

    public Statement visitShowThrottleQuota(IoTDBSqlParser.ShowThrottleQuotaContext ctx) {
        if (!IoTDBDescriptor.getInstance().getConfig().isQuotaEnable()) {
            throw new SemanticException(LIMIT_CONFIGURATION_ENABLED_ERROR_MSG);
        }
        ShowThrottleQuotaStatement showThrottleQuotaStatement = new ShowThrottleQuotaStatement();
        if (ctx.userName != null) {
            showThrottleQuotaStatement.setUserName(ASTVisitor.parseIdentifier(ctx.userName.getText()));
        }
        return showThrottleQuotaStatement;
    }

    private long parseThrottleQuotaTimeUnit(String timeUnit) {
        switch (timeUnit.toLowerCase()) {
            case "sec": {
                return 1000L;
            }
            case "min": {
                return 60000L;
            }
            case "hour": {
                return 3600000L;
            }
            case "day": {
                return 86400000L;
            }
        }
        throw new SemanticException("When setting the request, the unit is incorrect. Please use 'sec', 'min', 'hour', 'day' as the unit");
    }

    private long parseThrottleQuotaSizeUnit(String data) {
        String unit = data.substring(data.length() - 1);
        long size = Long.parseLong(data.substring(0, data.length() - 1));
        if (size <= 0L) {
            throw new SemanticException("Please set the size greater than 0");
        }
        switch (unit.toUpperCase()) {
            case "B": {
                return size;
            }
            case "K": {
                return size * 1024L;
            }
            case "M": {
                return size * 0x100000L;
            }
            case "G": {
                return size * 0x40000000L;
            }
            case "T": {
                return size * 0x10000000000L;
            }
            case "P": {
                return size * 0x4000000000000L;
            }
        }
        throw new SemanticException("When setting the size/time, the unit is incorrect. Please use 'B', 'K', 'M', 'G', 'P', 'T' as the unit");
    }

    private long parseSpaceQuotaSizeUnit(String data) {
        String unit = data.substring(data.length() - 1);
        long disk = Long.parseLong(data.substring(0, data.length() - 1));
        if (disk <= 0L) {
            throw new SemanticException("Please set the disk size greater than 0");
        }
        switch (unit.toUpperCase()) {
            case "M": {
                return disk;
            }
            case "G": {
                return disk * 1024L;
            }
            case "T": {
                return disk * 0x100000L;
            }
            case "P": {
                return disk * 0x40000000L;
            }
        }
        throw new SemanticException("When setting the disk size, the unit is incorrect. Please use 'M', 'G', 'P', 'T' as the unit");
    }

    public Statement visitShowSpaceQuota(IoTDBSqlParser.ShowSpaceQuotaContext ctx) {
        if (!IoTDBDescriptor.getInstance().getConfig().isQuotaEnable()) {
            throw new SemanticException(LIMIT_CONFIGURATION_ENABLED_ERROR_MSG);
        }
        ShowSpaceQuotaStatement showSpaceQuotaStatement = new ShowSpaceQuotaStatement();
        if (ctx.prefixPath() != null) {
            ArrayList<PartialPath> databases = new ArrayList<PartialPath>();
            for (IoTDBSqlParser.PrefixPathContext prefixPathContext : ctx.prefixPath()) {
                databases.add(this.parsePrefixPath(prefixPathContext));
            }
            showSpaceQuotaStatement.setDatabases(databases);
        } else {
            showSpaceQuotaStatement.setDatabases(null);
        }
        return showSpaceQuotaStatement;
    }

    public Statement visitShowCurrentTimestamp(IoTDBSqlParser.ShowCurrentTimestampContext ctx) {
        return new ShowCurrentTimestampStatement();
    }
}

