/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.fragment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryStatistics;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileID;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.datastructure.PatternTreeMapFactory;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;

public class QueryContext {
    private QueryStatistics queryStatistics = new QueryStatistics();
    private final Map<String, PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer>> fileModCache = new ConcurrentHashMap<String, PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer>>();
    protected long queryId;
    private long queryTimeLowerBound = Long.MIN_VALUE;
    private boolean debug;
    private long startTime;
    private long timeout;
    private volatile boolean isInterrupted = false;
    private final Set<TsFileID> nonExistentModFiles = new CopyOnWriteArraySet<TsFileID>();

    public QueryContext() {
    }

    public QueryContext(long queryId) {
        this(queryId, false, System.currentTimeMillis(), 0L);
    }

    public QueryContext(long queryId, boolean debug, long startTime, long timeout) {
        this.queryId = queryId;
        this.debug = debug;
        this.startTime = startTime;
        this.timeout = timeout;
    }

    public List<Modification> getPathModifications(TsFileResource tsFileResource, PartialPath path) {
        if (this.nonExistentModFiles.contains(tsFileResource.getTsFileID())) {
            return Collections.emptyList();
        }
        ModificationFile modFile = tsFileResource.getModFile();
        if (!modFile.exists()) {
            this.nonExistentModFiles.add(tsFileResource.getTsFileID());
            return Collections.emptyList();
        }
        PatternTreeMap allModifications = this.fileModCache.computeIfAbsent(modFile.getFilePath(), k -> {
            PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> modifications = PatternTreeMapFactory.getModsPatternTreeMap();
            for (Modification modification : modFile.getModificationsIter()) {
                modifications.append(modification.getPath(), (Object)modification);
            }
            return modifications;
        });
        return ModificationFile.sortAndMerge(allModifications.getOverlapped(path));
    }

    public List<List<Modification>> getPathModifications(TsFileResource tsFileResource, AlignedPath path) {
        int n = path.getMeasurementList().size();
        ArrayList<List<Modification>> ans = new ArrayList<List<Modification>>(n);
        for (int i = 0; i < n; ++i) {
            ans.add(this.getPathModifications(tsFileResource, path.getPathWithMeasurement(i)));
        }
        return ans;
    }

    public long getQueryId() {
        return this.queryId;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public long getQueryTimeLowerBound() {
        return this.queryTimeLowerBound;
    }

    public void setQueryTimeLowerBound(long queryTimeLowerBound) {
        this.queryTimeLowerBound = queryTimeLowerBound;
    }

    public boolean chunkNotSatisfy(IChunkMetadata chunkMetaData) {
        return chunkMetaData.getEndTime() < this.queryTimeLowerBound;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public QueryContext setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public QueryContext setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public boolean isInterrupted() {
        return this.isInterrupted;
    }

    public void setInterrupted(boolean interrupted) {
        this.isInterrupted = interrupted;
    }

    public QueryStatistics getQueryStatistics() {
        return this.queryStatistics;
    }

    public void setQueryStatistics(QueryStatistics queryStatistics) {
        this.queryStatistics = queryStatistics;
    }
}

