/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common;

import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.common.ResultNodeContext;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.PredicateUtils;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class MPPQueryContext {
    private String sql;
    private QueryId queryId;
    private SessionInfo session;
    private QueryType queryType = QueryType.READ;
    private long timeOut;
    private long startTime;
    private TEndPoint localDataBlockEndpoint;
    private TEndPoint localInternalEndpoint;
    private ResultNodeContext resultNodeContext;
    private TRegionReplicaSet mainFragmentLocatedRegion;
    private final List<TEndPoint> endPointBlackList;
    private final TypeProvider typeProvider = new TypeProvider();
    private Filter globalTimeFilter;
    private int acquiredLockNum;

    public MPPQueryContext(QueryId queryId) {
        this.queryId = queryId;
        this.endPointBlackList = new LinkedList<TEndPoint>();
    }

    public MPPQueryContext(String sql, QueryId queryId, SessionInfo session, TEndPoint localDataBlockEndpoint, TEndPoint localInternalEndpoint) {
        this(queryId);
        this.sql = sql;
        this.session = session;
        this.localDataBlockEndpoint = localDataBlockEndpoint;
        this.localInternalEndpoint = localInternalEndpoint;
        this.initResultNodeContext();
    }

    public void prepareForRetry() {
        this.initResultNodeContext();
    }

    private void initResultNodeContext() {
        this.resultNodeContext = new ResultNodeContext(this.queryId);
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(long timeOut) {
        this.timeOut = timeOut;
    }

    public void setQueryType(QueryType queryType) {
        this.queryType = queryType;
    }

    public ResultNodeContext getResultNodeContext() {
        return this.resultNodeContext;
    }

    public TEndPoint getLocalDataBlockEndpoint() {
        return this.localDataBlockEndpoint;
    }

    public TEndPoint getLocalInternalEndpoint() {
        return this.localInternalEndpoint;
    }

    public SessionInfo getSession() {
        return this.session;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void addFailedEndPoint(TEndPoint endPoint) {
        this.endPointBlackList.add(endPoint);
    }

    public List<TEndPoint> getEndPointBlackList() {
        return this.endPointBlackList;
    }

    public TRegionReplicaSet getMainFragmentLocatedRegion() {
        return this.mainFragmentLocatedRegion;
    }

    public void setMainFragmentLocatedRegion(TRegionReplicaSet region) {
        this.mainFragmentLocatedRegion = region;
    }

    public TypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    public String getSql() {
        return this.sql;
    }

    public int getAcquiredLockNum() {
        return this.acquiredLockNum;
    }

    public void addAcquiredLockNum() {
        ++this.acquiredLockNum;
    }

    public void generateGlobalTimeFilter(Analysis analysis) {
        this.globalTimeFilter = PredicateUtils.convertPredicateToTimeFilter(analysis.getGlobalTimePredicate());
    }

    public Filter getGlobalTimeFilter() {
        return this.globalTimeFilter != null ? this.globalTimeFilter.copy() : null;
    }
}

