/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.thrift.impl;

import io.airlift.units.Duration;
import io.jsonwebtoken.lang.Strings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.audit.AuditLogger;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.protocol.basic.BasicOpenSessionResp;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.protocol.thrift.OperationType;
import org.apache.iotdb.db.protocol.thrift.impl.IClientRPCServiceWithHandler;
import org.apache.iotdb.db.queryengine.common.DataNodeEndPoints;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.execution.aggregation.AccumulatorFactory;
import org.apache.iotdb.db.queryengine.execution.aggregation.Aggregator;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceManager;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationUtil;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.db.queryengine.execution.operator.source.AbstractSeriesAggregationScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.AlignedSeriesAggregationScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesAggregationScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanOperator;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeSchemaCache;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.queryengine.plan.parser.ASTVisitor;
import org.apache.iotdb.db.queryengine.plan.parser.StatementGenerator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.crud.DeleteDataStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsOfOneDeviceStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DatabaseSchemaStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DeleteDatabaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DeleteTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.BatchActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.CreateSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.DropSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.SetSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.UnsetSchemaTemplateStatement;
import org.apache.iotdb.db.schemaengine.template.TemplateQueryType;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.rescon.quotas.DataNodeThrottleQuotaManager;
import org.apache.iotdb.db.storageengine.rescon.quotas.OperationQuota;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.ServerProperties;
import org.apache.iotdb.service.rpc.thrift.TCreateTimeseriesUsingSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.iotdb.service.rpc.thrift.TSAggregationQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSAppendSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSBackupConfigurationResp;
import org.apache.iotdb.service.rpc.thrift.TSCancelOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSConnectionInfoResp;
import org.apache.iotdb.service.rpc.thrift.TSCreateAlignedTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import org.apache.iotdb.service.rpc.thrift.TSDropSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteBatchStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSFastLastDataQueryForOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsResp;
import org.apache.iotdb.service.rpc.thrift.TSGetTimeZoneResp;
import org.apache.iotdb.service.rpc.thrift.TSGroupByQueryIntervalReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletsReq;
import org.apache.iotdb.service.rpc.thrift.TSLastDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.iotdb.service.rpc.thrift.TSPruneSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateResp;
import org.apache.iotdb.service.rpc.thrift.TSRawDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSSetSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneReq;
import org.apache.iotdb.service.rpc.thrift.TSUnsetSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSyncIdentityInfo;
import org.apache.iotdb.service.rpc.thrift.TSyncTransportMetaInfo;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TsBlockSerde;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.TimeFilterApi;
import org.apache.iotdb.tsfile.read.filter.operator.TimeFilterOperators;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TimeDuration;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRPCServiceImpl
implements IClientRPCServiceWithHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientRPCServiceImpl.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Coordinator COORDINATOR = Coordinator.getInstance();
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    public static final String ERROR_CODE = "error code: ";
    private static final TSProtocolVersion CURRENT_RPC_VERSION = TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V3;
    private static final boolean ENABLE_AUDIT_LOG = config.isEnableAuditLog();
    private final IPartitionFetcher partitionFetcher;
    private final ISchemaFetcher schemaFetcher;
    private final TsBlockSerde serde = new TsBlockSerde();
    private final DataNodeSchemaCache DATA_NODE_SCHEMA_CACHE = DataNodeSchemaCache.getInstance();
    public static Duration DEFAULT_TIME_SLICE = new Duration(60000.0, TimeUnit.MILLISECONDS);
    private static final int DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
    private static final SelectResult SELECT_RESULT = (resp, queryExecution, fetchSize) -> {
        Pair<List<ByteBuffer>, Boolean> pair = QueryDataSetUtils.convertQueryResultByFetchSize(queryExecution, fetchSize);
        resp.setQueryResult((List)pair.left);
        return (Boolean)pair.right;
    };
    private static final SelectResult OLD_SELECT_RESULT = (resp, queryExecution, fetchSize) -> {
        Pair<TSQueryDataSet, Boolean> pair = QueryDataSetUtils.convertTsBlockByFetchSize(queryExecution, fetchSize);
        resp.setQueryDataSet((TSQueryDataSet)pair.left);
        return (Boolean)pair.right;
    };

    public ClientRPCServiceImpl() {
        this.partitionFetcher = ClusterPartitionFetcher.getInstance();
        this.schemaFetcher = ClusterSchemaFetcher.getInstance();
    }

    /*
     * Loose catch block
     */
    private TSExecuteStatementResp executeStatementInternal(TSExecuteStatementReq req, SelectResult setResult) {
        TSExecuteStatementResp resp;
        ExecutionResult result;
        Throwable t;
        StatementType statementType;
        long startTime;
        OperationQuota quota;
        String statement;
        long queryId;
        boolean finished;
        block38: {
            Statement s;
            IClientSession clientSession;
            block37: {
                block36: {
                    finished = false;
                    queryId = Long.MIN_VALUE;
                    statement = req.getStatement();
                    clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
                    quota = null;
                    if (!SESSION_MANAGER.checkLogin(clientSession)) {
                        return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
                    }
                    startTime = System.nanoTime();
                    statementType = null;
                    t = null;
                    s = StatementGenerator.createStatement(statement, clientSession.getZoneId());
                    if (s != null) break block36;
                    TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)"This operation type is not supported"));
                    long currentOperationCost = System.nanoTime() - startTime;
                    COORDINATOR.recordExecutionTime(queryId, currentOperationCost);
                    if (statementType != null) {
                        this.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, statementType, currentOperationCost);
                    }
                    if (finished) {
                        long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                        this.addQueryLatency(statementType, executionTime > 0L ? executionTime : currentOperationCost);
                        COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
                    }
                    SESSION_MANAGER.updateIdleTime();
                    if (quota != null) {
                        quota.close();
                    }
                    return tSExecuteStatementResp;
                }
                TSStatus status = AuthorityChecker.checkAuthority(s, clientSession);
                if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) break block37;
                TSExecuteStatementResp currentOperationCost = RpcUtils.getTSExecuteStatementResp((TSStatus)status);
                long currentOperationCost2 = System.nanoTime() - startTime;
                COORDINATOR.recordExecutionTime(queryId, currentOperationCost2);
                if (statementType != null) {
                    this.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, statementType, currentOperationCost2);
                }
                if (finished) {
                    long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                    this.addQueryLatency(statementType, executionTime > 0L ? executionTime : currentOperationCost2);
                    COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
                }
                SESSION_MANAGER.updateIdleTime();
                if (quota != null) {
                    quota.close();
                }
                return currentOperationCost;
            }
            quota = DataNodeThrottleQuotaManager.getInstance().checkQuota(SESSION_MANAGER.getCurrSession().getUsername(), s);
            statementType = s.getType();
            if (ENABLE_AUDIT_LOG) {
                AuditLogger.log(statement, s);
            }
            queryId = SESSION_MANAGER.requestQueryId(clientSession, req.statementId);
            result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(clientSession), statement, this.partitionFetcher, this.schemaFetcher, req.getTimeout());
            if (result.status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.status.code == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) break block38;
            TSExecuteStatementResp currentOperationCost2 = RpcUtils.getTSExecuteStatementResp((TSStatus)result.status);
            long currentOperationCost = System.nanoTime() - startTime;
            COORDINATOR.recordExecutionTime(queryId, currentOperationCost);
            if (statementType != null) {
                this.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, statementType, currentOperationCost);
            }
            if (finished) {
                long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                this.addQueryLatency(statementType, executionTime > 0L ? executionTime : currentOperationCost);
                COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
            }
            SESSION_MANAGER.updateIdleTime();
            if (quota != null) {
                quota.close();
            }
            return currentOperationCost2;
        }
        IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
        SetThreadName threadName = new SetThreadName(result.queryId.getId());
        if (queryExecution != null && queryExecution.isQuery()) {
            resp = this.createResponse(queryExecution.getDatasetHeader(), queryId);
            resp.setStatus(result.status);
            finished = setResult.apply(resp, queryExecution, req.fetchSize);
            resp.setMoreData(!finished);
            quota.addReadResult(resp.getQueryResult());
        } else {
            finished = true;
            resp = RpcUtils.getTSExecuteStatementResp((TSStatus)result.status);
        }
        TSExecuteStatementResp tSExecuteStatementResp = resp;
        threadName.close();
        long currentOperationCost = System.nanoTime() - startTime;
        COORDINATOR.recordExecutionTime(queryId, currentOperationCost);
        if (statementType != null) {
            this.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, statementType, currentOperationCost);
        }
        if (finished) {
            long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
            this.addQueryLatency(statementType, executionTime > 0L ? executionTime : currentOperationCost);
            COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
        }
        SESSION_MANAGER.updateIdleTime();
        if (quota != null) {
            quota.close();
        }
        return tSExecuteStatementResp;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    finished = true;
                    t = e;
                    TSExecuteStatementResp tSExecuteStatementResp2 = RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + statement + "\". " + (Object)((Object)OperationType.EXECUTE_STATEMENT)));
                    long currentOperationCost3 = System.nanoTime() - startTime;
                    COORDINATOR.recordExecutionTime(queryId, currentOperationCost3);
                    if (statementType != null) {
                        this.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, statementType, currentOperationCost3);
                    }
                    if (finished) {
                        long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                        this.addQueryLatency(statementType, executionTime > 0L ? executionTime : currentOperationCost3);
                        COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
                    }
                    SESSION_MANAGER.updateIdleTime();
                    if (quota != null) {
                        quota.close();
                    }
                    return tSExecuteStatementResp2;
                }
                catch (Error error) {
                    try {
                        t = error;
                        throw error;
                    }
                    catch (Throwable throwable3) {
                        long currentOperationCost4 = System.nanoTime() - startTime;
                        COORDINATOR.recordExecutionTime(queryId, currentOperationCost4);
                        if (statementType != null) {
                            this.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, statementType, currentOperationCost4);
                        }
                        if (finished) {
                            long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                            this.addQueryLatency(statementType, executionTime > 0L ? executionTime : currentOperationCost4);
                            COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
                        }
                        SESSION_MANAGER.updateIdleTime();
                        if (quota != null) {
                            quota.close();
                        }
                        throw throwable3;
                    }
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    private TSExecuteStatementResp executeRawDataQueryInternal(TSRawDataQueryReq req, SelectResult setResult) {
        TSExecuteStatementResp resp;
        Statement s;
        Throwable t;
        long startTime;
        OperationQuota quota;
        IClientSession clientSession;
        long queryId;
        boolean finished;
        block25: {
            finished = false;
            queryId = Long.MIN_VALUE;
            clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            quota = null;
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
            }
            startTime = System.nanoTime();
            t = null;
            s = StatementGenerator.createStatement(req, clientSession.getZoneId());
            TSStatus status = AuthorityChecker.checkAuthority(s, clientSession);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) break block25;
            TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)status);
            long currentOperationCost = System.nanoTime() - startTime;
            COORDINATOR.recordExecutionTime(queryId, currentOperationCost);
            this.addStatementExecutionLatency(OperationType.EXECUTE_RAW_DATA_QUERY, StatementType.QUERY, currentOperationCost);
            if (finished) {
                long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost);
                COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
            }
            SESSION_MANAGER.updateIdleTime();
            if (quota != null) {
                quota.close();
            }
            return tSExecuteStatementResp;
        }
        quota = DataNodeThrottleQuotaManager.getInstance().checkQuota(SESSION_MANAGER.getCurrSession().getUsername(), s);
        if (ENABLE_AUDIT_LOG) {
            AuditLogger.log(String.format("execute Raw Data Query: %s", req), s);
        }
        queryId = SESSION_MANAGER.requestQueryId(clientSession, req.statementId);
        ExecutionResult result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher, req.getTimeout());
        if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new RuntimeException(ERROR_CODE + result.status);
        }
        IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
        SetThreadName threadName = new SetThreadName(result.queryId.getId());
        if (queryExecution.isQuery()) {
            resp = this.createResponse(queryExecution.getDatasetHeader(), queryId);
            resp.setStatus(result.status);
            finished = setResult.apply(resp, queryExecution, req.fetchSize);
            resp.setMoreData(!finished);
            quota.addReadResult(resp.getQueryResult());
        } else {
            resp = RpcUtils.getTSExecuteStatementResp((TSStatus)result.status);
        }
        TSExecuteStatementResp tSExecuteStatementResp = resp;
        threadName.close();
        long currentOperationCost = System.nanoTime() - startTime;
        COORDINATOR.recordExecutionTime(queryId, currentOperationCost);
        this.addStatementExecutionLatency(OperationType.EXECUTE_RAW_DATA_QUERY, StatementType.QUERY, currentOperationCost);
        if (finished) {
            long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
            this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost);
            COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
        }
        SESSION_MANAGER.updateIdleTime();
        if (quota != null) {
            quota.close();
        }
        return tSExecuteStatementResp;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    finished = true;
                    t = e;
                    TSExecuteStatementResp tSExecuteStatementResp2 = RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + req + "\". " + (Object)((Object)OperationType.EXECUTE_RAW_DATA_QUERY)));
                    long currentOperationCost2 = System.nanoTime() - startTime;
                    COORDINATOR.recordExecutionTime(queryId, currentOperationCost2);
                    this.addStatementExecutionLatency(OperationType.EXECUTE_RAW_DATA_QUERY, StatementType.QUERY, currentOperationCost2);
                    if (finished) {
                        long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                        this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost2);
                        COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
                    }
                    SESSION_MANAGER.updateIdleTime();
                    if (quota != null) {
                        quota.close();
                    }
                    return tSExecuteStatementResp2;
                }
                catch (Error error) {
                    try {
                        t = error;
                        throw error;
                    }
                    catch (Throwable throwable3) {
                        long currentOperationCost3 = System.nanoTime() - startTime;
                        COORDINATOR.recordExecutionTime(queryId, currentOperationCost3);
                        this.addStatementExecutionLatency(OperationType.EXECUTE_RAW_DATA_QUERY, StatementType.QUERY, currentOperationCost3);
                        if (finished) {
                            long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                            this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost3);
                            COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
                        }
                        SESSION_MANAGER.updateIdleTime();
                        if (quota != null) {
                            quota.close();
                        }
                        throw throwable3;
                    }
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    private TSExecuteStatementResp executeLastDataQueryInternal(TSLastDataQueryReq req, SelectResult setResult) {
        TSExecuteStatementResp resp;
        Statement s;
        Throwable t;
        long startTime;
        OperationQuota quota;
        IClientSession clientSession;
        long queryId;
        boolean finished;
        block25: {
            finished = false;
            queryId = Long.MIN_VALUE;
            clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            quota = null;
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
            }
            startTime = System.nanoTime();
            t = null;
            s = StatementGenerator.createStatement(req, clientSession.getZoneId());
            TSStatus status = AuthorityChecker.checkAuthority(s, clientSession);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) break block25;
            TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)status);
            long currentOperationCost = System.nanoTime() - startTime;
            COORDINATOR.recordExecutionTime(queryId, currentOperationCost);
            this.addStatementExecutionLatency(OperationType.EXECUTE_LAST_DATA_QUERY, StatementType.QUERY, currentOperationCost);
            if (finished) {
                long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost);
                COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
            }
            SESSION_MANAGER.updateIdleTime();
            if (quota != null) {
                quota.close();
            }
            return tSExecuteStatementResp;
        }
        quota = DataNodeThrottleQuotaManager.getInstance().checkQuota(SESSION_MANAGER.getCurrSession().getUsername(), s);
        if (ENABLE_AUDIT_LOG) {
            AuditLogger.log(String.format("Last Data Query: %s", req), s);
        }
        queryId = SESSION_MANAGER.requestQueryId(clientSession, req.statementId);
        ExecutionResult result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher, req.getTimeout());
        if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new RuntimeException(ERROR_CODE + result.status);
        }
        IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
        SetThreadName threadName = new SetThreadName(result.queryId.getId());
        if (queryExecution.isQuery()) {
            resp = this.createResponse(queryExecution.getDatasetHeader(), queryId);
            resp.setStatus(result.status);
            finished = setResult.apply(resp, queryExecution, req.fetchSize);
            resp.setMoreData(!finished);
            quota.addReadResult(resp.getQueryResult());
        } else {
            resp = RpcUtils.getTSExecuteStatementResp((TSStatus)result.status);
        }
        TSExecuteStatementResp tSExecuteStatementResp = resp;
        threadName.close();
        long currentOperationCost = System.nanoTime() - startTime;
        COORDINATOR.recordExecutionTime(queryId, currentOperationCost);
        this.addStatementExecutionLatency(OperationType.EXECUTE_LAST_DATA_QUERY, StatementType.QUERY, currentOperationCost);
        if (finished) {
            long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
            this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost);
            COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
        }
        SESSION_MANAGER.updateIdleTime();
        if (quota != null) {
            quota.close();
        }
        return tSExecuteStatementResp;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    finished = true;
                    t = e;
                    TSExecuteStatementResp tSExecuteStatementResp2 = RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + req + "\". " + (Object)((Object)OperationType.EXECUTE_LAST_DATA_QUERY)));
                    long currentOperationCost2 = System.nanoTime() - startTime;
                    COORDINATOR.recordExecutionTime(queryId, currentOperationCost2);
                    this.addStatementExecutionLatency(OperationType.EXECUTE_LAST_DATA_QUERY, StatementType.QUERY, currentOperationCost2);
                    if (finished) {
                        long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                        this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost2);
                        COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
                    }
                    SESSION_MANAGER.updateIdleTime();
                    if (quota != null) {
                        quota.close();
                    }
                    return tSExecuteStatementResp2;
                }
                catch (Error error) {
                    try {
                        t = error;
                        throw error;
                    }
                    catch (Throwable throwable3) {
                        long currentOperationCost3 = System.nanoTime() - startTime;
                        COORDINATOR.recordExecutionTime(queryId, currentOperationCost3);
                        this.addStatementExecutionLatency(OperationType.EXECUTE_LAST_DATA_QUERY, StatementType.QUERY, currentOperationCost3);
                        if (finished) {
                            long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                            this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost3);
                            COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
                        }
                        SESSION_MANAGER.updateIdleTime();
                        if (quota != null) {
                            quota.close();
                        }
                        throw throwable3;
                    }
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    private TSExecuteStatementResp executeAggregationQueryInternal(TSAggregationQueryReq req, SelectResult setResult) {
        TSExecuteStatementResp resp;
        Statement s;
        Throwable t;
        long startTime;
        OperationQuota quota;
        IClientSession clientSession;
        long queryId;
        boolean finished;
        block24: {
            finished = false;
            queryId = Long.MIN_VALUE;
            clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            quota = null;
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
            }
            startTime = System.nanoTime();
            t = null;
            s = StatementGenerator.createStatement(req, clientSession.getZoneId());
            TSStatus status = AuthorityChecker.checkAuthority(s, clientSession);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) break block24;
            TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)status);
            long currentOperationCost = System.nanoTime() - startTime;
            COORDINATOR.recordExecutionTime(queryId, currentOperationCost);
            this.addStatementExecutionLatency(OperationType.EXECUTE_AGG_QUERY, StatementType.QUERY, currentOperationCost);
            if (finished) {
                long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost);
                COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
            }
            SESSION_MANAGER.updateIdleTime();
            if (quota != null) {
                quota.close();
            }
            return tSExecuteStatementResp;
        }
        quota = DataNodeThrottleQuotaManager.getInstance().checkQuota(SESSION_MANAGER.getCurrSession().getUsername(), s);
        queryId = SESSION_MANAGER.requestQueryId(clientSession, req.statementId);
        ExecutionResult result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher, req.getTimeout());
        if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new RuntimeException(ERROR_CODE + result.status);
        }
        IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
        SetThreadName threadName = new SetThreadName(result.queryId.getId());
        if (queryExecution.isQuery()) {
            resp = this.createResponse(queryExecution.getDatasetHeader(), queryId);
            resp.setStatus(result.status);
            finished = setResult.apply(resp, queryExecution, req.fetchSize);
            resp.setMoreData(!finished);
            quota.addReadResult(resp.getQueryResult());
        } else {
            resp = RpcUtils.getTSExecuteStatementResp((TSStatus)result.status);
        }
        TSExecuteStatementResp tSExecuteStatementResp = resp;
        threadName.close();
        long currentOperationCost = System.nanoTime() - startTime;
        COORDINATOR.recordExecutionTime(queryId, currentOperationCost);
        this.addStatementExecutionLatency(OperationType.EXECUTE_AGG_QUERY, StatementType.QUERY, currentOperationCost);
        if (finished) {
            long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
            this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost);
            COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
        }
        SESSION_MANAGER.updateIdleTime();
        if (quota != null) {
            quota.close();
        }
        return tSExecuteStatementResp;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    finished = true;
                    t = e;
                    TSExecuteStatementResp tSExecuteStatementResp2 = RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + req + "\". " + (Object)((Object)OperationType.EXECUTE_LAST_DATA_QUERY)));
                    long currentOperationCost2 = System.nanoTime() - startTime;
                    COORDINATOR.recordExecutionTime(queryId, currentOperationCost2);
                    this.addStatementExecutionLatency(OperationType.EXECUTE_AGG_QUERY, StatementType.QUERY, currentOperationCost2);
                    if (finished) {
                        long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                        this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost2);
                        COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
                    }
                    SESSION_MANAGER.updateIdleTime();
                    if (quota != null) {
                        quota.close();
                    }
                    return tSExecuteStatementResp2;
                }
                catch (Error error) {
                    try {
                        t = error;
                        throw error;
                    }
                    catch (Throwable throwable3) {
                        long currentOperationCost3 = System.nanoTime() - startTime;
                        COORDINATOR.recordExecutionTime(queryId, currentOperationCost3);
                        this.addStatementExecutionLatency(OperationType.EXECUTE_AGG_QUERY, StatementType.QUERY, currentOperationCost3);
                        if (finished) {
                            long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                            this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost3);
                            COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
                        }
                        SESSION_MANAGER.updateIdleTime();
                        if (quota != null) {
                            quota.close();
                        }
                        throw throwable3;
                    }
                }
            }
        }
    }

    private List<TsBlock> executeGroupByQueryInternal(SessionInfo sessionInfo, String device, String measurement, TSDataType dataType, boolean isAligned, long startTime, long endTime, long interval, TAggregationType aggregationType, List<DataRegion> dataRegionList) throws IllegalPathException {
        AbstractSeriesAggregationScanOperator operator;
        MeasurementPath path;
        int dataRegionSize = dataRegionList.size();
        if (dataRegionSize != 1) {
            throw new IllegalArgumentException("dataRegionList.size() should only be 1 now,  current size is " + dataRegionSize);
        }
        TimeFilterOperators.TimeBetweenAnd timeFilter = TimeFilterApi.between((long)startTime, (long)(endTime - 1L));
        QueryId queryId = new QueryId("stub_query");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
        FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, FragmentInstanceManager.getInstance().instanceNotificationExecutor);
        FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext(instanceId, stateMachine, sessionInfo, dataRegionList.get(0), (Filter)timeFilter);
        DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
        PlanNodeId planNodeId = new PlanNodeId("1");
        driverContext.addOperatorContext(1, planNodeId, SeriesScanOperator.class.getSimpleName());
        driverContext.getOperatorContexts().forEach(operatorContext -> OperatorContext.setMaxRunTime(DEFAULT_TIME_SLICE));
        SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
        scanOptionsBuilder.withAllSensors(Collections.singleton(measurement));
        scanOptionsBuilder.withGlobalTimeFilter((Filter)timeFilter);
        Aggregator aggregator = new Aggregator(AccumulatorFactory.createAccumulator(aggregationType, dataType, null, null, true), AggregationStep.SINGLE, Collections.singletonList(new InputLocation[]{new InputLocation(0, 0)}));
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(startTime, endTime, new TimeDuration(0, interval), new TimeDuration(0, interval), true);
        MeasurementSchema measurementSchema = new MeasurementSchema(measurement, dataType);
        if (isAligned) {
            path = new AlignedPath(device, Collections.singletonList(measurement), Collections.singletonList(measurementSchema));
            operator = new AlignedSeriesAggregationScanOperator(planNodeId, (AlignedPath)path, Ordering.ASC, scanOptionsBuilder.build(), driverContext.getOperatorContexts().get(0), Collections.singletonList(aggregator), AggregationUtil.initTimeRangeIterator(groupByTimeParameter, true, true), groupByTimeParameter, DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
        } else {
            path = new MeasurementPath(device, measurement, (IMeasurementSchema)measurementSchema);
            operator = new SeriesAggregationScanOperator(planNodeId, (PartialPath)path, Ordering.ASC, scanOptionsBuilder.build(), driverContext.getOperatorContexts().get(0), Collections.singletonList(aggregator), AggregationUtil.initTimeRangeIterator(groupByTimeParameter, true, true), groupByTimeParameter, DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
        }
        try {
            ArrayList<TsBlock> result = new ArrayList<TsBlock>();
            fragmentInstanceContext.setSourcePaths(Collections.singletonList(path));
            operator.initQueryDataSource(fragmentInstanceContext.getSharedQueryDataSource());
            while (operator.hasNext()) {
                result.add(operator.next());
            }
            ArrayList<TsBlock> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            fragmentInstanceContext.releaseResource();
        }
    }

    public TSExecuteStatementResp executeQueryStatementV2(TSExecuteStatementReq req) {
        return this.executeStatementV2(req);
    }

    public TSExecuteStatementResp executeUpdateStatementV2(TSExecuteStatementReq req) {
        return this.executeStatementV2(req);
    }

    public TSExecuteStatementResp executeStatementV2(TSExecuteStatementReq req) {
        return this.executeStatementInternal(req, SELECT_RESULT);
    }

    public TSExecuteStatementResp executeRawDataQueryV2(TSRawDataQueryReq req) {
        return this.executeRawDataQueryInternal(req, SELECT_RESULT);
    }

    public TSExecuteStatementResp executeLastDataQueryV2(TSLastDataQueryReq req) {
        return this.executeLastDataQueryInternal(req, SELECT_RESULT);
    }

    /*
     * Loose catch block
     */
    public TSExecuteStatementResp executeFastLastDataQueryForOneDeviceV2(TSFastLastDataQueryForOneDeviceReq req) {
        TSExecuteStatementResp resp;
        Statement s;
        List regionReplicaSets;
        Throwable t;
        long startTime;
        OperationQuota quota;
        IClientSession clientSession;
        long queryId;
        boolean finished;
        block40: {
            TsBlockBuilder builder;
            block39: {
                String sensor2222;
                PartialPath devicePath;
                block38: {
                    String deviceId;
                    String db;
                    finished = false;
                    queryId = Long.MIN_VALUE;
                    clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
                    quota = null;
                    if (!SESSION_MANAGER.checkLogin(clientSession)) {
                        return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
                    }
                    startTime = System.nanoTime();
                    t = null;
                    queryId = SESSION_MANAGER.requestQueryId(clientSession, req.statementId);
                    if (req.isLegalPathNodes()) {
                        db = req.db;
                        deviceId = req.deviceId;
                        devicePath = new PartialPath(deviceId.split("\\."));
                    } else {
                        db = new PartialPath(req.db).getFullPath();
                        devicePath = new PartialPath(req.deviceId);
                        deviceId = devicePath.getFullPath();
                    }
                    DataPartitionQueryParam queryParam = new DataPartitionQueryParam(deviceId, Collections.emptyList(), true, true);
                    DataPartition dataPartition = this.partitionFetcher.getDataPartitionWithUnclosedTimeRange(Collections.singletonMap(db, Collections.singletonList(queryParam)));
                    regionReplicaSets = dataPartition.getDataRegionReplicaSetWithTimeFilter(deviceId, null);
                    if (!regionReplicaSets.isEmpty() && (regionReplicaSets.size() != 1 || DataPartition.NOT_ASSIGNED != regionReplicaSets.get(0))) break block38;
                    TSExecuteStatementResp resp2 = this.createResponse(DatasetHeaderFactory.getLastQueryHeader(), queryId);
                    resp2.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)""));
                    resp2.setQueryResult(Collections.emptyList());
                    finished = true;
                    resp2.setMoreData(false);
                    TSExecuteStatementResp tSExecuteStatementResp = resp2;
                    long currentOperationCost = System.nanoTime() - startTime;
                    COORDINATOR.recordExecutionTime(queryId, currentOperationCost);
                    this.addStatementExecutionLatency(OperationType.EXECUTE_LAST_DATA_QUERY, StatementType.QUERY, currentOperationCost);
                    if (finished) {
                        long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                        this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost);
                        COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
                    }
                    SESSION_MANAGER.updateIdleTime();
                    if (quota != null) {
                        quota.close();
                    }
                    return tSExecuteStatementResp;
                }
                TEndPoint lastRegionLeader = ((TDataNodeLocation)((TRegionReplicaSet)regionReplicaSets.get((int)(regionReplicaSets.size() - 1))).dataNodeLocations.get((int)0)).mPPDataExchangeEndPoint;
                if (!DataNodeEndPoints.isSameNode(lastRegionLeader)) break block39;
                boolean canUseNullEntry = regionReplicaSets.stream().limit((long)regionReplicaSets.size() - 1L).allMatch(regionReplicaSet -> DataNodeEndPoints.isSameNode(((TDataNodeLocation)regionReplicaSet.dataNodeLocations.get((int)0)).mPPDataExchangeEndPoint));
                int sensorNum = req.sensors.size();
                builder = LastQueryUtil.createTsBlockBuilder(sensorNum);
                boolean allCached = true;
                for (String sensor2222 : req.sensors) {
                    PartialPath fullPath = req.isLegalPathNodes() ? devicePath.concatNode(sensor2222) : devicePath.concatNode(new PartialPath(sensor2222).getFullPath());
                    TimeValuePair timeValuePair = this.DATA_NODE_SCHEMA_CACHE.getLastCache(fullPath);
                    if (timeValuePair == null) {
                        allCached = false;
                        break;
                    }
                    if (timeValuePair.getValue() == null) {
                        if (canUseNullEntry) continue;
                        allCached = false;
                        break;
                    }
                    LastQueryUtil.appendLastValue(builder, timeValuePair.getTimestamp(), new Binary(fullPath.getFullPath(), TSFileConfig.STRING_CHARSET), timeValuePair.getValue().getStringValue(), timeValuePair.getValue().getDataType().name());
                }
                if (!allCached) break block39;
                TSExecuteStatementResp resp3 = this.createResponse(DatasetHeaderFactory.getLastQueryHeader(), queryId);
                resp3.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)""));
                if (builder.isEmpty()) {
                    resp3.setQueryResult(Collections.emptyList());
                } else {
                    resp3.setQueryResult(Collections.singletonList(this.serde.serialize(builder.build())));
                }
                finished = true;
                resp3.setMoreData(false);
                sensor2222 = resp3;
                long currentOperationCost = System.nanoTime() - startTime;
                COORDINATOR.recordExecutionTime(queryId, currentOperationCost);
                this.addStatementExecutionLatency(OperationType.EXECUTE_LAST_DATA_QUERY, StatementType.QUERY, currentOperationCost);
                if (finished) {
                    long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                    this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost);
                    COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
                }
                SESSION_MANAGER.updateIdleTime();
                if (quota != null) {
                    quota.close();
                }
                return sensor2222;
            }
            s = StatementGenerator.createStatement(this.convert(req), clientSession.getZoneId());
            TSStatus status = AuthorityChecker.checkAuthority(s, clientSession);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) break block40;
            builder = RpcUtils.getTSExecuteStatementResp((TSStatus)status);
            long currentOperationCost = System.nanoTime() - startTime;
            COORDINATOR.recordExecutionTime(queryId, currentOperationCost);
            this.addStatementExecutionLatency(OperationType.EXECUTE_LAST_DATA_QUERY, StatementType.QUERY, currentOperationCost);
            if (finished) {
                long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost);
                COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
            }
            SESSION_MANAGER.updateIdleTime();
            if (quota != null) {
                quota.close();
            }
            return builder;
        }
        quota = DataNodeThrottleQuotaManager.getInstance().checkQuota(SESSION_MANAGER.getCurrSession().getUsername(), s);
        if (ENABLE_AUDIT_LOG) {
            AuditLogger.log(String.format("Last Data Query: %s", req), s);
        }
        ExecutionResult result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher, req.getTimeout());
        if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new RuntimeException(ERROR_CODE + result.status);
        }
        IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
        SetThreadName threadName = new SetThreadName(result.queryId.getId());
        if (queryExecution.isQuery()) {
            resp = this.createResponse(queryExecution.getDatasetHeader(), queryId);
            TSStatus tsstatus = new TSStatus(TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode());
            tsstatus.setRedirectNode(((TDataNodeLocation)((TRegionReplicaSet)regionReplicaSets.get((int)(regionReplicaSets.size() - 1))).dataNodeLocations.get((int)0)).clientRpcEndPoint);
            resp.setStatus(tsstatus);
            finished = SELECT_RESULT.apply(resp, queryExecution, req.fetchSize);
            resp.setMoreData(!finished);
            quota.addReadResult(resp.getQueryResult());
        } else {
            resp = RpcUtils.getTSExecuteStatementResp((TSStatus)result.status);
        }
        TSExecuteStatementResp tSExecuteStatementResp = resp;
        threadName.close();
        long currentOperationCost = System.nanoTime() - startTime;
        COORDINATOR.recordExecutionTime(queryId, currentOperationCost);
        this.addStatementExecutionLatency(OperationType.EXECUTE_LAST_DATA_QUERY, StatementType.QUERY, currentOperationCost);
        if (finished) {
            long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
            this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost);
            COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
        }
        SESSION_MANAGER.updateIdleTime();
        if (quota != null) {
            quota.close();
        }
        return tSExecuteStatementResp;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    finished = true;
                    t = e;
                    TSExecuteStatementResp tSExecuteStatementResp2 = RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + req + "\". " + (Object)((Object)OperationType.EXECUTE_LAST_DATA_QUERY)));
                    long currentOperationCost2 = System.nanoTime() - startTime;
                    COORDINATOR.recordExecutionTime(queryId, currentOperationCost2);
                    this.addStatementExecutionLatency(OperationType.EXECUTE_LAST_DATA_QUERY, StatementType.QUERY, currentOperationCost2);
                    if (finished) {
                        long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                        this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost2);
                        COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
                    }
                    SESSION_MANAGER.updateIdleTime();
                    if (quota != null) {
                        quota.close();
                    }
                    return tSExecuteStatementResp2;
                }
                catch (Error error) {
                    try {
                        t = error;
                        throw error;
                    }
                    catch (Throwable throwable3) {
                        long currentOperationCost3 = System.nanoTime() - startTime;
                        COORDINATOR.recordExecutionTime(queryId, currentOperationCost3);
                        this.addStatementExecutionLatency(OperationType.EXECUTE_LAST_DATA_QUERY, StatementType.QUERY, currentOperationCost3);
                        if (finished) {
                            long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                            this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost3);
                            COORDINATOR.cleanupQueryExecution(queryId, (TBase<?, ?>)req, t);
                        }
                        SESSION_MANAGER.updateIdleTime();
                        if (quota != null) {
                            quota.close();
                        }
                        throw throwable3;
                    }
                }
            }
        }
    }

    private TSLastDataQueryReq convert(TSFastLastDataQueryForOneDeviceReq req) {
        ArrayList<String> paths = new ArrayList<String>(req.sensors.size());
        for (String sensor : req.sensors) {
            paths.add(req.deviceId + "." + sensor);
        }
        TSLastDataQueryReq tsLastDataQueryReq = new TSLastDataQueryReq(req.sessionId, paths, Long.MIN_VALUE, req.statementId);
        tsLastDataQueryReq.setFetchSize(req.fetchSize);
        tsLastDataQueryReq.setEnableRedirectQuery(req.enableRedirectQuery);
        tsLastDataQueryReq.setLegalPathNodes(req.legalPathNodes);
        tsLastDataQueryReq.setTimeout(req.timeout);
        return tsLastDataQueryReq;
    }

    public TSExecuteStatementResp executeAggregationQueryV2(TSAggregationQueryReq req) {
        return this.executeAggregationQueryInternal(req, SELECT_RESULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSExecuteStatementResp executeGroupByQueryIntervalQuery(TSGroupByQueryIntervalReq req) throws TException {
        try {
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            String database = req.getDatabase();
            if (StringUtils.isEmpty((CharSequence)database)) {
                String[] splits = Strings.split((String)req.getDevice(), (String)"\\.");
                database = String.format("%s.%s", splits[0], splits[1]);
            }
            String deviceId = req.getDevice();
            String measurementId = req.getMeasurement();
            TSDataType dataType = TSDataType.getTsDataType((byte)((byte)req.getDataType()));
            HashMap<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap = new HashMap<String, List<DataPartitionQueryParam>>();
            TTimePartitionSlot timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)req.getStartTime());
            DataPartitionQueryParam queryParam = new DataPartitionQueryParam(deviceId, Collections.singletonList(timePartitionSlot), false, false);
            sgNameToQueryParamsMap.put(database, Collections.singletonList(queryParam));
            DataPartition dataPartition = this.partitionFetcher.getDataPartition(sgNameToQueryParamsMap);
            ArrayList<DataRegion> dataRegionList = new ArrayList<DataRegion>();
            List replicaSets = dataPartition.getDataRegionReplicaSetWithTimeFilter(deviceId, null);
            for (TRegionReplicaSet region : replicaSets) {
                dataRegionList.add(StorageEngine.getInstance().getDataRegion(new DataRegionId(region.getRegionId().getId())));
            }
            List<TsBlock> blockResult = this.executeGroupByQueryInternal(SESSION_MANAGER.getSessionInfo(clientSession), deviceId, measurementId, dataType, true, req.getStartTime(), req.getEndTime(), req.getInterval(), req.getAggregationType(), dataRegionList);
            String outputColumnName = req.getAggregationType().name();
            List<ColumnHeader> columnHeaders = Collections.singletonList(new ColumnHeader(outputColumnName, dataType));
            DatasetHeader header = new DatasetHeader(columnHeaders, false);
            header.setColumnToTsBlockIndexMap(Collections.singletonList(outputColumnName));
            TSExecuteStatementResp resp = this.createResponse(header, 1L);
            TSQueryDataSet queryDataSet = QueryDataSetUtils.convertTsBlockByFetchSize(blockResult);
            resp.setQueryDataSet(queryDataSet);
            TSExecuteStatementResp tSExecuteStatementResp = resp;
            return tSExecuteStatementResp;
        }
        catch (Exception e) {
            TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + req + "\". " + (Object)((Object)OperationType.EXECUTE_AGG_QUERY)));
            return tSExecuteStatementResp;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * Loose catch block
     */
    public TSFetchResultsResp fetchResultsV2(TSFetchResultsReq req) {
        TSFetchResultsResp resp;
        IQueryExecution queryExecution;
        Throwable t;
        StatementType statementType;
        boolean finished;
        long startTime;
        block19: {
            block18: {
                startTime = System.nanoTime();
                finished = false;
                statementType = null;
                t = null;
                queryExecution = null;
                IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
                if (SESSION_MANAGER.checkLogin(clientSession)) break block18;
                TSFetchResultsResp tSFetchResultsResp = RpcUtils.getTSFetchResultsResp((TSStatus)this.getNotLoggedInStatus());
                long currentOperationCost = System.nanoTime() - startTime;
                COORDINATOR.recordExecutionTime(req.queryId, currentOperationCost);
                this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, currentOperationCost);
                if (finished) {
                    long executionTime = COORDINATOR.getTotalExecutionTime(req.queryId);
                    this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost);
                    COORDINATOR.cleanupQueryExecution(req.queryId, (TBase<?, ?>)req, t);
                }
                SESSION_MANAGER.updateIdleTime();
                return tSFetchResultsResp;
            }
            resp = RpcUtils.getTSFetchResultsResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            queryExecution = COORDINATOR.getQueryExecution(req.queryId);
            if (queryExecution != null) break block19;
            resp.setHasResultSet(false);
            resp.setMoreData(false);
            TSFetchResultsResp currentOperationCost = resp;
            long currentOperationCost2 = System.nanoTime() - startTime;
            COORDINATOR.recordExecutionTime(req.queryId, currentOperationCost2);
            this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, currentOperationCost2);
            if (finished) {
                long executionTime = COORDINATOR.getTotalExecutionTime(req.queryId);
                this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost2);
                COORDINATOR.cleanupQueryExecution(req.queryId, (TBase<?, ?>)req, t);
            }
            SESSION_MANAGER.updateIdleTime();
            return currentOperationCost;
        }
        statementType = queryExecution.getStatement().getType();
        SetThreadName queryName = new SetThreadName(queryExecution.getQueryId());
        Pair<List<ByteBuffer>, Boolean> pair = QueryDataSetUtils.convertQueryResultByFetchSize(queryExecution, req.fetchSize);
        List result2222 = (List)pair.left;
        finished = (Boolean)pair.right;
        boolean hasResultSet = !result2222.isEmpty();
        resp.setHasResultSet(hasResultSet);
        resp.setIsAlign(true);
        resp.setQueryResult(result2222);
        resp.setMoreData(!finished);
        TSFetchResultsResp tSFetchResultsResp = resp;
        queryName.close();
        long currentOperationCost = System.nanoTime() - startTime;
        COORDINATOR.recordExecutionTime(req.queryId, currentOperationCost);
        this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, currentOperationCost);
        if (finished) {
            long executionTime = COORDINATOR.getTotalExecutionTime(req.queryId);
            this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost);
            COORDINATOR.cleanupQueryExecution(req.queryId, (TBase<?, ?>)req, t);
        }
        SESSION_MANAGER.updateIdleTime();
        return tSFetchResultsResp;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        queryName.close();
                    }
                    catch (Throwable result2222) {
                        throwable.addSuppressed(result2222);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    finished = true;
                    t = e;
                    TSFetchResultsResp tSFetchResultsResp2 = RpcUtils.getTSFetchResultsResp((TSStatus)ErrorHandlingUtils.onQueryException(e, CommonUtils.getContentOfRequest(req, queryExecution)));
                    long currentOperationCost3 = System.nanoTime() - startTime;
                    COORDINATOR.recordExecutionTime(req.queryId, currentOperationCost3);
                    this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, currentOperationCost3);
                    if (finished) {
                        long executionTime = COORDINATOR.getTotalExecutionTime(req.queryId);
                        this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost3);
                        COORDINATOR.cleanupQueryExecution(req.queryId, (TBase<?, ?>)req, t);
                    }
                    SESSION_MANAGER.updateIdleTime();
                    return tSFetchResultsResp2;
                }
                catch (Error error) {
                    try {
                        finished = true;
                        t = error;
                        throw error;
                    }
                    catch (Throwable throwable2) {
                        long currentOperationCost4 = System.nanoTime() - startTime;
                        COORDINATOR.recordExecutionTime(req.queryId, currentOperationCost4);
                        this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, currentOperationCost4);
                        if (finished) {
                            long executionTime = COORDINATOR.getTotalExecutionTime(req.queryId);
                            this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost4);
                            COORDINATOR.cleanupQueryExecution(req.queryId, (TBase<?, ?>)req, t);
                        }
                        SESSION_MANAGER.updateIdleTime();
                        throw throwable2;
                    }
                }
            }
        }
    }

    public TSOpenSessionResp openSession(TSOpenSessionReq req) throws TException {
        IoTDBConstant.ClientVersion clientVersion = this.parseClientVersion(req);
        BasicOpenSessionResp openSessionResp = SESSION_MANAGER.login(SESSION_MANAGER.getCurrSession(), req.username, req.password, req.zoneId, req.client_protocol, clientVersion);
        TSStatus tsStatus = RpcUtils.getStatus((int)openSessionResp.getCode(), (String)openSessionResp.getMessage());
        TSOpenSessionResp resp = new TSOpenSessionResp(tsStatus, CURRENT_RPC_VERSION);
        return resp.setSessionId(openSessionResp.getSessionId());
    }

    private IoTDBConstant.ClientVersion parseClientVersion(TSOpenSessionReq req) {
        Map configuration = req.configuration;
        if (configuration != null && configuration.containsKey("version")) {
            return IoTDBConstant.ClientVersion.valueOf((String)((String)configuration.get("version")));
        }
        return IoTDBConstant.ClientVersion.V_0_12;
    }

    public TSStatus closeSession(TSCloseSessionReq req) {
        return new TSStatus(!SESSION_MANAGER.closeSession(SESSION_MANAGER.getCurrSession(), COORDINATOR::cleanupQueryExecution) ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN) : RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
    }

    public TSStatus cancelOperation(TSCancelOperationReq req) {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_NOT_ALLOWED, (String)"Cancellation is not implemented");
    }

    public TSStatus closeOperation(TSCloseOperationReq req) {
        return SESSION_MANAGER.closeOperation(SESSION_MANAGER.getCurrSession(), req.queryId, req.statementId, req.isSetStatementId(), req.isSetQueryId(), COORDINATOR::cleanupQueryExecution);
    }

    public TSGetTimeZoneResp getTimeZone(long sessionId) {
        try {
            ZoneId zoneId = SESSION_MANAGER.getCurrSession().getZoneId();
            return new TSGetTimeZoneResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS), zoneId != null ? zoneId.toString() : "Unknown time zone");
        }
        catch (Exception e) {
            return new TSGetTimeZoneResp(ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.GET_TIME_ZONE, TSStatusCode.GENERATE_TIME_ZONE_ERROR), "Unknown time zone");
        }
    }

    public TSStatus setTimeZone(TSSetTimeZoneReq req) {
        try {
            SESSION_MANAGER.getCurrSession().setZoneId(ZoneId.of(req.timeZone));
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.SET_TIME_ZONE, TSStatusCode.SET_TIME_ZONE_ERROR);
        }
    }

    public ServerProperties getProperties() {
        ServerProperties properties = new ServerProperties();
        properties.setVersion(IoTDBConstant.VERSION);
        properties.setLogo(" _____       _________  ______   ______    \n|_   _|     |  _   _  ||_   _ `.|_   _ \\   \n  | |   .--.|_/ | | \\_|  | | `. \\ | |_) |  \n  | | / .'`\\ \\  | |      | |  | | |  __'.  \n _| |_| \\__. | _| |_    _| |_.' /_| |__) | \n|_____|'.__.' |_____|  |______.'|_______/  ");
        properties.setBuildInfo(IoTDBConstant.BUILD_INFO);
        LOGGER.info("IoTDB server version: {}", (Object)IoTDBConstant.VERSION_WITH_BUILD);
        properties.setSupportedTimeAggregationOperations(new ArrayList());
        properties.getSupportedTimeAggregationOperations().add("max_time");
        properties.getSupportedTimeAggregationOperations().add("min_time");
        properties.setTimestampPrecision(CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
        properties.setMaxConcurrentClientNum(IoTDBDescriptor.getInstance().getConfig().getRpcMaxConcurrentClientNum());
        properties.setIsReadOnly(CommonDescriptor.getInstance().getConfig().isReadOnly());
        properties.setThriftMaxFrameSize(IoTDBDescriptor.getInstance().getConfig().getThriftMaxFrameSize());
        return properties;
    }

    public TSStatus setStorageGroup(long sessionId, String storageGroup) {
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                return this.getNotLoggedInStatus();
            }
            DatabaseSchemaStatement statement = StatementGenerator.createStatement(storageGroup);
            if (ENABLE_AUDIT_LOG) {
                AuditLogger.log(String.format("create database %s", storageGroup), statement);
            }
            if ((status = AuthorityChecker.checkAuthority((Statement)statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            return result.status;
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.SET_STORAGE_GROUP, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.SET_STORAGE_GROUP, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus createTimeseries(TSCreateTimeseriesReq req) {
        TSStatus tSStatus;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurementAlias(PathUtils.checkAndReturnSingleMeasurement((String)req.getMeasurementAlias()));
            CreateTimeSeriesStatement statement = StatementGenerator.createStatement(req);
            if (ENABLE_AUDIT_LOG) {
                AuditLogger.log(String.format("create timeseries %s", req.getPath()), statement);
            }
            if ((status = AuthorityChecker.checkAuthority((Statement)statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_TIMESERIES, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.CREATE_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus createAlignedTimeseries(TSCreateAlignedTimeseriesReq req) {
        TSStatus tSStatus;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurementAlias(PathUtils.checkIsLegalSingleMeasurementsAndUpdate((List)req.getMeasurementAlias()));
            req.setMeasurements(PathUtils.checkIsLegalSingleMeasurementsAndUpdate((List)req.getMeasurements()));
            CreateAlignedTimeSeriesStatement statement = StatementGenerator.createStatement(req);
            if (ENABLE_AUDIT_LOG) {
                AuditLogger.log(String.format("create aligned timeseries %s.%s", req.getPrefixPath(), req.getMeasurements()), statement);
            }
            if ((status = AuthorityChecker.checkAuthority((Statement)statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_ALIGNED_TIMESERIES, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.CREATE_ALIGNED_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus createMultiTimeseries(TSCreateMultiTimeseriesReq req) {
        TSStatus tSStatus;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurementAliasList(PathUtils.checkIsLegalSingleMeasurementsAndUpdate((List)req.getMeasurementAliasList()));
            CreateMultiTimeSeriesStatement statement = StatementGenerator.createStatement(req);
            if (ENABLE_AUDIT_LOG) {
                AuditLogger.log(String.format("create %s timeseries, the first is %s", req.getPaths().size(), req.getPaths().get(0)), statement);
            }
            if ((status = AuthorityChecker.checkAuthority((Statement)statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_MULTI_TIMESERIES, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.CREATE_MULTI_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus deleteTimeseries(long sessionId, List<String> path) {
        TSStatus tSStatus;
        try {
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            DeleteTimeSeriesStatement statement = StatementGenerator.createDeleteTimeSeriesStatement(path);
            TSStatus status = AuthorityChecker.checkAuthority((Statement)statement, clientSession);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.DELETE_TIMESERIES, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.DELETE_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus deleteStorageGroups(long sessionId, List<String> storageGroups) {
        TSStatus tSStatus;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            DeleteDatabaseStatement statement = StatementGenerator.createStatement(storageGroups);
            if (ENABLE_AUDIT_LOG) {
                AuditLogger.log(String.format("delete databases: %s", storageGroups), statement);
            }
            if ((status = AuthorityChecker.checkAuthority((Statement)statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.DELETE_STORAGE_GROUPS, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.DELETE_STORAGE_GROUPS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    public TSFetchMetadataResp fetchMetadata(TSFetchMetadataReq req) {
        return new TSFetchMetadataResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNSUPPORTED_OPERATION, (String)"Fetch Metadata is not supported."));
    }

    public TSExecuteStatementResp executeStatement(TSExecuteStatementReq req) {
        return this.executeStatementInternal(req, OLD_SELECT_RESULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus executeBatchStatement(TSExecuteBatchStatementReq req) {
        long t1 = System.nanoTime();
        ArrayList<TSStatus> results = new ArrayList<TSStatus>();
        boolean isAllSuccessful = true;
        IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
        if (!SESSION_MANAGER.checkLogin(clientSession)) {
            return this.getNotLoggedInStatus();
        }
        try {
            for (int i = 0; i < req.getStatements().size(); ++i) {
                TSStatus status;
                Statement s;
                OperationQuota quota;
                StatementType type;
                long t2;
                String statement;
                block19: {
                    block18: {
                        statement = (String)req.getStatements().get(i);
                        t2 = System.nanoTime();
                        type = null;
                        quota = null;
                        s = StatementGenerator.createStatement(statement, clientSession.getZoneId());
                        if (s != null) break block18;
                        TSStatus tSStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"This operation type is not supported");
                        this.addStatementExecutionLatency(OperationType.EXECUTE_STATEMENT, type, System.nanoTime() - t2);
                        if (quota != null) {
                            quota.close();
                        }
                        return tSStatus;
                    }
                    status = AuthorityChecker.checkAuthority(s, clientSession);
                    if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) break block19;
                    TSStatus tSStatus = status;
                    this.addStatementExecutionLatency(OperationType.EXECUTE_STATEMENT, type, System.nanoTime() - t2);
                    if (quota != null) {
                        quota.close();
                    }
                    return tSStatus;
                }
                try {
                    quota = DataNodeThrottleQuotaManager.getInstance().checkQuota(SESSION_MANAGER.getCurrSession().getUsername(), s);
                    if (ENABLE_AUDIT_LOG) {
                        AuditLogger.log(statement, s);
                    }
                    long queryId = SESSION_MANAGER.requestQueryId();
                    type = s.getType();
                    ExecutionResult result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(clientSession), statement, this.partitionFetcher, this.schemaFetcher, config.getQueryTimeoutThreshold());
                    results.add(result.status);
                    this.addStatementExecutionLatency(OperationType.EXECUTE_STATEMENT, type, System.nanoTime() - t2);
                    if (quota == null) continue;
                    quota.close();
                    continue;
                }
                catch (Exception e) {
                    try {
                        LOGGER.warn("Error occurred when executing executeBatchStatement: ", (Throwable)e);
                        status = ErrorHandlingUtils.onQueryException(e, "\"" + statement + "\". " + (Object)((Object)OperationType.EXECUTE_BATCH_STATEMENT));
                        if (status.getCode() != TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode()) {
                            isAllSuccessful = false;
                        }
                        results.add(status);
                        this.addStatementExecutionLatency(OperationType.EXECUTE_STATEMENT, type, System.nanoTime() - t2);
                        if (quota == null) continue;
                        quota.close();
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.addStatementExecutionLatency(OperationType.EXECUTE_STATEMENT, type, System.nanoTime() - t2);
                        if (quota != null) {
                            quota.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.addStatementExecutionLatency(OperationType.EXECUTE_BATCH_STATEMENT, StatementType.NULL, System.nanoTime() - t1);
            SESSION_MANAGER.updateIdleTime();
        }
        return isAllSuccessful ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute batch statements successfully") : RpcUtils.getStatus(results);
    }

    public TSExecuteStatementResp executeQueryStatement(TSExecuteStatementReq req) {
        return this.executeStatement(req);
    }

    public TSExecuteStatementResp executeUpdateStatement(TSExecuteStatementReq req) {
        return this.executeStatement(req);
    }

    /*
     * Loose catch block
     */
    public TSFetchResultsResp fetchResults(TSFetchResultsReq req) {
        TSFetchResultsResp resp;
        IQueryExecution queryExecution;
        Throwable t;
        StatementType statementType;
        long startTime;
        boolean finished;
        block19: {
            block18: {
                finished = false;
                startTime = System.nanoTime();
                statementType = null;
                t = null;
                queryExecution = null;
                IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
                if (SESSION_MANAGER.checkLogin(clientSession)) break block18;
                TSFetchResultsResp tSFetchResultsResp = RpcUtils.getTSFetchResultsResp((TSStatus)this.getNotLoggedInStatus());
                long currentOperationCost = System.nanoTime() - startTime;
                COORDINATOR.recordExecutionTime(req.queryId, currentOperationCost);
                this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, currentOperationCost);
                if (finished) {
                    long executionTime = COORDINATOR.getTotalExecutionTime(req.queryId);
                    this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost);
                    COORDINATOR.cleanupQueryExecution(req.queryId, (TBase<?, ?>)req, t);
                }
                SESSION_MANAGER.updateIdleTime();
                return tSFetchResultsResp;
            }
            resp = RpcUtils.getTSFetchResultsResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            queryExecution = COORDINATOR.getQueryExecution(req.queryId);
            if (queryExecution != null) break block19;
            resp.setHasResultSet(false);
            resp.setMoreData(true);
            TSFetchResultsResp currentOperationCost = resp;
            long currentOperationCost2 = System.nanoTime() - startTime;
            COORDINATOR.recordExecutionTime(req.queryId, currentOperationCost2);
            this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, currentOperationCost2);
            if (finished) {
                long executionTime = COORDINATOR.getTotalExecutionTime(req.queryId);
                this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost2);
                COORDINATOR.cleanupQueryExecution(req.queryId, (TBase<?, ?>)req, t);
            }
            SESSION_MANAGER.updateIdleTime();
            return currentOperationCost;
        }
        statementType = queryExecution.getStatement().getType();
        SetThreadName queryName = new SetThreadName(queryExecution.getQueryId());
        Pair<TSQueryDataSet, Boolean> pair = QueryDataSetUtils.convertTsBlockByFetchSize(queryExecution, req.fetchSize);
        TSQueryDataSet result2222 = (TSQueryDataSet)pair.left;
        finished = (Boolean)pair.right;
        boolean hasResultSet = result2222.bufferForTime().limit() != 0;
        resp.setHasResultSet(hasResultSet);
        resp.setQueryDataSet(result2222);
        resp.setIsAlign(true);
        resp.setMoreData(finished);
        TSFetchResultsResp tSFetchResultsResp = resp;
        queryName.close();
        long currentOperationCost = System.nanoTime() - startTime;
        COORDINATOR.recordExecutionTime(req.queryId, currentOperationCost);
        this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, currentOperationCost);
        if (finished) {
            long executionTime = COORDINATOR.getTotalExecutionTime(req.queryId);
            this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost);
            COORDINATOR.cleanupQueryExecution(req.queryId, (TBase<?, ?>)req, t);
        }
        SESSION_MANAGER.updateIdleTime();
        return tSFetchResultsResp;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        queryName.close();
                    }
                    catch (Throwable result2222) {
                        throwable.addSuppressed(result2222);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    finished = true;
                    t = e;
                    TSFetchResultsResp tSFetchResultsResp2 = RpcUtils.getTSFetchResultsResp((TSStatus)ErrorHandlingUtils.onQueryException(e, CommonUtils.getContentOfRequest(req, queryExecution)));
                    long currentOperationCost3 = System.nanoTime() - startTime;
                    COORDINATOR.recordExecutionTime(req.queryId, currentOperationCost3);
                    this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, currentOperationCost3);
                    if (finished) {
                        long executionTime = COORDINATOR.getTotalExecutionTime(req.queryId);
                        this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost3);
                        COORDINATOR.cleanupQueryExecution(req.queryId, (TBase<?, ?>)req, t);
                    }
                    SESSION_MANAGER.updateIdleTime();
                    return tSFetchResultsResp2;
                }
                catch (Error error) {
                    try {
                        t = error;
                        throw error;
                    }
                    catch (Throwable throwable2) {
                        long currentOperationCost4 = System.nanoTime() - startTime;
                        COORDINATOR.recordExecutionTime(req.queryId, currentOperationCost4);
                        this.addStatementExecutionLatency(OperationType.FETCH_RESULTS, statementType, currentOperationCost4);
                        if (finished) {
                            long executionTime = COORDINATOR.getTotalExecutionTime(req.queryId);
                            this.addQueryLatency(StatementType.QUERY, executionTime > 0L ? executionTime : currentOperationCost4);
                            COORDINATOR.cleanupQueryExecution(req.queryId, (TBase<?, ?>)req, t);
                        }
                        SESSION_MANAGER.updateIdleTime();
                        throw throwable2;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertRecords(TSInsertRecordsReq req) {
        TSStatus tSStatus;
        long t1 = System.nanoTime();
        OperationQuota quota = null;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurementsList(PathUtils.checkIsLegalSingleMeasurementListsAndUpdate((List)req.getMeasurementsList()));
            InsertRowsStatement statement = StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            if (ENABLE_AUDIT_LOG) {
                AuditLogger.log(String.format("insertRecords, first device %s, first time %s", req.prefixPaths.get(0), req.getTimestamps().get(0)), statement, true);
            }
            if ((status = AuthorityChecker.checkAuthority((Statement)statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            quota = DataNodeThrottleQuotaManager.getInstance().checkQuota(SESSION_MANAGER.getCurrSession().getUsername(), statement);
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_RECORDS, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.INSERT_RECORDS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addStatementExecutionLatency(OperationType.INSERT_RECORDS, StatementType.BATCH_INSERT_ROWS, System.nanoTime() - t1);
            SESSION_MANAGER.updateIdleTime();
            if (quota != null) {
                quota.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req) {
        TSStatus tSStatus;
        long t1 = System.nanoTime();
        OperationQuota quota = null;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurementsList(PathUtils.checkIsLegalSingleMeasurementListsAndUpdate((List)req.getMeasurementsList()));
            InsertRowsOfOneDeviceStatement statement = StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            if (ENABLE_AUDIT_LOG) {
                AuditLogger.log(String.format("insertRecords, first device %s, first time %s", req.prefixPath, req.getTimestamps().get(0)), statement, true);
            }
            if ((status = AuthorityChecker.checkAuthority((Statement)statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            quota = DataNodeThrottleQuotaManager.getInstance().checkQuota(SESSION_MANAGER.getCurrSession().getUsername(), statement);
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_RECORDS_OF_ONE_DEVICE, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.INSERT_RECORDS_OF_ONE_DEVICE, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addStatementExecutionLatency(OperationType.INSERT_RECORDS_OF_ONE_DEVICE, StatementType.BATCH_INSERT_ONE_DEVICE, System.nanoTime() - t1);
            SESSION_MANAGER.updateIdleTime();
            if (quota != null) {
                quota.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertStringRecordsOfOneDevice(TSInsertStringRecordsOfOneDeviceReq req) {
        TSStatus tSStatus;
        long t1 = System.nanoTime();
        OperationQuota quota = null;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurementsList(PathUtils.checkIsLegalSingleMeasurementListsAndUpdate((List)req.getMeasurementsList()));
            InsertRowsOfOneDeviceStatement statement = StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            if (ENABLE_AUDIT_LOG) {
                AuditLogger.log(String.format("insertRecords, first device %s, first time %s", req.prefixPath, req.getTimestamps().get(0)), statement, true);
            }
            if ((status = AuthorityChecker.checkAuthority((Statement)statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            quota = DataNodeThrottleQuotaManager.getInstance().checkQuota(SESSION_MANAGER.getCurrSession().getUsername(), statement);
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_STRING_RECORDS_OF_ONE_DEVICE, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.INSERT_STRING_RECORDS_OF_ONE_DEVICE, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addStatementExecutionLatency(OperationType.INSERT_STRING_RECORDS_OF_ONE_DEVICE, StatementType.BATCH_INSERT_ONE_DEVICE, System.nanoTime() - t1);
            SESSION_MANAGER.updateIdleTime();
            if (quota != null) {
                quota.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertRecord(TSInsertRecordReq req) {
        TSStatus tSStatus;
        long t1 = System.nanoTime();
        OperationQuota quota = null;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurements(PathUtils.checkIsLegalSingleMeasurementsAndUpdate((List)req.getMeasurements()));
            InsertRowStatement statement = StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            if (ENABLE_AUDIT_LOG) {
                AuditLogger.log(String.format("insertRecord, device %s, time %s", req.getPrefixPath(), req.getTimestamp()), statement, true);
            }
            if ((status = AuthorityChecker.checkAuthority((Statement)statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            quota = DataNodeThrottleQuotaManager.getInstance().checkQuota(SESSION_MANAGER.getCurrSession().getUsername(), statement);
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_RECORD, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.INSERT_RECORD, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addStatementExecutionLatency(OperationType.INSERT_RECORD, StatementType.INSERT, System.nanoTime() - t1);
            SESSION_MANAGER.updateIdleTime();
            if (quota != null) {
                quota.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertTablets(TSInsertTabletsReq req) {
        TSStatus tSStatus;
        long t1 = System.nanoTime();
        OperationQuota quota = null;
        try {
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurementsList(PathUtils.checkIsLegalSingleMeasurementListsAndUpdate((List)req.getMeasurementsList()));
            InsertMultiTabletsStatement statement = StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            TSStatus status = AuthorityChecker.checkAuthority((Statement)statement, clientSession);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            quota = DataNodeThrottleQuotaManager.getInstance().checkQuota(SESSION_MANAGER.getCurrSession().getUsername(), statement);
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_TABLETS, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.INSERT_TABLETS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addStatementExecutionLatency(OperationType.INSERT_TABLETS, StatementType.MULTI_BATCH_INSERT, System.nanoTime() - t1);
            SESSION_MANAGER.updateIdleTime();
            if (quota != null) {
                quota.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertTablet(TSInsertTabletReq req) {
        TSStatus tSStatus;
        long t1 = System.nanoTime();
        OperationQuota quota = null;
        try {
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurements(PathUtils.checkIsLegalSingleMeasurementsAndUpdate((List)req.getMeasurements()));
            InsertTabletStatement statement = StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            TSStatus status = AuthorityChecker.checkAuthority((Statement)statement, clientSession);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            quota = DataNodeThrottleQuotaManager.getInstance().checkQuota(SESSION_MANAGER.getCurrSession().getUsername(), statement);
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_TABLET, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.INSERT_TABLET, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addStatementExecutionLatency(OperationType.INSERT_TABLET, StatementType.BATCH_INSERT, System.nanoTime() - t1);
            SESSION_MANAGER.updateIdleTime();
            if (quota != null) {
                quota.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertStringRecords(TSInsertStringRecordsReq req) {
        TSStatus tSStatus;
        long t1 = System.nanoTime();
        OperationQuota quota = null;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurementsList(PathUtils.checkIsLegalSingleMeasurementListsAndUpdate((List)req.getMeasurementsList()));
            InsertRowsStatement statement = StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            if (ENABLE_AUDIT_LOG) {
                AuditLogger.log(String.format("insertRecords, first device %s, first time %s", req.prefixPaths.get(0), req.getTimestamps().get(0)), statement, true);
            }
            if ((status = AuthorityChecker.checkAuthority((Statement)statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            quota = DataNodeThrottleQuotaManager.getInstance().checkQuota(SESSION_MANAGER.getCurrSession().getUsername(), statement);
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_STRING_RECORDS, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.INSERT_STRING_RECORDS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addStatementExecutionLatency(OperationType.INSERT_STRING_RECORDS, StatementType.BATCH_INSERT_ROWS, System.nanoTime() - t1);
            SESSION_MANAGER.updateIdleTime();
            if (quota != null) {
                quota.close();
            }
        }
    }

    public TSStatus testInsertTablet(TSInsertTabletReq req) {
        LOGGER.debug("Test insert batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertTablets(TSInsertTabletsReq req) {
        LOGGER.debug("Test insert batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecord(TSInsertRecordReq req) {
        LOGGER.debug("Test insert row request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertStringRecord(TSInsertStringRecordReq req) {
        LOGGER.debug("Test insert string record request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecords(TSInsertRecordsReq req) {
        LOGGER.debug("Test insert row in batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req) {
        LOGGER.debug("Test insert rows in batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertStringRecords(TSInsertStringRecordsReq req) {
        LOGGER.debug("Test insert string records request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus deleteData(TSDeleteDataReq req) {
        TSStatus tSStatus;
        try {
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            DeleteDataStatement statement = StatementGenerator.createStatement(req);
            TSStatus status = AuthorityChecker.checkAuthority((Statement)statement, clientSession);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.DELETE_DATA, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.DELETE_DATA, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    public TSExecuteStatementResp executeRawDataQuery(TSRawDataQueryReq req) {
        return this.executeRawDataQueryInternal(req, OLD_SELECT_RESULT);
    }

    public TSExecuteStatementResp executeLastDataQuery(TSLastDataQueryReq req) {
        return this.executeLastDataQueryInternal(req, OLD_SELECT_RESULT);
    }

    public TSExecuteStatementResp executeAggregationQuery(TSAggregationQueryReq req) {
        return this.executeAggregationQueryInternal(req, OLD_SELECT_RESULT);
    }

    public long requestStatementId(long sessionId) {
        return SESSION_MANAGER.requestStatementId(SESSION_MANAGER.getCurrSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus createSchemaTemplate(TSCreateSchemaTemplateReq req) {
        TSStatus tSStatus;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setName(this.checkIdentifierAndRemoveBackQuotesIfNecessary(req.getName()));
            CreateSchemaTemplateStatement statement = StatementGenerator.createStatement(req);
            if (ENABLE_AUDIT_LOG) {
                AuditLogger.log(String.format("create device template %s", req.getName()), statement);
            }
            if ((status = AuthorityChecker.checkAuthority((Statement)statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_SCHEMA_TEMPLATE, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.CREATE_SCHEMA_TEMPLATE, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    public TSStatus appendSchemaTemplate(TSAppendSchemaTemplateReq req) {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNSUPPORTED_OPERATION, (String)"Modify template has not been supported.");
    }

    public TSStatus pruneSchemaTemplate(TSPruneSchemaTemplateReq req) {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNSUPPORTED_OPERATION, (String)"Modify template has not been supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSQueryTemplateResp querySchemaTemplate(TSQueryTemplateReq req) {
        TSQueryTemplateResp resp = new TSQueryTemplateResp();
        try {
            Statement statement;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                resp.setStatus(this.getNotLoggedInStatus());
                TSQueryTemplateResp tSQueryTemplateResp = resp;
                return tSQueryTemplateResp;
            }
            if (!req.getName().equals("") && !req.getName().equals("*")) {
                req.setName(this.checkIdentifierAndRemoveBackQuotesIfNecessary(req.getName()));
            }
            if ((statement = StatementGenerator.createStatement(req)) == null) {
                resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNSUPPORTED_OPERATION, (String)(TemplateQueryType.values()[req.getQueryType()].name() + "has not been supported.")));
                TSQueryTemplateResp tSQueryTemplateResp = resp;
                return tSQueryTemplateResp;
            }
            switch (TemplateQueryType.values()[req.getQueryType()]) {
                case SHOW_MEASUREMENTS: {
                    resp.setQueryType(TemplateQueryType.SHOW_MEASUREMENTS.ordinal());
                    break;
                }
                case SHOW_TEMPLATES: {
                    resp.setQueryType(TemplateQueryType.SHOW_TEMPLATES.ordinal());
                    break;
                }
                case SHOW_SET_TEMPLATES: {
                    resp.setQueryType(TemplateQueryType.SHOW_SET_TEMPLATES.ordinal());
                    break;
                }
                case SHOW_USING_TEMPLATES: {
                    resp.setQueryType(TemplateQueryType.SHOW_USING_TEMPLATES.ordinal());
                    break;
                }
            }
            TSQueryTemplateResp tSQueryTemplateResp = this.executeTemplateQueryStatement(statement, req, resp);
            return tSQueryTemplateResp;
        }
        catch (Exception e) {
            resp.setStatus(ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.EXECUTE_QUERY_STATEMENT, TSStatusCode.EXECUTE_STATEMENT_ERROR));
            TSQueryTemplateResp tSQueryTemplateResp = resp;
            return tSQueryTemplateResp;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TSQueryTemplateResp executeTemplateQueryStatement(Statement statement, TSQueryTemplateReq req, TSQueryTemplateResp resp) {
        long startTime = System.nanoTime();
        OperationQuota quota = null;
        try {
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            TSStatus status = AuthorityChecker.checkAuthority(statement, clientSession);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                TSQueryTemplateResp tSQueryTemplateResp = resp;
                return tSQueryTemplateResp;
            }
            quota = DataNodeThrottleQuotaManager.getInstance().checkQuota(SESSION_MANAGER.getCurrSession().getUsername(), statement);
            if (ENABLE_AUDIT_LOG) {
                AuditLogger.log(String.format("execute Query: %s", statement), statement);
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult executionResult = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), null, this.partitionFetcher, this.schemaFetcher, config.getQueryTimeoutThreshold());
            if (executionResult.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode() && executionResult.status.code != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                resp.setStatus(executionResult.status);
                TSQueryTemplateResp tSQueryTemplateResp = resp;
                return tSQueryTemplateResp;
            }
            IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
            SetThreadName threadName = new SetThreadName(executionResult.queryId.getId());
            try {
                ArrayList<String> result = new ArrayList<String>();
                while (queryExecution.hasNextResult()) {
                    Optional<TsBlock> tsBlock;
                    try {
                        tsBlock = queryExecution.getBatchResult();
                    }
                    catch (IoTDBException e) {
                        throw new RuntimeException("Fetch Schema failed. ", e);
                    }
                    if (!tsBlock.isPresent() || tsBlock.get().isEmpty()) break;
                    Column column = tsBlock.get().getColumn(0);
                    for (int i = 0; i < column.getPositionCount(); ++i) {
                        result.add(column.getBinary(i).getStringValue(TSFileConfig.STRING_CHARSET));
                    }
                }
                resp.setMeasurements(result);
                resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully"));
                TSQueryTemplateResp tSQueryTemplateResp = resp;
                threadName.close();
                return tSQueryTemplateResp;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    resp.setStatus(ErrorHandlingUtils.onQueryException(e, "\"" + statement + "\". " + (Object)((Object)OperationType.EXECUTE_STATEMENT)));
                    TSQueryTemplateResp tSQueryTemplateResp = null;
                    return tSQueryTemplateResp;
                }
            }
        }
        finally {
            this.addStatementExecutionLatency(OperationType.EXECUTE_STATEMENT, statement.getType(), System.nanoTime() - startTime);
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setSchemaTemplate(TSSetSchemaTemplateReq req) throws TException {
        TSStatus tSStatus;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setTemplateName(this.checkIdentifierAndRemoveBackQuotesIfNecessary(req.getTemplateName()));
            SetSchemaTemplateStatement statement = StatementGenerator.createStatement(req);
            if (ENABLE_AUDIT_LOG) {
                AuditLogger.log(String.format("set device template %s.%s", req.getTemplateName(), req.getPrefixPath()), statement);
            }
            if ((status = AuthorityChecker.checkAuthority((Statement)statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IllegalPathException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.EXECUTE_STATEMENT, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.EXECUTE_STATEMENT, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus unsetSchemaTemplate(TSUnsetSchemaTemplateReq req) throws TException {
        TSStatus tSStatus;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setTemplateName(this.checkIdentifierAndRemoveBackQuotesIfNecessary(req.getTemplateName()));
            UnsetSchemaTemplateStatement statement = StatementGenerator.createStatement(req);
            if (ENABLE_AUDIT_LOG) {
                AuditLogger.log(String.format("unset device template %s from %s", req.getTemplateName(), req.getPrefixPath()), statement);
            }
            if ((status = AuthorityChecker.checkAuthority((Statement)statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IllegalPathException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.EXECUTE_STATEMENT, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.EXECUTE_STATEMENT, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus dropSchemaTemplate(TSDropSchemaTemplateReq req) throws TException {
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus = this.getNotLoggedInStatus();
                return tSStatus;
            }
            req.setTemplateName(this.checkIdentifierAndRemoveBackQuotesIfNecessary(req.getTemplateName()));
            DropSchemaTemplateStatement statement = StatementGenerator.createStatement(req);
            if (ENABLE_AUDIT_LOG) {
                AuditLogger.log(String.format("drop device template %s", req.getTemplateName()), statement);
            }
            if ((status = AuthorityChecker.checkAuthority((Statement)statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus = status;
                return tSStatus;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus = result.status;
            return tSStatus;
        }
        catch (Exception e) {
            TSStatus tSStatus = ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.EXECUTE_STATEMENT, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus createTimeseriesUsingSchemaTemplate(TCreateTimeseriesUsingSchemaTemplateReq req) throws TException {
        TSStatus tSStatus;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            BatchActivateTemplateStatement statement = StatementGenerator.createBatchActivateTemplateStatement(req.getDevicePathList());
            if (ENABLE_AUDIT_LOG) {
                AuditLogger.log(String.format("batch activate device template %s", req.getDevicePathList()), statement);
            }
            if ((status = AuthorityChecker.checkAuthority((Statement)statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.EXECUTE_STATEMENT, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.EXECUTE_STATEMENT, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.updateIdleTime();
        }
    }

    public TSStatus handshake(TSyncIdentityInfo info) throws TException {
        return PipeAgent.receiver().legacy().handshake(info, SESSION_MANAGER.getCurrSession().getClientAddress(), this.partitionFetcher, this.schemaFetcher);
    }

    public TSStatus sendPipeData(ByteBuffer buff) throws TException {
        return PipeAgent.receiver().legacy().transportPipeData(buff);
    }

    public TSStatus sendFile(TSyncTransportMetaInfo metaInfo, ByteBuffer buff) throws TException {
        return PipeAgent.receiver().legacy().transportFile(metaInfo, buff);
    }

    public TPipeTransferResp pipeTransfer(TPipeTransferReq req) {
        return PipeAgent.receiver().thrift().receive(req, this.partitionFetcher, this.schemaFetcher);
    }

    public TSBackupConfigurationResp getBackupConfiguration() {
        return new TSBackupConfigurationResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
    }

    public TSConnectionInfoResp fetchAllConnectionsInfo() throws TException {
        return SESSION_MANAGER.getAllConnectionInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertStringRecord(TSInsertStringRecordReq req) {
        TSStatus tSStatus;
        long t1 = System.nanoTime();
        OperationQuota quota = null;
        try {
            TSStatus status;
            IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
            if (!SESSION_MANAGER.checkLogin(clientSession)) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            req.setMeasurements(PathUtils.checkIsLegalSingleMeasurementsAndUpdate((List)req.getMeasurements()));
            InsertRowStatement statement = StatementGenerator.createStatement(req);
            if (ENABLE_AUDIT_LOG) {
                AuditLogger.log(String.format("insertStringRecord, device %s, time %s", req.getPrefixPath(), req.getTimestamp()), statement, true);
            }
            if ((status = AuthorityChecker.checkAuthority((Statement)statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            quota = DataNodeThrottleQuotaManager.getInstance().checkQuota(SESSION_MANAGER.getCurrSession().getUsername(), statement);
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(clientSession), "", this.partitionFetcher, this.schemaFetcher);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_STRING_RECORD, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNpeOrUnexpectedException(e, OperationType.INSERT_STRING_RECORD, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addStatementExecutionLatency(OperationType.INSERT_STRING_RECORD, StatementType.INSERT, System.nanoTime() - t1);
            SESSION_MANAGER.updateIdleTime();
            if (quota != null) {
                quota.close();
            }
        }
    }

    private TSExecuteStatementResp createResponse(DatasetHeader header, long queryId) {
        TSExecuteStatementResp resp = RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        resp.setColumnNameIndexMap(header.getColumnNameIndexMap());
        resp.setSgColumns(new ArrayList());
        resp.setColumns(header.getRespColumns());
        resp.setDataTypeList(header.getRespDataTypeList());
        resp.setAliasColumns(header.getRespAliasColumns());
        resp.setIgnoreTimeStamp(header.isIgnoreTimestamp());
        resp.setQueryId(queryId);
        return resp;
    }

    private TSStatus getNotLoggedInStatus() {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN, (String)"Log in failed. Either you are not authorized or the session has timed out.");
    }

    private void addQueryLatency(StatementType statementType, long costTimeInNanos) {
        if (statementType == null) {
            return;
        }
        MetricService.getInstance().timer(costTimeInNanos, TimeUnit.NANOSECONDS, Metric.PERFORMANCE_OVERVIEW.toString(), MetricLevel.CORE, new String[]{Tag.INTERFACE.toString(), OperationType.QUERY_LATENCY.toString(), Tag.TYPE.toString(), statementType.name()});
    }

    private void addStatementExecutionLatency(OperationType operation, StatementType statementType, long costTime) {
        if (statementType == null) {
            return;
        }
        MetricService.getInstance().timer(costTime, TimeUnit.NANOSECONDS, Metric.PERFORMANCE_OVERVIEW.toString(), MetricLevel.CORE, new String[]{Tag.INTERFACE.toString(), operation.toString(), Tag.TYPE.toString(), statementType.name()});
    }

    private String checkIdentifierAndRemoveBackQuotesIfNecessary(String identifier) {
        return identifier == null ? null : ASTVisitor.parseIdentifier(identifier);
    }

    @Override
    public void handleClientExit() {
        IClientSession session = SESSION_MANAGER.getCurrSession();
        if (session != null) {
            TSCloseSessionReq req = new TSCloseSessionReq();
            this.closeSession(req);
        }
        PipeAgent.receiver().thrift().handleClientExit();
        PipeAgent.receiver().legacy().handleClientExit();
    }

    @FunctionalInterface
    public static interface SelectResult {
        public boolean apply(TSExecuteStatementResp var1, IQueryExecution var2, int var3) throws IoTDBException, IOException;
    }
}

