/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.v2.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.protocol.rest.v2.model.ExpressionRequest;
import org.apache.iotdb.db.protocol.rest.v2.model.InsertRecordsRequest;
import org.apache.iotdb.db.protocol.rest.v2.model.InsertTabletRequest;
import org.apache.iotdb.db.protocol.rest.v2.model.SQL;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class RequestValidationHandler {
    private RequestValidationHandler() {
    }

    public static void validateSQL(SQL sql) {
        Objects.requireNonNull(sql.getSql(), "sql should not be null");
        if (sql.getRowLimit() != null) {
            Validate.isTrue((sql.getRowLimit() > 0 ? 1 : 0) != 0, (String)"row_limit should be positive", (Object[])new Object[0]);
        }
    }

    public static void validateInsertTabletRequest(InsertTabletRequest insertTabletRequest) {
        Objects.requireNonNull(insertTabletRequest.getTimestamps(), "timestamps should not be null");
        Objects.requireNonNull(insertTabletRequest.getIsAligned(), "is_aligned should not be null");
        Objects.requireNonNull(insertTabletRequest.getDevice(), "device should not be null");
        Objects.requireNonNull(insertTabletRequest.getDataTypes(), "data_types should not be null");
        Objects.requireNonNull(insertTabletRequest.getMeasurements(), "measurements should not be null");
        Objects.requireNonNull(insertTabletRequest.getValues(), "values should not be null");
        ArrayList<String> errorMessages = new ArrayList<String>();
        String device = insertTabletRequest.getDevice();
        for (int i = 0; i < insertTabletRequest.getMeasurements().size(); ++i) {
            String dataType = (String)insertTabletRequest.getDataTypes().get(i);
            String measurement = (String)insertTabletRequest.getMeasurements().get(i);
            if (!RequestValidationHandler.isDataType(dataType)) continue;
            errorMessages.add("The " + dataType + " data type of " + device + "." + measurement + " is illegal");
        }
        if (!errorMessages.isEmpty()) {
            throw new RuntimeException(String.join((CharSequence)",", errorMessages));
        }
    }

    public static void validateInsertRecordsRequest(InsertRecordsRequest insertRecordsRequest) {
        Objects.requireNonNull(insertRecordsRequest.getTimestamps(), "timestamps should not be null");
        Objects.requireNonNull(insertRecordsRequest.getIsAligned(), "is_aligned should not be null");
        Objects.requireNonNull(insertRecordsRequest.getDevices(), "devices should not be null");
        Objects.requireNonNull(insertRecordsRequest.getDataTypesList(), "data_types_list should not be null");
        Objects.requireNonNull(insertRecordsRequest.getValuesList(), "values_list should not be null");
        Objects.requireNonNull(insertRecordsRequest.getMeasurementsList(), "measurements_list should not be null");
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (int i = 0; i < insertRecordsRequest.getDataTypesList().size(); ++i) {
            String device = (String)insertRecordsRequest.getDevices().get(i);
            List measurements = (List)insertRecordsRequest.getMeasurementsList().get(i);
            for (int c = 0; c < ((List)insertRecordsRequest.getDataTypesList().get(i)).size(); ++c) {
                String dataType = (String)((List)insertRecordsRequest.getDataTypesList().get(i)).get(c);
                String measurement = (String)measurements.get(c);
                if (!RequestValidationHandler.isDataType(dataType)) continue;
                errorMessages.add("The " + dataType + " data type of " + device + "." + measurement + " is illegal");
            }
        }
        if (!errorMessages.isEmpty()) {
            throw new RuntimeException(String.join((CharSequence)",", errorMessages));
        }
    }

    private static boolean isDataType(String dataType) {
        try {
            TSDataType.valueOf((String)dataType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return true;
        }
        return false;
    }

    public static void validateExpressionRequest(ExpressionRequest expressionRequest) {
        Objects.requireNonNull(expressionRequest.getExpression(), "expression should not be null");
        Objects.requireNonNull(expressionRequest.getPrefixPath(), "prefix_path should not be null");
        Objects.requireNonNull(expressionRequest.getStartTime(), "start_time should not be null");
        Objects.requireNonNull(expressionRequest.getEndTime(), "end_time should not be null");
    }
}

