/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.subtask;

import javax.validation.constraints.NotNull;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.task.subtask.PipeSubtask;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeDataNodeSubtask
extends PipeSubtask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeDataNodeSubtask.class);

    protected PipeDataNodeSubtask(String taskID, long creationTime) {
        super(taskID, creationTime);
    }

    public synchronized void onFailure(@NotNull Throwable throwable) {
        if (this.isClosed.get()) {
            LOGGER.info("onFailure in pipe subtask, ignored because pipe is dropped.", throwable);
            this.releaseLastEvent(false);
            return;
        }
        if (this.lastEvent instanceof EnrichedEvent) {
            this.onEnrichedEventFailure(throwable);
        } else {
            this.onNonEnrichedEventFailure(throwable);
        }
    }

    private void onEnrichedEventFailure(@NotNull Throwable throwable) {
        if (this.retryCount.get() == 0) {
            LOGGER.warn("Failed to execute subtask {} (creation time: {}, simple class: {}), because of {}. Will retry for {} times.", new Object[]{this.taskID, this.creationTime, ((Object)((Object)this)).getClass().getSimpleName(), throwable.getMessage(), 5, throwable});
        }
        this.retryCount.incrementAndGet();
        if (this.retryCount.get() <= 5) {
            LOGGER.warn("Retry executing subtask {} (creation time: {}, simple class: {}), retry count [{}/{}]", new Object[]{this.taskID, this.creationTime, ((Object)((Object)this)).getClass().getSimpleName(), this.retryCount.get(), 5});
            try {
                Thread.sleep(1000L * (long)this.retryCount.get());
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted when retrying to execute subtask {} (creation time: {}, simple class: {})", new Object[]{this.taskID, this.creationTime, ((Object)((Object)this)).getClass().getSimpleName(), e});
                Thread.currentThread().interrupt();
            }
            this.submitSelf();
        } else {
            String errorMessage = String.format("Failed to execute subtask %s (creation time: %s, simple class: %s), retry count exceeds the max retry times %d, last exception: %s, root cause: %s", this.taskID, this.creationTime, ((Object)((Object)this)).getClass().getSimpleName(), this.retryCount.get(), throwable.getMessage(), ErrorHandlingUtils.getRootCause(throwable).getMessage());
            LOGGER.warn(errorMessage, throwable);
            ((EnrichedEvent)this.lastEvent).reportException((PipeRuntimeException)(throwable instanceof PipeRuntimeException ? (PipeRuntimeException)throwable : new PipeRuntimeCriticalException(errorMessage)));
            LOGGER.warn("The last event is an instance of EnrichedEvent, so the exception is reported. Stopping current pipe subtask {} (creation time: {}, simple class: {}) locally... Status shown when query the pipe will be 'STOPPED'. Please restart the task by executing 'START PIPE' manually if needed.", new Object[]{this.taskID, this.creationTime, ((Object)((Object)this)).getClass().getSimpleName(), throwable});
        }
    }

    private void onNonEnrichedEventFailure(@NotNull Throwable throwable) {
        if (this.retryCount.get() == 0) {
            LOGGER.warn("Failed to execute subtask {} (creation time: {}, simple class: {}), because of {}. Will retry forever.", new Object[]{this.taskID, this.creationTime, ((Object)((Object)this)).getClass().getSimpleName(), throwable.getMessage(), throwable});
        }
        this.retryCount.incrementAndGet();
        LOGGER.warn("Retry executing subtask {} (creation time: {}, simple class: {}), retry count {}", new Object[]{this.taskID, this.creationTime, ((Object)((Object)this)).getClass().getSimpleName(), this.retryCount.get()});
        try {
            Thread.sleep(Math.min(1000L * (long)this.retryCount.get(), 10000L));
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted when retrying to execute subtask {} (creation time: {}, simple class: {})", new Object[]{this.taskID, this.creationTime, ((Object)((Object)this)).getClass().getSimpleName()});
            Thread.currentThread().interrupt();
        }
        this.submitSelf();
    }

    protected synchronized void releaseLastEvent(boolean shouldReport) {
        if (this.lastEvent != null) {
            if (this.lastEvent instanceof EnrichedEvent) {
                ((EnrichedEvent)this.lastEvent).decreaseReferenceCount(((Object)((Object)this)).getClass().getName(), shouldReport);
            }
            this.lastEvent = null;
        }
    }
}

