/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.tsfile;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.agent.runtime.PipePeriodicalJobExecutor;
import org.apache.iotdb.db.pipe.resource.tsfile.PipeTsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTsFileResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTsFileResourceManager.class);
    private final Map<String, PipeTsFileResource> hardlinkOrCopiedFileToPipeTsFileResourceMap = new ConcurrentHashMap<String, PipeTsFileResource>();
    private final ReentrantLock lock = new ReentrantLock();

    public PipeTsFileResourceManager() {
        PipeAgent.runtime().registerPeriodicalJob("PipeTsFileResourceManager#ttlCheck()", this::tryTtlCheck, Math.max(20L, 1L));
    }

    private void tryTtlCheck() {
        block6: {
            try {
                long timeout = PipePeriodicalJobExecutor.getMinIntervalSeconds() >> 1;
                if (this.lock.tryLock(timeout, TimeUnit.SECONDS)) {
                    try {
                        this.ttlCheck();
                        break block6;
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                LOGGER.warn("failed to try lock when checking TTL because of timeout ({}s)", (Object)timeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("failed to try lock when checking TTL because of interruption", (Throwable)e);
            }
        }
    }

    private void ttlCheck() {
        Iterator<Map.Entry<String, PipeTsFileResource>> iterator = this.hardlinkOrCopiedFileToPipeTsFileResourceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, PipeTsFileResource> entry = iterator.next();
            try {
                if (entry.getValue().closeIfOutOfTimeToLive()) {
                    iterator.remove();
                    continue;
                }
                LOGGER.info("Pipe file (file name: {}) is still referenced {} times", (Object)entry.getKey(), (Object)entry.getValue().getReferenceCount());
            }
            catch (IOException e) {
                LOGGER.warn("failed to close PipeTsFileResource when checking TTL: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File increaseFileReference(File file, boolean isTsFile) throws IOException {
        this.lock.lock();
        try {
            if (this.increaseReferenceIfExists(file.getPath())) {
                File file2 = file;
                return file2;
            }
            File hardlinkOrCopiedFile = PipeTsFileResourceManager.getHardlinkOrCopiedFileInPipeDir(file);
            if (this.increaseReferenceIfExists(hardlinkOrCopiedFile.getPath())) {
                File file3 = this.hardlinkOrCopiedFileToPipeTsFileResourceMap.get(hardlinkOrCopiedFile.getPath()).getFile();
                return file3;
            }
            File resultFile = isTsFile ? PipeTsFileResourceManager.createHardLink(file, hardlinkOrCopiedFile) : PipeTsFileResourceManager.copyFile(file, hardlinkOrCopiedFile);
            this.hardlinkOrCopiedFileToPipeTsFileResourceMap.put(resultFile.getPath(), new PipeTsFileResource(resultFile, isTsFile));
            File file4 = resultFile;
            return file4;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean increaseReferenceIfExists(String path) {
        PipeTsFileResource resource = this.hardlinkOrCopiedFileToPipeTsFileResourceMap.get(path);
        if (resource != null) {
            resource.increaseAndGetReference();
            return true;
        }
        return false;
    }

    private static File getHardlinkOrCopiedFileInPipeDir(File file) throws IOException {
        try {
            return new File(PipeTsFileResourceManager.getPipeTsFileDirPath(file), PipeTsFileResourceManager.getRelativeFilePath(file));
        }
        catch (Exception e) {
            throw new IOException(String.format("failed to get hardlink or copied file in pipe dir for file %s, it is not a tsfile, mod file or resource file", file.getPath()), e);
        }
    }

    private static String getPipeTsFileDirPath(File file) throws IOException {
        while (!file.getName().equals("sequence") && !file.getName().equals("unsequence")) {
            file = file.getParentFile();
        }
        return file.getParentFile().getCanonicalPath() + File.separator + PipeConfig.getInstance().getPipeHardlinkBaseDirName() + File.separator + PipeConfig.getInstance().getPipeHardlinkTsFileDirName();
    }

    private static String getRelativeFilePath(File file) {
        StringBuilder builder = new StringBuilder(file.getName());
        while (!file.getName().equals("sequence") && !file.getName().equals("unsequence")) {
            file = file.getParentFile();
            builder = new StringBuilder(file.getName()).append("-").append((CharSequence)builder);
        }
        return builder.toString();
    }

    private static File createHardLink(File sourceFile, File hardlink) throws IOException {
        if (!hardlink.getParentFile().exists() && !hardlink.getParentFile().mkdirs()) {
            throw new IOException(String.format("failed to create hardlink %s for file %s: failed to create parent dir %s", hardlink.getPath(), sourceFile.getPath(), hardlink.getParentFile().getPath()));
        }
        Path sourcePath = FileSystems.getDefault().getPath(sourceFile.getAbsolutePath(), new String[0]);
        Path linkPath = FileSystems.getDefault().getPath(hardlink.getAbsolutePath(), new String[0]);
        Files.createLink(linkPath, sourcePath);
        return hardlink;
    }

    private static File copyFile(File sourceFile, File targetFile) throws IOException {
        if (!targetFile.getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
            throw new IOException(String.format("failed to copy file %s to %s: failed to create parent dir %s", sourceFile.getPath(), targetFile.getPath(), targetFile.getParentFile().getPath()));
        }
        Files.copy(sourceFile.toPath(), targetFile.toPath(), new CopyOption[0]);
        return targetFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseFileReference(File hardlinkOrCopiedFile) {
        this.lock.lock();
        try {
            String filePath = hardlinkOrCopiedFile.getPath();
            PipeTsFileResource resource = this.hardlinkOrCopiedFileToPipeTsFileResourceMap.get(filePath);
            if (resource != null) {
                resource.decreaseAndGetReference();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileReferenceCount(File hardlinkOrCopiedFile) {
        this.lock.lock();
        try {
            String filePath = hardlinkOrCopiedFile.getPath();
            PipeTsFileResource resource = this.hardlinkOrCopiedFileToPipeTsFileResourceMap.get(filePath);
            int n = resource != null ? resource.getReferenceCount() : 0;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cacheObjectsIfAbsent(File hardlinkOrCopiedTsFile) throws IOException {
        this.lock.lock();
        try {
            PipeTsFileResource resource = this.hardlinkOrCopiedFileToPipeTsFileResourceMap.get(hardlinkOrCopiedTsFile.getPath());
            boolean bl = resource != null && resource.cacheObjectsIfAbsent();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getDeviceMeasurementsMapFromCache(File hardlinkOrCopiedTsFile) throws IOException {
        this.lock.lock();
        try {
            PipeTsFileResource resource = this.hardlinkOrCopiedFileToPipeTsFileResourceMap.get(hardlinkOrCopiedTsFile.getPath());
            Map<String, List<String>> map = resource == null ? null : resource.tryGetDeviceMeasurementsMap();
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Boolean> getDeviceIsAlignedMapFromCache(File hardlinkOrCopiedTsFile) throws IOException {
        this.lock.lock();
        try {
            PipeTsFileResource resource = this.hardlinkOrCopiedFileToPipeTsFileResourceMap.get(hardlinkOrCopiedTsFile.getPath());
            Map<String, Boolean> map = resource == null ? null : resource.tryGetDeviceIsAlignedMap();
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TSDataType> getMeasurementDataTypeMapFromCache(File hardlinkOrCopiedTsFile) throws IOException {
        this.lock.lock();
        try {
            PipeTsFileResource resource = this.hardlinkOrCopiedFileToPipeTsFileResourceMap.get(hardlinkOrCopiedTsFile.getPath());
            Map<String, TSDataType> map = resource == null ? null : resource.tryGetMeasurementDataTypeMap();
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void pinTsFileResource(TsFileResource resource) throws IOException {
        this.lock.lock();
        try {
            this.increaseFileReference(resource.getTsFile(), true);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void unpinTsFileResource(TsFileResource resource) throws IOException {
        this.lock.lock();
        try {
            this.decreaseFileReference(PipeTsFileResourceManager.getHardlinkOrCopiedFileInPipeDir(resource.getTsFile()));
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getLinkedTsfileCount() {
        this.lock.lock();
        try {
            int n = this.hardlinkOrCopiedFileToPipeTsFileResourceMap.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

