/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.progress.committer.PipeEventCommitManager;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnrichedEvent
implements Event {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrichedEvent.class);
    protected final AtomicInteger referenceCount = new AtomicInteger(0);
    protected final String pipeName;
    protected final PipeTaskMeta pipeTaskMeta;
    protected String committerKey;
    public static final long NO_COMMIT_ID = -1L;
    protected long commitId = -1L;
    protected final String pattern;
    protected final long startTime;
    protected final long endTime;
    protected boolean isPatternParsed;
    protected boolean isTimeParsed;
    protected boolean shouldReportOnCommit = false;

    protected EnrichedEvent(String pipeName, PipeTaskMeta pipeTaskMeta, String pattern, long startTime, long endTime) {
        this.pipeName = pipeName;
        this.pipeTaskMeta = pipeTaskMeta;
        this.pattern = pattern;
        this.startTime = startTime;
        this.endTime = endTime;
        this.isPatternParsed = this.getPattern().equals("root");
        this.isTimeParsed = Long.MIN_VALUE == startTime && Long.MAX_VALUE == endTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean increaseReferenceCount(String holderMessage) {
        boolean isSuccessful = true;
        EnrichedEvent enrichedEvent = this;
        synchronized (enrichedEvent) {
            if (this.referenceCount.get() == 0) {
                isSuccessful = this.internallyIncreaseResourceReferenceCount(holderMessage);
            }
            this.referenceCount.incrementAndGet();
        }
        return isSuccessful;
    }

    public abstract boolean internallyIncreaseResourceReferenceCount(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decreaseReferenceCount(String holderMessage, boolean shouldReport) {
        boolean isSuccessful = true;
        EnrichedEvent enrichedEvent = this;
        synchronized (enrichedEvent) {
            int newReferenceCount;
            if (this.referenceCount.get() == 1) {
                isSuccessful = this.internallyDecreaseResourceReferenceCount(holderMessage);
                if (shouldReport) {
                    this.shouldReportOnCommit = true;
                }
                PipeEventCommitManager.getInstance().commit(this, this.committerKey);
            }
            if ((newReferenceCount = this.referenceCount.decrementAndGet()) < 0) {
                LOGGER.warn("reference count is decreased to {}.", (Object)newReferenceCount);
            }
        }
        return isSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearReferenceCount(String holderMessage) {
        boolean isSuccessful = true;
        EnrichedEvent enrichedEvent = this;
        synchronized (enrichedEvent) {
            if (this.referenceCount.get() >= 1) {
                isSuccessful = this.internallyDecreaseResourceReferenceCount(holderMessage);
            }
            this.referenceCount.set(0);
        }
        return isSuccessful;
    }

    public abstract boolean internallyDecreaseResourceReferenceCount(String var1);

    protected void reportProgress() {
        if (this.pipeTaskMeta != null) {
            ProgressIndex progressIndex = this.getProgressIndex();
            this.pipeTaskMeta.updateProgressIndex((ProgressIndex)(progressIndex == null ? MinimumProgressIndex.INSTANCE : progressIndex));
        }
    }

    public abstract ProgressIndex getProgressIndex();

    public int getReferenceCount() {
        return this.referenceCount.get();
    }

    public final String getPipeName() {
        return this.pipeName;
    }

    public final String getPattern() {
        return this.pattern == null ? "root" : this.pattern;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final long getEndTime() {
        return this.endTime;
    }

    public void skipParsingPattern() {
        this.isPatternParsed = true;
    }

    public void skipParsingTime() {
        this.isTimeParsed = true;
    }

    public boolean shouldParsePatternOrTime() {
        return !this.isPatternParsed || !this.isTimeParsed;
    }

    public boolean shouldParseTime() {
        return !this.isTimeParsed;
    }

    public abstract EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String var1, PipeTaskMeta var2, String var3, long var4, long var6);

    public void reportException(PipeRuntimeException pipeRuntimeException) {
        if (this.pipeTaskMeta != null) {
            PipeAgent.runtime().report(this.pipeTaskMeta, pipeRuntimeException);
        } else {
            LOGGER.warn("Attempt to report pipe exception to a null PipeTaskMeta.", (Throwable)pipeRuntimeException);
        }
    }

    public abstract boolean isGeneratedByPipe();

    public boolean needToCommit() {
        return true;
    }

    public abstract boolean mayEventTimeOverlappedWithTimeRange();

    public void setCommitterKeyAndCommitId(String committerKey, long commitId) {
        this.committerKey = committerKey;
        this.commitId = commitId;
    }

    public String getCommitterKey() {
        return this.committerKey;
    }

    public long getCommitId() {
        return this.commitId;
    }

    public void onCommitted() {
        if (this.shouldReportOnCommit) {
            this.reportProgress();
        }
    }

    public String toString() {
        return "EnrichedEvent{referenceCount=" + this.referenceCount.get() + ", pipeName='" + this.pipeName + '\'' + ", pipeTaskMeta=" + this.pipeTaskMeta + ", committerKey='" + this.committerKey + '\'' + ", commitId=" + this.commitId + ", pattern='" + this.pattern + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", isPatternParsed=" + this.isPatternParsed + ", isTimeParsed=" + this.isTimeParsed + ", shouldReportOnCommit=" + this.shouldReportOnCommit + '}';
    }
}

