/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.connector.payload.request.IoTDBConnectorRequestVersion;
import org.apache.iotdb.commons.pipe.connector.payload.request.PipeRequestType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntry;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferTabletBinaryReq
extends TPipeTransferReq {
    private ByteBuffer byteBuffer;

    private PipeTransferTabletBinaryReq() {
    }

    public InsertBaseStatement constructStatement() {
        InsertNode insertNode = this.parse(this.byteBuffer);
        if (insertNode instanceof InsertRowNode) {
            InsertRowNode node = (InsertRowNode)insertNode;
            InsertRowStatement statement = new InsertRowStatement();
            statement.setDevicePath(node.getDevicePath());
            statement.setTime(node.getTime());
            statement.setMeasurements(node.getMeasurements());
            statement.setDataTypes(node.getDataTypes());
            statement.setValues(node.getValues());
            statement.setNeedInferType(node.isNeedInferType());
            statement.setAligned(node.isAligned());
            statement.setMeasurementSchemas(node.getMeasurementSchemas());
            return statement;
        }
        if (insertNode instanceof InsertTabletNode) {
            InsertTabletNode node = (InsertTabletNode)insertNode;
            InsertTabletStatement statement = new InsertTabletStatement();
            statement.setDevicePath(node.getDevicePath());
            statement.setMeasurements(node.getMeasurements());
            statement.setTimes(node.getTimes());
            statement.setColumns(node.getColumns());
            statement.setBitMaps(node.getBitMaps());
            statement.setRowCount(node.getRowCount());
            statement.setDataTypes(node.getDataTypes());
            statement.setAligned(node.isAligned());
            statement.setMeasurementSchemas(node.getMeasurementSchemas());
            return statement;
        }
        throw new UnsupportedOperationException(String.format("unknown InsertNode type %s when constructing statement from insert node.", insertNode));
    }

    private InsertNode parse(ByteBuffer buffer) {
        PlanNode node = WALEntry.deserializeForConsensus(buffer);
        if (node instanceof InsertNode) {
            return (InsertNode)node;
        }
        return null;
    }

    public static PipeTransferTabletBinaryReq toTPipeTransferReq(ByteBuffer byteBuffer) {
        PipeTransferTabletBinaryReq req = new PipeTransferTabletBinaryReq();
        req.byteBuffer = byteBuffer;
        req.version = IoTDBConnectorRequestVersion.VERSION_1.getVersion();
        req.type = PipeRequestType.TRANSFER_TABLET_BINARY.getType();
        req.body = byteBuffer;
        return req;
    }

    public static PipeTransferTabletBinaryReq fromTPipeTransferReq(TPipeTransferReq transferReq) {
        PipeTransferTabletBinaryReq binaryReq = new PipeTransferTabletBinaryReq();
        binaryReq.byteBuffer = transferReq.body;
        binaryReq.version = transferReq.version;
        binaryReq.type = transferReq.type;
        binaryReq.body = transferReq.body;
        return binaryReq;
    }

    public static byte[] toTransferInsertNodeBytes(ByteBuffer byteBuffer) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            byte[] byArray;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                ReadWriteIOUtils.write((byte)IoTDBConnectorRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((short)PipeRequestType.TRANSFER_TABLET_BINARY.getType(), (OutputStream)outputStream);
                byArray = BytesUtils.concatByteArray((byte[])byteArrayOutputStream.toByteArray(), (byte[])byteBuffer.array());
            }
            return byArray;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferTabletBinaryReq that = (PipeTransferTabletBinaryReq)((Object)obj);
        return this.byteBuffer.equals(that.byteBuffer) && this.version == that.version && this.type == that.type && this.body.equals(that.body);
    }

    public int hashCode() {
        return Objects.hash(this.byteBuffer, this.version, this.type, this.body);
    }
}

