/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.jdbc.Field;
import org.apache.iotdb.jdbc.IoTDBAbstractDatabaseMetadata;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.iotdb.jdbc.IoTDBJDBCResultSet;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataResp;
import org.apache.thrift.TException;
import org.apache.tsfile.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDatabaseMetadata
extends IoTDBAbstractDatabaseMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDatabaseMetadata.class);
    private static final String DATABASE_VERSION = IoTDBDatabaseMetadata.class.getPackage().getImplementationVersion() != null ? IoTDBDatabaseMetadata.class.getPackage().getImplementationVersion() : "UNKNOWN";
    private static final String[] allIotdbSQLKeywords = new String[]{"ALTER", "ADD", "ALIAS", "ALL", "AVG", "ALIGN", "ATTRIBUTES", "AS", "ASC", "BY", "BOOLEAN", "BITMAP", "CREATE", "CONFIGURATION", "COMPRESSOR", "CHILD", "COUNT", "COMPRESSION", "CLEAR", "CACHE", "CONTAIN", "CONCAT", "DELETE", "DEVICE", "DESCRIBE", "DATATYPE", "DOUBLE", "DIFF", "DROP", "DEVICES", "DISABLE", "DESC", "ENCODING", "FROM", "FILL", "FLOAT", "FLUSH", "FIRST_VALUE", "FULL", "FALSE", "FOR", "FUNCTION", "FUNCTIONS", "GRANT", "GROUP", "GORILLA", "GLOBAL", "GZIP", "INSERT", "INTO", "INT32", "INT64", "INDEX", "INFO", "KILL", "LIMIT", "LINEAR", "LABEL", "LINK", "LIST", "LOAD", "LEVEL", "LAST_VALUE", "LAST", "LZO", "LZ4", "ZSTD", "LZMA2", "LATEST", "LIKE", "MAX_BY", "MIN_BY", "METADATA", "MOVE", "MIN_TIME", "MAX_TIME", "MIN_VALUE", "MAX_VALUE", "NOW", "NODES", "ORDER", "OFFSET", "ON", "OFF", "OF", "PROCESSLIST", "PREVIOUS", "PREVIOUSUNTILLAST", "PROPERTY", "PLAIN", "PLAIN_DICTIONARY", "PRIVILEGES", "PASSWORD", "PATHS", "PAA", "PLA", "PARTITION", "QUERY", "ROOT", "RLE", "REGULAR", "ROLE", "REVOKE", "REMOVE", "RENAME", "SELECT", "SHOW", "SET", "SLIMIT", "SOFFSET", "STDDEV", "STDDEV_POP", "STDDEV_SAMP", "STORAGE", "SUM", "SNAPPY", "SNAPSHOT", "SCHEMA", "TO", "TIMESERIES", "TIMESTAMP", "TEXT", "TS_2DIFF", "TRACING", "TTL", "TASK", "TIME", "TAGS", "TRUE", "TEMPORARY", "TOP", "TOLERANCE", "UPDATE", "UNLINK", "UPSERT", "USING", "USER", "UNSET", "UNCOMPRESSED", "VALUES", "VARIANCE", "VAR_POP", "VAR_SAMP", "VERSION", "WHERE", "WITH", "WATERMARK_EMBEDDING"};
    private static final String[] allIoTDBMathFunctions = new String[]{"ABS", "ACOS", "ASIN", "ATAN", "CEIL", "COS", "COSH", "DEGREES", "EXP", "FLOOR", "LN", "LOG10", "PI", "RADIANS", "ROUND", "SIGN", "SIN", "SINH", "SQRT", "TAN", "TANH"};

    public IoTDBDatabaseMetadata(IoTDBConnection connection, IClientRPCService.Iface client, long sessionId, ZoneId zoneId) {
        super(connection, client, sessionId, zoneId);
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return DATABASE_VERSION;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return String.join((CharSequence)",", allIoTDBMathFunctions);
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "COUNT_TIME,MAX_TIME,MIN_TIME,TIME_DIFFERENCE,TIME_DURATION";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        ResultSet rs;
        Statement stmt = this.connection.createStatement();
        String sql = "SHOW DEVICES";
        String database = "";
        if (catalog != null && !catalog.isEmpty()) {
            if (catalog.contains("%")) {
                catalog = catalog.replace("%", "*");
            }
            database = catalog;
            sql = sql + " " + catalog;
        } else if (schemaPattern != null && !schemaPattern.isEmpty()) {
            if (schemaPattern.contains("%")) {
                schemaPattern = schemaPattern.replace("%", "*");
            }
            database = schemaPattern;
            sql = sql + " " + schemaPattern;
        }
        if ((catalog != null && !catalog.isEmpty() || schemaPattern != null && !schemaPattern.isEmpty()) && tableNamePattern != null && !tableNamePattern.isEmpty()) {
            if (tableNamePattern.contains("%")) {
                tableNamePattern = tableNamePattern.replace("%", "**");
            }
            sql = sql + "." + tableNamePattern;
        }
        LOGGER.info("Get tables: sql: {}", (Object)sql);
        try {
            rs = stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            stmt.close();
            throw e;
        }
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", "TEXT"), new Field("", "TABLE_SCHEM", "TEXT"), new Field("", "TABLE_NAME", "TEXT"), new Field("", "TABLE_TYPE", "TEXT"), new Field("", "REMARKS", "TEXT"), new Field("", "TYPE_CAT", "TEXT"), new Field("", "TYPE_SCHEM", "TEXT"), new Field("", "TYPE_NAME", "TEXT"), new Field("", "SELF_REFERENCING_COL_NAME", "TEXT"), new Field("", "REF_GENERATION", "TEXT")};
        List<TSDataType> tsDataTypeList = Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT);
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        ArrayList<List<Object>> valuesList = new ArrayList<List<Object>>();
        for (int i = 0; i < fields.length; ++i) {
            columnNameList.add(fields[i].getName());
            columnTypeList.add(fields[i].getSqlType());
            columnNameIndex.put(fields[i].getName(), i);
        }
        boolean hasResultSet = false;
        while (rs.next()) {
            hasResultSet = true;
            ArrayList<String> valueInRow = new ArrayList<String>();
            String res = rs.getString(1);
            for (int i = 0; i < fields.length; ++i) {
                if (i < 2) {
                    valueInRow.add("");
                    continue;
                }
                if (i == 2) {
                    int beginIndex = database.length() + 1;
                    if (StringUtils.isEmpty((CharSequence)database)) {
                        beginIndex = 0;
                    }
                    valueInRow.add(res.substring(beginIndex));
                    continue;
                }
                if (i == 3) {
                    valueInRow.add("TABLE");
                    continue;
                }
                valueInRow.add("");
            }
            valuesList.add(valueInRow);
        }
        ByteBuffer tsBlock = null;
        try {
            tsBlock = IoTDBDatabaseMetadata.convertTsBlock(valuesList, tsDataTypeList);
        }
        catch (IOException e) {
            LOGGER.error("Convert tsBlock error: {}", (Object)e.getMessage());
        }
        finally {
            this.close(rs, stmt);
        }
        return hasResultSet ? new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, true, this.client, null, -1L, this.sessionId, Collections.singletonList(tsBlock), null, 60000L, false, this.zoneId) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ResultSet rs;
        Statement stmt = this.connection.createStatement();
        if (this.connection.getCatalog().equals(catalog)) {
            catalog = null;
        }
        String sql = "SHOW TIMESERIES";
        if (StringUtils.isNotEmpty((CharSequence)catalog)) {
            if (catalog.contains("%")) {
                catalog = catalog.replace("%", "*");
            }
            sql = sql + " " + catalog;
        } else if (StringUtils.isNotEmpty((CharSequence)schemaPattern)) {
            if (schemaPattern.contains("%")) {
                schemaPattern = schemaPattern.replace("%", "*");
            }
            sql = sql + " " + schemaPattern;
        }
        if ((StringUtils.isNotEmpty((CharSequence)catalog) || StringUtils.isNotEmpty((CharSequence)schemaPattern)) && StringUtils.isNotEmpty((CharSequence)tableNamePattern)) {
            if (tableNamePattern.contains("%")) {
                tableNamePattern = tableNamePattern.replace("%", "*");
            }
            sql = sql + "." + tableNamePattern;
        }
        if ((StringUtils.isNotEmpty((CharSequence)catalog) || StringUtils.isNotEmpty((CharSequence)schemaPattern)) && StringUtils.isNotEmpty((CharSequence)tableNamePattern) && StringUtils.isNotEmpty((CharSequence)columnNamePattern)) {
            if (columnNamePattern.contains("%")) {
                columnNamePattern = columnNamePattern.replace("%", "*");
            }
            sql = sql + "." + columnNamePattern;
        }
        if (StringUtils.isEmpty((CharSequence)catalog) && StringUtils.isEmpty((CharSequence)schemaPattern) && StringUtils.isNotEmpty((CharSequence)tableNamePattern)) {
            sql = sql + " " + tableNamePattern + ".*";
        }
        try {
            rs = stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            stmt.close();
            throw e;
        }
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", "TEXT"), new Field("", "TABLE_SCHEM", "TEXT"), new Field("", "TABLE_NAME", "TEXT"), new Field("", "COLUMN_NAME", "TEXT"), new Field("", "DATA_TYPE", "INT32"), new Field("", "TYPE_NAME", "TEXT"), new Field("", "COLUMN_SIZE", "INT32"), new Field("", "BUFFER_LENGTH", "INT32"), new Field("", "DECIMAL_DIGITS", "INT32"), new Field("", "NUM_PREC_RADIX", "INT32"), new Field("", "NULLABLE", "INT32"), new Field("", "REMARKS", "TEXT"), new Field("", "COLUMN_DEF", "TEXT"), new Field("", "SQL_DATA_TYPE", "INT32"), new Field("", "SQL_DATETIME_SUB", "INT32"), new Field("", "CHAR_OCTET_LENGTH", "INT32"), new Field("", "ORDINAL_POSITION", "INT32"), new Field("", "IS_NULLABLE", "TEXT"), new Field("", "SCOPE_CATALOG", "TEXT"), new Field("", "SCOPE_SCHEMA", "TEXT"), new Field("", "SCOPE_TABLE", "TEXT"), new Field("", "SOURCE_DATA_TYPE", "INT32"), new Field("", "IS_AUTOINCREMENT", "TEXT"), new Field("", "IS_GENERATEDCOLUMN", "TEXT")};
        List<TSDataType> tsDataTypeList = Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.INT32, TSDataType.TEXT, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.TEXT, TSDataType.TEXT, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.INT32, TSDataType.TEXT, TSDataType.TEXT);
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        ArrayList<List<Object>> valuesList = new ArrayList<List<Object>>();
        for (int i = 0; i < fields.length; ++i) {
            columnNameList.add(fields[i].getName());
            columnTypeList.add(fields[i].getSqlType());
            columnNameIndex.put(fields[i].getName(), i);
        }
        while (rs.next()) {
            ArrayList<Object> valuesInRow = new ArrayList<Object>();
            String res = rs.getString(1);
            String[] splitRes = res.split("\\.");
            for (int i = 0; i < fields.length; ++i) {
                if (i <= 1) {
                    valuesInRow.add(" ");
                    continue;
                }
                if (i == 2) {
                    valuesInRow.add(res.substring(0, res.length() - splitRes[splitRes.length - 1].length() - 1));
                    continue;
                }
                if (i == 3) {
                    valuesInRow.add(splitRes[splitRes.length - 1]);
                    continue;
                }
                if (i == 4) {
                    valuesInRow.add(this.getSQLType(rs.getString(4)));
                    continue;
                }
                if (i == 5) {
                    valuesInRow.add(rs.getString(4));
                    continue;
                }
                if (i == 6) {
                    valuesInRow.add(this.getTypePrecision(fields[i].getSqlType()));
                    continue;
                }
                if (i == 7) {
                    valuesInRow.add(0);
                    continue;
                }
                if (i == 8) {
                    valuesInRow.add(this.getTypeScale(fields[i].getSqlType()));
                    continue;
                }
                if (i == 9) {
                    valuesInRow.add(10);
                    continue;
                }
                if (i == 10) {
                    valuesInRow.add(0);
                    continue;
                }
                if (i == 11) {
                    valuesInRow.add("");
                    continue;
                }
                if (i == 12) {
                    valuesInRow.add("");
                    continue;
                }
                if (i == 13) {
                    valuesInRow.add(0);
                    continue;
                }
                if (i == 14) {
                    valuesInRow.add(0);
                    continue;
                }
                if (i == 15) {
                    valuesInRow.add(this.getTypePrecision(fields[i].getSqlType()));
                    continue;
                }
                if (i == 16) {
                    valuesInRow.add(1);
                    continue;
                }
                if (i == 17) {
                    valuesInRow.add("NO");
                    continue;
                }
                if (i == 18) {
                    valuesInRow.add("");
                    continue;
                }
                if (i == 19) {
                    valuesInRow.add("");
                    continue;
                }
                if (i == 20) {
                    valuesInRow.add("");
                    continue;
                }
                if (i == 21) {
                    valuesInRow.add(0);
                    continue;
                }
                if (i == 22) {
                    valuesInRow.add("NO");
                    continue;
                }
                if (i == 23) {
                    valuesInRow.add("NO");
                    continue;
                }
                valuesInRow.add("");
            }
            valuesList.add(valuesInRow);
        }
        ByteBuffer tsBlock = null;
        try {
            tsBlock = IoTDBDatabaseMetadata.convertTsBlock(valuesList, tsDataTypeList);
        }
        catch (IOException e) {
            LOGGER.error("Convert tsBlock error: {}", (Object)e.getMessage());
        }
        finally {
            this.close(rs, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, true, this.client, null, -1L, this.sessionId, Collections.singletonList(tsBlock), null, 60000L, false, this.zoneId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        Statement stmt = this.connection.createStatement();
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        List<TSDataType> tsDataTypeList = Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.INT32, TSDataType.TEXT);
        String database = "";
        if (catalog != null) {
            database = catalog;
        } else if (schema != null) {
            database = schema;
        }
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", "TEXT"), new Field("", "TABLE_SCHEM", "TEXT"), new Field("", "TABLE_NAME", "TEXT"), new Field("", "COLUMN_NAME", "TEXT"), new Field("", "KEY_SEQ", "INT32"), new Field("", "PK_NAME", "TEXT")};
        List<Object> listValSub1 = Arrays.asList(database, "", table, "time", 1, "PRIMARY");
        List<Object> listValSub2 = Arrays.asList(database, "", table, "deivce", 2, "PRIMARY");
        List<List<Object>> valuesList = Arrays.asList(listValSub1, listValSub2);
        for (int i = 0; i < fields.length; ++i) {
            columnNameList.add(fields[i].getName());
            columnTypeList.add(fields[i].getSqlType());
            columnNameIndex.put(fields[i].getName(), i);
        }
        ByteBuffer tsBlock = null;
        try {
            tsBlock = IoTDBDatabaseMetadata.convertTsBlock(valuesList, tsDataTypeList);
        }
        catch (IOException e) {
            LOGGER.error("Get primary keys error: {}", (Object)e.getMessage());
        }
        finally {
            this.close(null, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, true, this.client, null, -1L, this.sessionId, Collections.singletonList(tsBlock), null, 60000L, false, this.zoneId);
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "";
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "storage group";
    }

    @Deprecated
    public String toString() {
        block7: {
            try {
                return this.getMetadataInJsonFunc();
            }
            catch (IoTDBSQLException e) {
                LOGGER.error("Failed to fetch metadata in json because: ", (Throwable)e);
            }
            catch (TException e) {
                boolean flag = this.connection.reconnect();
                this.client = this.connection.getClient();
                if (flag) {
                    try {
                        return this.getMetadataInJsonFunc();
                    }
                    catch (TException e2) {
                        LOGGER.error("Fail to get all timeseries info after reconnecting. please check server status", (Throwable)e2);
                        break block7;
                    }
                    catch (IoTDBSQLException ioTDBSQLException) {
                        break block7;
                    }
                }
                LOGGER.error("Fail to reconnect to server when getting all timeseries info. please check server status");
            }
        }
        return "";
    }

    public String getMetadataInJson() throws SQLException {
        try {
            return this.getMetadataInJsonFunc();
        }
        catch (TException e) {
            boolean flag = this.connection.reconnect();
            this.client = this.connection.getClient();
            if (flag) {
                try {
                    return this.getMetadataInJsonFunc();
                }
                catch (TException e2) {
                    throw new SQLException("Failed to fetch all metadata in json after reconnecting. Please check the server status.");
                }
            }
            throw new SQLException("Failed to reconnect to the server when fetching all metadata in json. Please check the server status.");
        }
    }

    private String getMetadataInJsonFunc() throws TException, IoTDBSQLException {
        TSFetchMetadataReq req = new TSFetchMetadataReq(this.sessionId, "METADATA_IN_JSON");
        TSFetchMetadataResp resp = this.client.fetchMetadata(req);
        try {
            RpcUtils.verifySuccess((TSStatus)resp.getStatus());
        }
        catch (StatementExecutionException e) {
            throw new IoTDBSQLException(e.getMessage(), resp.getStatus());
        }
        return resp.getMetadataInJson();
    }

    static {
        try {
            TreeMap myKeywordMap = new TreeMap();
            for (String allIotdbSQLKeyword : allIotdbSQLKeywords) {
                myKeywordMap.put(allIotdbSQLKeyword, null);
            }
            HashMap sql92KeywordMap = new HashMap(sql92Keywords.length);
            for (String sql92Keyword : sql92Keywords) {
                sql92KeywordMap.put(sql92Keyword, null);
            }
            Iterator it = sql92KeywordMap.keySet().iterator();
            while (it.hasNext()) {
                myKeywordMap.remove(it.next());
            }
            StringBuilder keywordBuf = new StringBuilder();
            it = myKeywordMap.keySet().iterator();
            if (it.hasNext()) {
                keywordBuf.append((String)it.next());
            }
            while (it.hasNext()) {
                keywordBuf.append(",");
                keywordBuf.append((String)it.next());
            }
            sqlKeywordsThatArentSQL92 = keywordBuf.toString();
        }
        catch (Exception e) {
            LOGGER.error("Error when initializing SQL keywords: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

