/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache.region;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionCache;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionGroupStatistics;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionStatistics;
import org.apache.iotdb.confignode.manager.partition.RegionGroupStatus;

public class RegionGroupCache {
    private final String database;
    private final Map<Integer, RegionCache> regionCacheMap;
    private final AtomicReference<RegionGroupStatistics> currentStatistics;
    private final boolean isStrongConsistency;

    public RegionGroupCache(String database, Set<Integer> dataNodeIds, boolean isStrongConsistency) {
        this.database = database;
        this.regionCacheMap = new ConcurrentHashMap<Integer, RegionCache>();
        dataNodeIds.forEach(dataNodeId -> this.regionCacheMap.put((Integer)dataNodeId, new RegionCache()));
        this.currentStatistics = new AtomicReference<RegionGroupStatistics>(RegionGroupStatistics.generateDefaultRegionGroupStatistics());
        this.isStrongConsistency = isStrongConsistency;
    }

    public void cacheHeartbeatSample(int dataNodeId, RegionHeartbeatSample newHeartbeatSample, boolean overwrite) {
        Optional.ofNullable(this.regionCacheMap.get(dataNodeId)).ifPresent(region -> region.cacheHeartbeatSample(newHeartbeatSample, overwrite));
    }

    @TestOnly
    public void cacheHeartbeatSample(int dataNodeId, RegionHeartbeatSample newHeartbeatSample) {
        this.cacheHeartbeatSample(dataNodeId, newHeartbeatSample, false);
    }

    public void createRegionCache(int dataNodeId) {
        this.regionCacheMap.put(dataNodeId, new RegionCache());
    }

    public void removeRegionCache(int dataNodeId) {
        this.regionCacheMap.remove(dataNodeId);
    }

    public void updateCurrentStatistics() {
        this.regionCacheMap.values().forEach(regionCache -> regionCache.updateCurrentStatistics(false));
        Map regionStatisticsMap = this.regionCacheMap.entrySet().stream().collect(TreeMap::new, (map, entry) -> map.put((Integer)entry.getKey(), ((RegionCache)entry.getValue()).getCurrentStatistics()), TreeMap::putAll);
        this.currentStatistics.set(new RegionGroupStatistics(this.caculateRegionGroupStatus(regionStatisticsMap), regionStatisticsMap));
    }

    private RegionGroupStatus caculateRegionGroupStatus(Map<Integer, RegionStatistics> regionStatisticsMap) {
        int runningCount = 0;
        int addingCount = 0;
        int removingCount = 0;
        for (RegionStatistics regionStatistics : regionStatisticsMap.values()) {
            runningCount += RegionStatus.Running.equals((Object)regionStatistics.getRegionStatus()) ? 1 : 0;
            addingCount += RegionStatus.Adding.equals((Object)regionStatistics.getRegionStatus()) ? 1 : 0;
            removingCount += RegionStatus.Removing.equals((Object)regionStatistics.getRegionStatus()) ? 1 : 0;
        }
        int baseCount = this.regionCacheMap.size() - addingCount - removingCount;
        if (runningCount == baseCount) {
            return RegionGroupStatus.Running;
        }
        if (this.isStrongConsistency) {
            return runningCount > baseCount / 2 ? RegionGroupStatus.Available : RegionGroupStatus.Disabled;
        }
        return runningCount >= 1 ? RegionGroupStatus.Available : RegionGroupStatus.Disabled;
    }

    public RegionGroupStatistics getCurrentStatistics() {
        return this.currentStatistics.get();
    }

    public String getDatabase() {
        return this.database;
    }

    public Set<Integer> getRegionLocations() {
        return this.regionCacheMap.keySet();
    }

    public RegionCache getRegionCache(int nodeId) {
        return this.regionCacheMap.get(nodeId);
    }
}

