/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.it.env.cluster.config;

import javax.annotation.Nullable;
import org.apache.iotdb.itbase.env.JVMConfig;

public class MppJVMConfig
implements JVMConfig {
    private int initHeapSize;
    private int maxHeapSize;
    private int maxDirectMemorySize;
    private String timezone;

    @Override
    public JVMConfig setInitHeapSize(int initSize) {
        if (initSize > 0) {
            this.initHeapSize = initSize;
        }
        return this;
    }

    @Override
    public JVMConfig setMaxHeapSize(int maxSize) {
        if (maxSize > 0) {
            this.maxHeapSize = maxSize;
        }
        return this;
    }

    @Override
    public JVMConfig setMaxDirectMemorySize(int maxSize) {
        if (maxSize > 0) {
            this.maxDirectMemorySize = maxSize;
        }
        return this;
    }

    public JVMConfig setTimezone(String timezone) {
        if (timezone != null) {
            this.timezone = timezone;
        }
        return this;
    }

    public int getInitHeapSize() {
        return this.initHeapSize;
    }

    public int getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public int getMaxDirectMemorySize() {
        return this.maxDirectMemorySize;
    }

    public String getTimezone() {
        return this.timezone;
    }

    private void validate() {
        if (this.initHeapSize > this.maxHeapSize) {
            throw new IllegalArgumentException("The initHeapSize " + this.initHeapSize + " must be not larger than the maxHeapSize " + this.maxHeapSize);
        }
    }

    public void override(@Nullable MppJVMConfig config) {
        if (config == null) {
            return;
        }
        this.setInitHeapSize(config.getInitHeapSize());
        this.setMaxHeapSize(config.getMaxHeapSize());
        this.setMaxDirectMemorySize(config.getMaxDirectMemorySize());
        this.setTimezone(config.getTimezone());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final MppJVMConfig config = new MppJVMConfig();

        public Builder setInitHeapSize(int size) {
            this.config.setInitHeapSize(size);
            return this;
        }

        public Builder setMaxHeapSize(int size) {
            this.config.setMaxHeapSize(size);
            return this;
        }

        public Builder setMaxDirectMemorySize(int size) {
            this.config.setMaxDirectMemorySize(size);
            return this;
        }

        public Builder setTimezone(String timezone) {
            this.config.setTimezone(timezone);
            return this;
        }

        public MppJVMConfig build() {
            this.config.validate();
            return this.config;
        }
    }
}

