/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example.relational;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.udf.api.exception.UDFArgumentNotValidException;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.relational.TableFunction;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.iotdb.udf.api.relational.table.MapTableFunctionHandle;
import org.apache.iotdb.udf.api.relational.table.TableFunctionAnalysis;
import org.apache.iotdb.udf.api.relational.table.TableFunctionHandle;
import org.apache.iotdb.udf.api.relational.table.TableFunctionProcessorProvider;
import org.apache.iotdb.udf.api.relational.table.argument.Argument;
import org.apache.iotdb.udf.api.relational.table.argument.DescribedSchema;
import org.apache.iotdb.udf.api.relational.table.argument.ScalarArgument;
import org.apache.iotdb.udf.api.relational.table.processor.TableFunctionDataProcessor;
import org.apache.iotdb.udf.api.relational.table.specification.ParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.ScalarParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.TableParameterSpecification;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.block.column.ColumnBuilder;

public class MyRepeatWithIndex
implements TableFunction {
    private final String TBL_PARAM = "DATA";
    private final String N_PARAM = "N";

    public List<ParameterSpecification> getArgumentsSpecifications() {
        return Arrays.asList(TableParameterSpecification.builder().name("DATA").rowSemantics().passThroughColumns().build(), ScalarParameterSpecification.builder().name("N").type(Type.INT32).build());
    }

    public TableFunctionAnalysis analyze(Map<String, Argument> arguments) throws UDFException {
        ScalarArgument count = (ScalarArgument)arguments.get("N");
        if (count == null) {
            throw new UDFArgumentNotValidException("count argument for function repeat() is missing");
        }
        if ((Integer)count.getValue() <= 0) {
            throw new UDFArgumentNotValidException("count argument for function repeat() must be positive");
        }
        MapTableFunctionHandle handle = new MapTableFunctionHandle.Builder().addProperty("N", count.getValue()).build();
        return TableFunctionAnalysis.builder().properColumnSchema(DescribedSchema.builder().addField("repeat_index", Type.INT32).build()).requiredColumns("DATA", Collections.singletonList(0)).handle((TableFunctionHandle)handle).build();
    }

    public TableFunctionHandle createTableFunctionHandle() {
        return new MapTableFunctionHandle();
    }

    public TableFunctionProcessorProvider getProcessorProvider(final TableFunctionHandle tableFunctionHandle) {
        return new TableFunctionProcessorProvider(){

            public TableFunctionDataProcessor getDataProcessor() {
                return new TableFunctionDataProcessor(){
                    private final int n;
                    private long recordIndex;
                    {
                        this.n = (Integer)((MapTableFunctionHandle)tableFunctionHandle).getProperty("N");
                        this.recordIndex = 0L;
                    }

                    public void process(Record input, List<ColumnBuilder> properColumnBuilders, ColumnBuilder passThroughIndexBuilder) {
                        for (int i = 0; i < this.n; ++i) {
                            properColumnBuilders.get(0).writeInt(i);
                            passThroughIndexBuilder.writeLong(this.recordIndex);
                        }
                        ++this.recordIndex;
                    }
                };
            }
        };
    }
}

