/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example.relational;

import java.nio.ByteBuffer;
import org.apache.iotdb.udf.api.State;
import org.apache.iotdb.udf.api.customizer.analysis.AggregateFunctionAnalysis;
import org.apache.iotdb.udf.api.customizer.parameter.FunctionArguments;
import org.apache.iotdb.udf.api.exception.UDFArgumentNotValidException;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.relational.AggregateFunction;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.iotdb.udf.api.utils.ResultValue;

public class FirstTwoSum
implements AggregateFunction {
    public AggregateFunctionAnalysis analyze(FunctionArguments arguments) throws UDFArgumentNotValidException {
        if (arguments.getArgumentsSize() != 3) {
            throw new UDFArgumentNotValidException("FirstTwoSum should accept three column as input");
        }
        for (int i = 0; i < 2; ++i) {
            if (arguments.getDataType(i) == Type.INT32 || arguments.getDataType(i) == Type.INT64 || arguments.getDataType(i) == Type.FLOAT || arguments.getDataType(i) == Type.DOUBLE) continue;
            throw new UDFArgumentNotValidException("FirstTwoSum should accept INT32, INT64, FLOAT, DOUBLE as the first two inputs");
        }
        if (arguments.getDataType(2) != Type.TIMESTAMP) {
            throw new UDFArgumentNotValidException("FirstTwoSum should accept TIMESTAMP as the third input");
        }
        return new AggregateFunctionAnalysis.Builder().outputDataType(Type.DOUBLE).build();
    }

    public State createState() {
        return new FirstTwoSumState();
    }

    public void addInput(State state, Record input) {
        FirstTwoSumState firstTwoSumState = (FirstTwoSumState)state;
        long time = input.getLong(2);
        if (!input.isNull(0) && time < firstTwoSumState.firstTime) {
            firstTwoSumState.firstTime = time;
            switch (input.getDataType(0)) {
                case INT32: {
                    firstTwoSumState.firstValue = input.getInt(0);
                    break;
                }
                case INT64: {
                    firstTwoSumState.firstValue = input.getLong(0);
                    break;
                }
                case FLOAT: {
                    firstTwoSumState.firstValue = input.getFloat(0);
                    break;
                }
                case DOUBLE: {
                    firstTwoSumState.firstValue = input.getDouble(0);
                    break;
                }
                default: {
                    throw new UDFException("FirstTwoSum should accept INT32, INT64, FLOAT, DOUBLE as the first two inputs");
                }
            }
        }
        if (!input.isNull(1) && time < firstTwoSumState.secondTime) {
            firstTwoSumState.secondTime = time;
            switch (input.getDataType(1)) {
                case INT32: {
                    firstTwoSumState.secondValue = input.getInt(1);
                    break;
                }
                case INT64: {
                    firstTwoSumState.secondValue = input.getLong(1);
                    break;
                }
                case FLOAT: {
                    firstTwoSumState.secondValue = input.getFloat(1);
                    break;
                }
                case DOUBLE: {
                    firstTwoSumState.secondValue = input.getDouble(1);
                    break;
                }
                default: {
                    throw new UDFException("FirstTwoSum should accept INT32, INT64, FLOAT, DOUBLE as the first two inputs");
                }
            }
        }
    }

    public void combineState(State state, State rhs) {
        FirstTwoSumState firstTwoSumState = (FirstTwoSumState)state;
        FirstTwoSumState rhsState = (FirstTwoSumState)rhs;
        if (rhsState.firstTime < firstTwoSumState.firstTime) {
            firstTwoSumState.firstTime = rhsState.firstTime;
            firstTwoSumState.firstValue = rhsState.firstValue;
        }
        if (rhsState.secondTime < firstTwoSumState.secondTime) {
            firstTwoSumState.secondTime = rhsState.secondTime;
            firstTwoSumState.secondValue = rhsState.secondValue;
        }
    }

    public void outputFinal(State state, ResultValue resultValue) {
        FirstTwoSumState firstTwoSumState = (FirstTwoSumState)state;
        if (firstTwoSumState.firstTime == Long.MAX_VALUE && firstTwoSumState.secondTime == Long.MAX_VALUE) {
            resultValue.setNull();
        } else {
            resultValue.setDouble(firstTwoSumState.firstValue + firstTwoSumState.secondValue);
        }
    }

    static class FirstTwoSumState
    implements State {
        long firstTime = Long.MAX_VALUE;
        long secondTime = Long.MAX_VALUE;
        double firstValue;
        double secondValue;

        FirstTwoSumState() {
        }

        public void reset() {
            this.firstTime = Long.MAX_VALUE;
            this.secondTime = Long.MAX_VALUE;
            this.firstValue = 0.0;
            this.secondValue = 0.0;
        }

        public byte[] serialize() {
            ByteBuffer buffer = ByteBuffer.allocate(32);
            buffer.putLong(this.firstTime);
            buffer.putLong(this.secondTime);
            buffer.putDouble(this.firstValue);
            buffer.putDouble(this.secondValue);
            return buffer.array();
        }

        public void deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            this.firstTime = buffer.getLong();
            this.secondTime = buffer.getLong();
            this.firstValue = buffer.getDouble();
            this.secondValue = buffer.getDouble();
        }
    }
}

