/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example.relational;

import java.time.LocalDate;
import org.apache.iotdb.udf.api.customizer.analysis.ScalarFunctionAnalysis;
import org.apache.iotdb.udf.api.customizer.parameter.FunctionArguments;
import org.apache.iotdb.udf.api.exception.UDFArgumentNotValidException;
import org.apache.iotdb.udf.api.relational.ScalarFunction;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.iotdb.udf.api.type.Type;

public class DatePlus
implements ScalarFunction {
    public ScalarFunctionAnalysis analyze(FunctionArguments arguments) throws UDFArgumentNotValidException {
        if (arguments.getArgumentsSize() != 2) {
            throw new UDFArgumentNotValidException("Only two parameter is required.");
        }
        if (arguments.getDataType(0) != Type.DATE) {
            throw new UDFArgumentNotValidException("The first parameter should be DATE type.");
        }
        if (arguments.getDataType(1) != Type.INT32 && arguments.getDataType(1) != Type.INT64) {
            throw new UDFArgumentNotValidException("The second parameter should be INT type.");
        }
        return new ScalarFunctionAnalysis.Builder().outputDataType(Type.DATE).build();
    }

    public Object evaluate(Record input) {
        LocalDate date = input.getLocalDate(0);
        int days = input.getInt(1);
        return date.plusDays(days);
    }
}

