/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example.relational;

import java.util.HashSet;
import org.apache.iotdb.udf.api.customizer.analysis.ScalarFunctionAnalysis;
import org.apache.iotdb.udf.api.customizer.parameter.FunctionArguments;
import org.apache.iotdb.udf.api.exception.UDFArgumentNotValidException;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.relational.ScalarFunction;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.iotdb.udf.api.type.Type;

public class AllSum
implements ScalarFunction {
    private Type outputDataType;

    public ScalarFunctionAnalysis analyze(FunctionArguments arguments) throws UDFArgumentNotValidException {
        if (arguments.getArgumentsSize() < 1) {
            throw new UDFArgumentNotValidException("At least one parameter is required.");
        }
        for (int i = 0; i < arguments.getArgumentsSize(); ++i) {
            if (arguments.getDataType(i) == Type.INT32 || arguments.getDataType(i) == Type.INT64 || arguments.getDataType(i) == Type.FLOAT || arguments.getDataType(i) == Type.DOUBLE) continue;
            throw new UDFArgumentNotValidException("Only support inputs of INT32,INT64,DOUBLE,FLOAT type.");
        }
        return new ScalarFunctionAnalysis.Builder().outputDataType(this.inferOutputDataType(arguments)).build();
    }

    public void beforeStart(FunctionArguments arguments) throws UDFException {
        this.outputDataType = this.inferOutputDataType(arguments);
    }

    private Type inferOutputDataType(FunctionArguments arguments) {
        HashSet<Type> inputTypeSet = new HashSet<Type>();
        for (int i = 0; i < arguments.getArgumentsSize(); ++i) {
            inputTypeSet.add(arguments.getDataType(i));
        }
        if (inputTypeSet.contains(Type.DOUBLE)) {
            return Type.DOUBLE;
        }
        if (inputTypeSet.contains(Type.FLOAT)) {
            return Type.FLOAT;
        }
        if (inputTypeSet.contains(Type.INT64)) {
            return Type.INT64;
        }
        return Type.INT32;
    }

    public Object evaluate(Record input) {
        double res = 0.0;
        block12: for (int i = 0; i < input.size(); ++i) {
            if (input.isNull(i)) continue;
            switch (input.getDataType(i)) {
                case INT32: {
                    res += (double)input.getInt(i);
                    continue block12;
                }
                case INT64: {
                    res += (double)input.getLong(i);
                    continue block12;
                }
                case FLOAT: {
                    res += (double)input.getFloat(i);
                    continue block12;
                }
                case DOUBLE: {
                    res += input.getDouble(i);
                }
            }
        }
        switch (this.outputDataType) {
            case INT32: {
                return (int)res;
            }
            case INT64: {
                return (long)res;
            }
            case FLOAT: {
                return Float.valueOf((float)res);
            }
            case DOUBLE: {
                return res;
            }
        }
        throw new RuntimeException("Unexpected output type.");
    }
}

