/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.itbase.constant;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.udf.builtin.BuiltinAggregationFunction;

public enum BuiltinAggregationFunctionEnum {
    MIN_TIME("min_time"),
    MAX_TIME("max_time"),
    MAX_VALUE("max_value"),
    MIN_VALUE("min_value"),
    EXTREME("extreme"),
    FIRST_VALUE("first_value"),
    STDDEV("stddev"),
    STDDEV_POP("stddev_pop"),
    STDDEV_SAMP("stddev_samp"),
    VARIANCE("variance"),
    VAR_POP("var_pop"),
    VAR_SAMP("var_samp"),
    LAST_VALUE("last_value"),
    COUNT("count"),
    AVG("avg"),
    SUM("sum"),
    MAX_BY("max_by"),
    MIN_BY("min_by");

    private final String functionName;
    private static final Set<String> NATIVE_FUNCTION_NAMES;

    private BuiltinAggregationFunctionEnum(String functionName) {
        this.functionName = functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public static Set<String> getNativeFunctionNames() {
        return NATIVE_FUNCTION_NAMES;
    }

    static {
        NATIVE_FUNCTION_NAMES = new HashSet<String>(Arrays.stream(BuiltinAggregationFunction.values()).map(BuiltinAggregationFunction::getFunctionName).collect(Collectors.toList()));
    }
}

