/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example;

import java.nio.ByteBuffer;
import org.apache.iotdb.udf.api.State;
import org.apache.iotdb.udf.api.UDAF;
import org.apache.iotdb.udf.api.customizer.config.UDAFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.iotdb.udf.api.utils.ResultValue;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class UDAFAvg
implements UDAF {
    private Type dataType;

    public void validate(UDFParameterValidator validator) throws UDFException {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
    }

    public void beforeStart(UDFParameters parameters, UDAFConfigurations configurations) {
        this.dataType = parameters.getDataType(0);
        configurations.setOutputDataType(Type.DOUBLE);
    }

    public State createState() {
        return new AvgState();
    }

    public void addInput(State state, Column[] columns, BitMap bitMap) {
        AvgState avgState = (AvgState)state;
        switch (this.dataType) {
            case INT32: {
                this.addIntInput(avgState, columns, bitMap);
                return;
            }
            case INT64: {
                this.addLongInput(avgState, columns, bitMap);
                return;
            }
            case FLOAT: {
                this.addFloatInput(avgState, columns, bitMap);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(avgState, columns, bitMap);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in aggregation AVG : %s", this.dataType));
    }

    public void combineState(State state, State rhs) {
        AvgState avgState = (AvgState)state;
        AvgState avgRhs = (AvgState)rhs;
        avgState.count += avgRhs.count;
        avgState.sum += avgRhs.sum;
    }

    public void outputFinal(State state, ResultValue resultValue) {
        AvgState avgState = (AvgState)state;
        if (avgState.count != 0L) {
            resultValue.setDouble(avgState.sum / (double)avgState.count);
        } else {
            resultValue.setNull();
        }
    }

    public void removeState(State state, State removed) {
        AvgState avgState = (AvgState)state;
        AvgState avgRhs = (AvgState)removed;
        avgState.count -= avgRhs.count;
        avgState.sum -= avgRhs.sum;
    }

    private void addIntInput(AvgState state, Column[] columns, BitMap bitMap) {
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || columns[0].isNull(i)) continue;
            ++state.count;
            state.sum += (double)columns[0].getInt(i);
        }
    }

    private void addLongInput(AvgState avgState, Column[] columns, BitMap bitMap) {
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || columns[0].isNull(i)) continue;
            ++avgState.count;
            avgState.sum += (double)columns[0].getLong(i);
        }
    }

    private void addFloatInput(AvgState avgState, Column[] columns, BitMap bitMap) {
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || columns[0].isNull(i)) continue;
            ++avgState.count;
            avgState.sum += (double)columns[0].getFloat(i);
        }
    }

    private void addDoubleInput(AvgState avgState, Column[] columns, BitMap bitMap) {
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || columns[0].isNull(i)) continue;
            ++avgState.count;
            avgState.sum += columns[0].getDouble(i);
        }
    }

    static class AvgState
    implements State {
        double sum;
        long count;

        AvgState() {
        }

        public void reset() {
            this.sum = 0.0;
            this.count = 0L;
        }

        public byte[] serialize() {
            ByteBuffer buffer = ByteBuffer.allocate(16);
            buffer.putDouble(this.sum);
            buffer.putLong(this.count);
            return buffer.array();
        }

        public void deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            this.sum = buffer.getDouble();
            this.count = buffer.getLong();
        }
    }
}

