/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.itbase.runtime;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.iotdb.it.framework.IoTDBTestLogger;
import org.slf4j.Logger;

public class NodeConnection {
    private static final Logger logger = IoTDBTestLogger.logger;
    private final String endpoint;
    private final NodeRole nodeRole;
    private final ConnectionRole connectionRole;
    private final Connection underlyingConnecton;

    public NodeConnection(String endpoint, NodeRole nodeRole, ConnectionRole connectionRole, Connection underlyingConnecton) {
        this.endpoint = endpoint;
        this.nodeRole = nodeRole;
        this.connectionRole = connectionRole;
        this.underlyingConnecton = underlyingConnecton;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public NodeRole getNodeRole() {
        return this.nodeRole;
    }

    public ConnectionRole getConnectionRole() {
        return this.connectionRole;
    }

    public Connection getUnderlyingConnecton() {
        return this.underlyingConnecton;
    }

    public void close() {
        try {
            this.underlyingConnecton.close();
        }
        catch (SQLException e) {
            logger.error("Close connection {} error", (Object)this, (Object)e);
        }
    }

    public String toString() {
        return String.format("%s-%s@%s", new Object[]{this.nodeRole, this.connectionRole, this.endpoint});
    }

    public static enum NodeRole {
        CONFIG_NODE,
        DATA_NODE;

    }

    public static enum ConnectionRole {
        READ,
        WRITE;

    }
}

