/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.itbase.runtime;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.apache.iotdb.itbase.runtime.RequestDelegate;
import org.apache.iotdb.itbase.runtime.SerialRequestDelegate;

public class ClusterResultSetMetaData
implements ResultSetMetaData {
    private final List<ResultSetMetaData> metaDataList;
    private final List<String> endpoints;

    public ClusterResultSetMetaData(List<ResultSetMetaData> metadataList, List<String> endpoints) {
        this.metaDataList = metadataList;
        this.endpoints = endpoints;
    }

    @Override
    public int getColumnCount() throws SQLException {
        RequestDelegate<Integer> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(rs::getColumnCount);
        }
        return (Integer)delegate.requestAllAndCompare();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        RequestDelegate<Boolean> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.isAutoIncrement(column));
        }
        return (Boolean)delegate.requestAllAndCompare();
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        RequestDelegate<Boolean> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.isCaseSensitive(column));
        }
        return (Boolean)delegate.requestAllAndCompare();
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        RequestDelegate<Boolean> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.isSearchable(column));
        }
        return (Boolean)delegate.requestAllAndCompare();
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        RequestDelegate<Boolean> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.isCurrency(column));
        }
        return (Boolean)delegate.requestAllAndCompare();
    }

    @Override
    public int isNullable(int column) throws SQLException {
        RequestDelegate<Integer> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.isNullable(column));
        }
        return (Integer)delegate.requestAllAndCompare();
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        RequestDelegate<Boolean> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.isSigned(column));
        }
        return (Boolean)delegate.requestAllAndCompare();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        RequestDelegate<Integer> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.getColumnDisplaySize(column));
        }
        return (Integer)delegate.requestAllAndCompare();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        RequestDelegate<String> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.getColumnLabel(column));
        }
        return (String)delegate.requestAllAndCompare();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        RequestDelegate<String> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.getColumnName(column));
        }
        return (String)delegate.requestAllAndCompare();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        RequestDelegate<String> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.getSchemaName(column));
        }
        return (String)delegate.requestAllAndCompare();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        RequestDelegate<Integer> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.getPrecision(column));
        }
        return (Integer)delegate.requestAllAndCompare();
    }

    @Override
    public int getScale(int column) throws SQLException {
        RequestDelegate<Integer> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.getScale(column));
        }
        return (Integer)delegate.requestAllAndCompare();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        RequestDelegate<String> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.getTableName(column));
        }
        return (String)delegate.requestAllAndCompare();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        RequestDelegate<String> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.getCatalogName(column));
        }
        return (String)delegate.requestAllAndCompare();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        RequestDelegate<Integer> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.getColumnType(column));
        }
        return (Integer)delegate.requestAllAndCompare();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        RequestDelegate<String> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.getColumnTypeName(column));
        }
        return (String)delegate.requestAllAndCompare();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        RequestDelegate<Boolean> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.isReadOnly(column));
        }
        return (Boolean)delegate.requestAllAndCompare();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        RequestDelegate<Boolean> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.isWritable(column));
        }
        return (Boolean)delegate.requestAllAndCompare();
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        RequestDelegate<Boolean> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.isDefinitelyWritable(column));
        }
        return (Boolean)delegate.requestAllAndCompare();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        RequestDelegate<String> delegate = this.createRequestDelegate();
        for (ResultSetMetaData rs : this.metaDataList) {
            delegate.addRequest(() -> rs.getColumnClassName(column));
        }
        return (String)delegate.requestAllAndCompare();
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        throw new UnsupportedOperationException();
    }

    private <T> RequestDelegate<T> createRequestDelegate() {
        return new SerialRequestDelegate(this.endpoints);
    }
}

