/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.it.framework;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.apache.iotdb.it.framework.IoTDBTestConstants;
import org.apache.iotdb.it.framework.IoTDBTestLogger;
import org.apache.iotdb.it.framework.IoTDBTestStat;

public class IoTDBTestReporter {
    public static void main(String[] args) throws IOException {
        ArrayList stats = new ArrayList();
        Path outputDirPath = Paths.get(System.getProperty("user.dir"), "integration-test", IoTDBTestConstants.statOutputDir);
        File outputDir = outputDirPath.toFile();
        if (!outputDir.exists() || !outputDir.isDirectory()) {
            IoTDBTestLogger.logger.error("the output dir {} is not a valid directory, the reporter will be aborted", (Object)outputDirPath);
            return;
        }
        try (Stream<Path> s = Files.walk(outputDirPath, new FileVisitOption[0]);){
            s.forEach(source -> {
                if (source.toString().endsWith(".stats")) {
                    try {
                        List<String> lines = Files.readAllLines(source);
                        for (String l : lines) {
                            String[] parts = l.split("\t");
                            if (parts.length != 2) continue;
                            NumberFormat f = NumberFormat.getInstance(Locale.getDefault());
                            double seconds = f.parse(parts[0]).doubleValue();
                            IoTDBTestStat stat = new IoTDBTestStat(parts[1], seconds);
                            stats.add(stat);
                        }
                    }
                    catch (IOException | ParseException e) {
                        IoTDBTestLogger.logger.error("read stats file failed", (Throwable)e);
                    }
                }
            });
        }
        Collections.sort(stats);
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("==== Top 30 slowest cases ====\n");
        for (int i = 0; i < Math.min(30, stats.size()); ++i) {
            sb.append(stats.get(i)).append("\n");
        }
        IoTDBTestLogger.logger.info("{}", (Object)sb);
    }
}

