/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.itbase.env;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.rpc.thrift.IConfigNodeRPCService;
import org.apache.iotdb.isession.ISession;
import org.apache.iotdb.isession.pool.ISessionPool;
import org.apache.iotdb.it.env.cluster.node.AbstractNodeWrapper;
import org.apache.iotdb.it.env.cluster.node.ConfigNodeWrapper;
import org.apache.iotdb.it.env.cluster.node.DataNodeWrapper;
import org.apache.iotdb.itbase.env.BaseNodeWrapper;
import org.apache.iotdb.itbase.env.ClusterConfig;
import org.apache.iotdb.jdbc.Constant;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import reactor.util.annotation.Nullable;

public interface BaseEnv {
    public void initClusterEnvironment();

    public void initClusterEnvironment(int var1, int var2);

    public void initClusterEnvironment(int var1, int var2, int var3);

    public void cleanClusterEnvironment();

    public ClusterConfig getConfig();

    default public String getUrlContent(String urlStr, @Nullable String authHeader) {
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader bufr;
            URL url = new URL(urlStr);
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            if (authHeader != null) {
                httpConnection.setRequestProperty("Authorization", authHeader);
            }
            if (httpConnection.getResponseCode() == 200) {
                String str;
                InputStream in = httpConnection.getInputStream();
                InputStreamReader isr = new InputStreamReader(in);
                bufr = new BufferedReader(isr);
                while ((str = bufr.readLine()) != null) {
                    sb.append(str);
                    sb.append('\n');
                }
            } else {
                return null;
            }
            bufr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return sb.toString();
    }

    public List<String> getMetricPrometheusReporterContents(String var1);

    default public Connection getConnection() throws SQLException {
        return this.getConnection("root", "root");
    }

    default public Connection getConnection(Constant.Version version) throws SQLException {
        return this.getConnection(version, "root", "root");
    }

    public Connection getConnection(Constant.Version var1, String var2, String var3) throws SQLException;

    public Connection getConnection(String var1, String var2) throws SQLException;

    public Connection getConnection(DataNodeWrapper var1, String var2, String var3) throws SQLException;

    default public Connection getWriteOnlyConnectionWithSpecifiedDataNode(DataNodeWrapper dataNode) throws SQLException {
        return this.getWriteOnlyConnectionWithSpecifiedDataNode(dataNode, "root", "root");
    }

    public Connection getWriteOnlyConnectionWithSpecifiedDataNode(DataNodeWrapper var1, String var2, String var3) throws SQLException;

    default public Connection getConnectionWithSpecifiedDataNode(DataNodeWrapper dataNode) throws SQLException {
        return this.getConnectionWithSpecifiedDataNode(dataNode, "root", "root");
    }

    public Connection getConnectionWithSpecifiedDataNode(DataNodeWrapper var1, String var2, String var3) throws SQLException;

    public void setTestMethodName(String var1);

    public void dumpTestJVMSnapshot();

    public List<AbstractNodeWrapper> getNodeWrapperList();

    public List<ConfigNodeWrapper> getConfigNodeWrapperList();

    public List<DataNodeWrapper> getDataNodeWrapperList();

    public IConfigNodeRPCService.Iface getLeaderConfigNodeConnection() throws ClientManagerException, IOException, InterruptedException;

    public ISessionPool getSessionPool(int var1);

    public ISession getSessionConnection() throws IoTDBConnectionException;

    public ISession getSessionConnection(ZoneId var1) throws IoTDBConnectionException;

    public ISession getSessionConnection(String var1, String var2) throws IoTDBConnectionException;

    public ISession getSessionConnection(List<String> var1) throws IoTDBConnectionException;

    public int getFirstLeaderSchemaRegionDataNodeIndex() throws IOException, InterruptedException;

    public int getLeaderConfigNodeIndex() throws IOException, InterruptedException;

    default public IConfigNodeRPCService.Iface getConfigNodeConnection(int index) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void startConfigNode(int var1);

    public void startAllConfigNodes();

    public void shutdownConfigNode(int var1);

    public void shutdownAllConfigNodes();

    public void shutdownForciblyAllConfigNodes();

    public void ensureNodeStatus(List<BaseNodeWrapper> var1, List<NodeStatus> var2) throws IllegalStateException;

    public ConfigNodeWrapper getConfigNodeWrapper(int var1);

    public DataNodeWrapper getDataNodeWrapper(int var1);

    public ConfigNodeWrapper generateRandomConfigNodeWrapper();

    public DataNodeWrapper generateRandomDataNodeWrapper();

    public void registerNewDataNode(boolean var1);

    public void registerNewDataNode(DataNodeWrapper var1, boolean var2);

    public void registerNewConfigNode(boolean var1);

    public void registerNewConfigNode(ConfigNodeWrapper var1, boolean var2);

    public void startDataNode(int var1);

    public void startAllDataNodes();

    public void shutdownDataNode(int var1);

    public void shutdownAllDataNodes();

    public void shutdownForciblyAllDataNodes();

    public int getMqttPort();

    public String getIP();

    public String getPort();

    public String getSbinPath();

    public String getToolsPath();

    public String getLibPath();

    public Optional<DataNodeWrapper> dataNodeIdToWrapper(int var1);

    public void registerConfigNodeKillPoints(List<String> var1);

    public void registerDataNodeKillPoints(List<String> var1);
}

