/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.it.utils;

import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.exception.write.WriteProcessException;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.write.TsFileWriter;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileGenerator
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileGenerator.class);
    private final File tsFile;
    private final TsFileWriter writer;
    private final Map<String, TreeSet<Long>> device2TimeSet;
    private final Map<String, List<MeasurementSchema>> device2MeasurementSchema;
    private Random random;

    public TsFileGenerator(File tsFile) throws IOException {
        this.tsFile = tsFile;
        this.writer = new TsFileWriter(tsFile);
        this.device2TimeSet = new HashMap<String, TreeSet<Long>>();
        this.device2MeasurementSchema = new HashMap<String, List<MeasurementSchema>>();
        this.random = new Random();
    }

    public void resetRandom() {
        this.random = new Random();
    }

    public void resetRandom(long seed) {
        this.random = new Random(seed);
    }

    public void registerTimeseries(String path, List<MeasurementSchema> measurementSchemaList) {
        if (this.device2MeasurementSchema.containsKey(path)) {
            LOGGER.error("Register same device {}.", (Object)path);
            return;
        }
        this.writer.registerTimeseries(new Path(path), measurementSchemaList);
        this.device2TimeSet.put(path, new TreeSet());
        this.device2MeasurementSchema.put(path, measurementSchemaList);
    }

    public void registerAlignedTimeseries(String path, List<MeasurementSchema> measurementSchemaList) throws WriteProcessException {
        if (this.device2MeasurementSchema.containsKey(path)) {
            LOGGER.error("Register same device {}.", (Object)path);
            return;
        }
        this.writer.registerAlignedTimeseries(new Path(path), measurementSchemaList);
        this.device2TimeSet.put(path, new TreeSet());
        this.device2MeasurementSchema.put(path, measurementSchemaList);
    }

    public void generateData(String device, int number, long timeGap, boolean isAligned) throws IOException, WriteProcessException {
        List<MeasurementSchema> schemas = this.device2MeasurementSchema.get(device);
        TreeSet<Long> timeSet = this.device2TimeSet.get(device);
        Tablet tablet = new Tablet(device, schemas);
        long[] timestamps = tablet.timestamps;
        Object[] values = tablet.values;
        long sensorNum = schemas.size();
        long startTime = timeSet.isEmpty() ? 0L : timeSet.last();
        for (long r = 0L; r < (long)number; ++r) {
            ++tablet.rowSize;
            timestamps[row] = startTime += timeGap;
            timeSet.add(startTime);
            int i = 0;
            while ((long)i < sensorNum) {
                int row;
                this.generateDataPoint(values[i], row, schemas.get(i));
                ++i;
            }
            if (tablet.rowSize != tablet.getMaxRowNumber()) continue;
            if (!isAligned) {
                this.writer.write(tablet);
            } else {
                this.writer.writeAligned(tablet);
            }
            tablet.reset();
        }
        if (tablet.rowSize != 0) {
            if (!isAligned) {
                this.writer.write(tablet);
            } else {
                this.writer.writeAligned(tablet);
            }
            tablet.reset();
        }
        LOGGER.info("Write {} points into device {}", (Object)number, (Object)device);
    }

    public void generateData(String device, int number, long timeGap, boolean isAligned, long startTimestamp) throws IOException, WriteProcessException {
        List<MeasurementSchema> schemas = this.device2MeasurementSchema.get(device);
        TreeSet<Long> timeSet = this.device2TimeSet.get(device);
        Tablet tablet = new Tablet(device, schemas);
        long[] timestamps = tablet.timestamps;
        Object[] values = tablet.values;
        long sensorNum = schemas.size();
        long startTime = startTimestamp;
        for (long r = 0L; r < (long)number; ++r) {
            ++tablet.rowSize;
            timestamps[row] = startTime += timeGap;
            timeSet.add(startTime);
            int i = 0;
            while ((long)i < sensorNum) {
                int row;
                this.generateDataPoint(values[i], row, schemas.get(i));
                ++i;
            }
            if (tablet.rowSize != tablet.getMaxRowNumber()) continue;
            if (!isAligned) {
                this.writer.write(tablet);
            } else {
                this.writer.writeAligned(tablet);
            }
            tablet.reset();
        }
        if (tablet.rowSize != 0) {
            if (!isAligned) {
                this.writer.write(tablet);
            } else {
                this.writer.writeAligned(tablet);
            }
            tablet.reset();
        }
        LOGGER.info("Write {} points into device {}", (Object)number, (Object)device);
    }

    private void generateDataPoint(Object obj, int row, MeasurementSchema schema) {
        switch (schema.getType()) {
            case INT32: {
                this.generateINT32(obj, row);
                break;
            }
            case DATE: {
                this.generateDATE(obj, row);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.generateINT64(obj, row);
                break;
            }
            case FLOAT: {
                this.generateFLOAT(obj, row);
                break;
            }
            case DOUBLE: {
                this.generateDOUBLE(obj, row);
                break;
            }
            case BOOLEAN: {
                this.generateBOOLEAN(obj, row);
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                this.generateTEXT(obj, row);
                break;
            }
            default: {
                LOGGER.error("Wrong data type {}.", (Object)schema.getType());
            }
        }
    }

    private void generateINT32(Object obj, int row) {
        int[] ints = (int[])obj;
        ints[row] = this.random.nextInt();
    }

    private void generateDATE(Object obj, int row) {
        LocalDate[] dates = (LocalDate[])obj;
        dates[row] = LocalDate.of(1000 + this.random.nextInt(9000), 1 + this.random.nextInt(12), 1 + this.random.nextInt(28));
    }

    private void generateINT64(Object obj, int row) {
        long[] longs = (long[])obj;
        longs[row] = this.random.nextLong();
    }

    private void generateFLOAT(Object obj, int row) {
        float[] floats = (float[])obj;
        floats[row] = this.random.nextFloat();
    }

    private void generateDOUBLE(Object obj, int row) {
        double[] doubles = (double[])obj;
        doubles[row] = this.random.nextDouble();
    }

    private void generateBOOLEAN(Object obj, int row) {
        boolean[] booleans = (boolean[])obj;
        booleans[row] = this.random.nextBoolean();
    }

    private void generateTEXT(Object obj, int row) {
        Binary[] binaries = (Binary[])obj;
        binaries[row] = new Binary(String.format("test point %d", this.random.nextInt()), TSFileConfig.STRING_CHARSET);
    }

    public void generateDeletion(String device) throws IOException, IllegalPathException {
        try (ModificationFile modificationFile = new ModificationFile(this.tsFile.getAbsolutePath() + ".mods");){
            modificationFile.write((Modification)new Deletion(new PartialPath(device + "." + "*"), this.tsFile.length(), Long.MIN_VALUE, Long.MAX_VALUE));
            this.device2TimeSet.remove(device);
            this.device2MeasurementSchema.remove(device);
        }
    }

    public void generateDeletion(String device, MeasurementSchema measurement) throws IOException, IllegalPathException {
        try (ModificationFile modificationFile = new ModificationFile(this.tsFile.getAbsolutePath() + ".mods");){
            modificationFile.write((Modification)new Deletion(new PartialPath(device + "." + measurement.getMeasurementId()), this.tsFile.length(), Long.MIN_VALUE, Long.MAX_VALUE));
            this.device2MeasurementSchema.get(device).remove(measurement);
        }
    }

    public void generateDeletion(String device, int number) throws IOException, IllegalPathException {
        try (ModificationFile modificationFile = new ModificationFile(this.tsFile.getAbsolutePath() + ".mods");){
            this.writer.flushAllChunkGroups();
            TreeSet<Long> timeSet = this.device2TimeSet.get(device);
            if (timeSet.isEmpty()) {
                return;
            }
            long fileOffset = this.tsFile.length();
            long maxTime = timeSet.last() - 1L;
            for (int i = 0; i < number; ++i) {
                int endTime = this.random.nextInt((int)maxTime) + 1;
                int startTime = this.random.nextInt(endTime);
                for (MeasurementSchema measurementSchema : this.device2MeasurementSchema.get(device)) {
                    Deletion deletion = new Deletion(new PartialPath(device + "." + measurementSchema.getMeasurementId()), fileOffset, (long)startTime, (long)endTime);
                    modificationFile.write((Modification)deletion);
                }
                for (long j = (long)startTime; j <= (long)endTime; ++j) {
                    timeSet.remove(j);
                }
                LOGGER.info("Delete {} - {} timestamp of device {}", new Object[]{startTime, endTime, device});
            }
        }
    }

    public long getTotalNumber() {
        return this.device2TimeSet.entrySet().stream().mapToInt(entry -> ((TreeSet)entry.getValue()).size() * this.device2MeasurementSchema.get(entry.getKey()).size()).sum();
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
    }
}

