/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example;

import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Multiplier
implements UDTF {
    private static final Logger logger = LoggerFactory.getLogger(Multiplier.class);
    private long a;
    private long b;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.INT64);
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        logger.debug("Multiplier#beforeStart");
        this.a = parameters.getLongOrDefault("a", 0L);
        this.b = parameters.getLongOrDefault("b", 0L);
        configurations.setOutputDataType(Type.INT64).setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy());
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        collector.putLong(row.getTime(), row.getLong(0) * this.a * this.b);
    }

    public void beforeDestroy() {
        logger.debug("Multiplier#beforeDestroy");
    }
}

