/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example;

import java.io.IOException;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Adder
implements UDTF {
    private static final Logger logger = LoggerFactory.getLogger(Adder.class);
    private double addend;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(2).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE}).validateInputSeriesDataType(1, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        logger.debug("Adder#beforeStart");
        this.addend = parameters.getFloatOrDefault("addend", 0.0f);
        configurations.setOutputDataType(Type.INT64).setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy());
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        if (row.isNull(0) || row.isNull(1)) {
            return;
        }
        collector.putLong(row.getTime(), (long)(this.extractDoubleValue(row, 0) + this.extractDoubleValue(row, 1) + this.addend));
    }

    private double extractDoubleValue(Row row, int index) throws IOException {
        double value;
        switch (row.getDataType(index)) {
            case INT32: {
                value = row.getInt(index);
                break;
            }
            case INT64: {
                value = row.getLong(index);
                break;
            }
            case FLOAT: {
                value = row.getFloat(index);
                break;
            }
            case DOUBLE: {
                value = row.getDouble(index);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(row.getDataType(index).toString());
            }
        }
        return value;
    }

    public void beforeDestroy() {
        logger.debug("Adder#beforeDestroy");
    }
}

