/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.itbase.runtime;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.itbase.runtime.ClusterTestResultSet;
import org.apache.iotdb.itbase.runtime.NodeConnection;
import org.apache.iotdb.itbase.runtime.ParallelRequestDelegate;
import org.apache.iotdb.itbase.runtime.RequestDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterTestStatement
implements Statement {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterTestStatement.class);
    private static final int DEFAULT_QUERY_TIMEOUT = 120;
    private Statement writeStatement;
    private String writEndpoint;
    private final List<Statement> readStatements = new ArrayList<Statement>();
    private final List<String> readEndpoints = new ArrayList<String>();
    private boolean closed = false;
    private int maxRows = Integer.MAX_VALUE;
    private int queryTimeout = 120;
    private int fetchSize = 5000;

    public ClusterTestStatement(NodeConnection writeConnection, List<NodeConnection> readConnections) {
        try {
            this.writeStatement = writeConnection.getUnderlyingConnecton().createStatement();
            this.updateConfig(this.writeStatement, 0);
            this.writEndpoint = writeConnection.toString();
        }
        catch (SQLException e) {
            LOGGER.warn("Failed to create write statement.", (Throwable)e);
        }
        for (NodeConnection readConnection : readConnections) {
            try {
                Statement readStatement = readConnection.getUnderlyingConnecton().createStatement();
                this.readStatements.add(readStatement);
                this.readEndpoints.add(readConnection.toString());
                this.updateConfig(readStatement, this.queryTimeout);
            }
            catch (SQLException e) {
                LOGGER.warn("Cannot create read statement from connection {}.", (Object)readConnection, (Object)e);
            }
        }
        if (this.readStatements.isEmpty()) {
            LOGGER.warn("Failed to create any read statement.");
        }
    }

    private void updateConfig(Statement statement, int timeout) throws SQLException {
        this.maxRows = Math.min(statement.getMaxRows(), this.maxRows);
        statement.setQueryTimeout(timeout);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return new ClusterTestResultSet(this.readStatements, this.readEndpoints, sql, this.queryTimeout);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.writeStatement.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        ArrayList<String> endpoints = new ArrayList<String>();
        endpoints.add(this.writEndpoint);
        endpoints.addAll(this.readEndpoints);
        ParallelRequestDelegate<Void> delegate = new ParallelRequestDelegate<Void>(endpoints, this.queryTimeout);
        delegate.addRequest(() -> {
            if (this.writeStatement != null) {
                this.writeStatement.close();
            }
            return null;
        });
        this.readStatements.forEach(r -> delegate.addRequest(() -> {
            if (r != null) {
                try {
                    r.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return null;
        }));
        ((RequestDelegate)delegate).requestAll();
        this.closed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.writeStatement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.writeStatement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        for (Statement readStatement : this.readStatements) {
            readStatement.setMaxRows(max);
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.writeStatement.setEscapeProcessing(enable);
        for (Statement readStatement : this.readStatements) {
            readStatement.setEscapeProcessing(enable);
        }
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds > 0 ? seconds : 120;
        this.writeStatement.setQueryTimeout(this.queryTimeout);
        for (Statement readStatement : this.readStatements) {
            readStatement.setQueryTimeout(this.queryTimeout);
        }
    }

    @Override
    public void cancel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLWarning getWarnings() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearWarnings() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCursorName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.writeStatement.execute(sql);
    }

    @Override
    public ResultSet getResultSet() {
        throw new UnsupportedOperationException("In integration-test you must use Statement.executeQuery() to query data");
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.writeStatement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchDirection(int direction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFetchDirection() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
        this.writeStatement.setFetchSize(this.fetchSize);
        for (Statement readStatement : this.readStatements) {
            readStatement.setFetchSize(this.fetchSize);
        }
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.writeStatement.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.writeStatement.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.writeStatement.executeBatch();
    }

    @Override
    public Connection getConnection() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getMoreResults(int current) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getGeneratedKeys() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetHoldability() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPoolable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void closeOnCompletion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCloseOnCompletion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        throw new UnsupportedOperationException();
    }
}

