/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example;

import java.io.IOException;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowIterator;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Accumulator
implements UDTF {
    private static final Logger logger = LoggerFactory.getLogger(Accumulator.class);

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.DOUBLE});
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        logger.debug("Accumulator#beforeStart");
        configurations.setOutputDataType(Type.INT32);
        switch (parameters.getStringOrDefault("access", "row-by-row")) {
            case "size": {
                configurations.setAccessStrategy((AccessStrategy)new SlidingSizeWindowAccessStrategy(parameters.getInt("windowSize").intValue()));
                break;
            }
            case "time": {
                configurations.setAccessStrategy((AccessStrategy)new SlidingTimeWindowAccessStrategy(parameters.getLong("timeInterval").longValue(), parameters.getLong("slidingStep").longValue(), parameters.getLong("displayWindowBegin").longValue(), parameters.getLong("displayWindowEnd").longValue()));
                break;
            }
            default: {
                configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy());
            }
        }
    }

    public void transform(Row row, PointCollector collector) throws IOException {
        collector.putInt(row.getTime(), row.getInt(0));
    }

    public void transform(RowWindow rowWindow, PointCollector collector) throws IOException {
        int accumulator = 0;
        RowIterator rowIterator = rowWindow.getRowIterator();
        while (rowIterator.hasNextRow()) {
            switch (rowWindow.getDataType(0)) {
                case INT32: {
                    accumulator += rowIterator.next().getInt(0);
                    break;
                }
                case DOUBLE: {
                    accumulator += (int)rowIterator.next().getDouble(0);
                }
            }
        }
        if (rowWindow.windowSize() != 0) {
            collector.putInt(rowWindow.getRow(0).getTime(), accumulator);
        }
    }

    public void beforeDestroy() {
        logger.debug("Accumulator#beforeDestroy");
    }
}

