/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.isession.ITableSession;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.isession.pool.ITableSessionPool;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.pool.TableSessionPoolBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.write.record.Tablet;

public class TableModelSessionPoolExample {
    private static final String LOCAL_URL = "127.0.0.1:6667";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        SessionDataSet dataSet;
        ITableSession session;
        try (ITableSessionPool tableSessionPool = new TableSessionPoolBuilder().nodeUrls(Collections.singletonList(LOCAL_URL)).user("root").password("root").maxSize(1).build();){
            session = tableSessionPool.getSession();
            try {
                session.executeNonQueryStatement("CREATE DATABASE test1");
                session.executeNonQueryStatement("CREATE DATABASE test2");
                session.executeNonQueryStatement("use test2");
                session.executeNonQueryStatement("create table test1.table1(region_id STRING TAG, plant_id STRING TAG, device_id STRING TAG, model STRING ATTRIBUTE, temperature FLOAT FIELD, humidity DOUBLE FIELD) with (TTL=3600000)");
                session.executeNonQueryStatement("create table table2(region_id STRING TAG, plant_id STRING TAG, color STRING ATTRIBUTE, temperature FLOAT FIELD, speed DOUBLE FIELD) with (TTL=6600000)");
                dataSet = session.executeQueryStatement("SHOW TABLES");
                try {
                    System.out.println(dataSet.getColumnNames());
                    System.out.println(dataSet.getColumnTypes());
                    while (dataSet.hasNext()) {
                        System.out.println(dataSet.next());
                    }
                }
                finally {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
                dataSet = session.executeQueryStatement("SHOW TABLES FROM test1");
                try {
                    System.out.println(dataSet.getColumnNames());
                    System.out.println(dataSet.getColumnTypes());
                    while (dataSet.hasNext()) {
                        System.out.println(dataSet.next());
                    }
                }
                finally {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
                List<String> columnNameList = Arrays.asList("region_id", "plant_id", "device_id", "model", "temperature", "humidity");
                List<TSDataType> dataTypeList = Arrays.asList(TSDataType.STRING, TSDataType.STRING, TSDataType.STRING, TSDataType.STRING, TSDataType.FLOAT, TSDataType.DOUBLE);
                ArrayList<Tablet.ColumnCategory> columnTypeList = new ArrayList<Tablet.ColumnCategory>(Arrays.asList(Tablet.ColumnCategory.TAG, Tablet.ColumnCategory.TAG, Tablet.ColumnCategory.TAG, Tablet.ColumnCategory.ATTRIBUTE, Tablet.ColumnCategory.FIELD, Tablet.ColumnCategory.FIELD));
                Tablet tablet = new Tablet("test1", columnNameList, dataTypeList, columnTypeList, 100);
                for (long timestamp = 0L; timestamp < 100L; ++timestamp) {
                    int rowIndex = tablet.getRowSize();
                    tablet.addTimestamp(rowIndex, timestamp);
                    tablet.addValue("region_id", rowIndex, (Object)"1");
                    tablet.addValue("plant_id", rowIndex, (Object)"5");
                    tablet.addValue("device_id", rowIndex, (Object)"3");
                    tablet.addValue("model", rowIndex, (Object)"A");
                    tablet.addValue("temperature", rowIndex, (Object)Float.valueOf(37.6f));
                    tablet.addValue("humidity", rowIndex, (Object)111.1);
                    if (tablet.getRowSize() != tablet.getMaxRowNumber()) continue;
                    session.insert(tablet);
                    tablet.reset();
                }
                if (tablet.getRowSize() != 0) {
                    session.insert(tablet);
                    tablet.reset();
                }
                try (SessionDataSet dataSet2 = session.executeQueryStatement("select * from test1 where region_id = '1' and plant_id in ('3', '5') and device_id = '3'");){
                    System.out.println(dataSet2.getColumnNames());
                    System.out.println(dataSet2.getColumnTypes());
                    while (dataSet2.hasNext()) {
                        System.out.println(dataSet2.next());
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        tableSessionPool = new TableSessionPoolBuilder().nodeUrls(Collections.singletonList(LOCAL_URL)).user("root").password("root").maxSize(1).database("test1").build();
        try {
            session = tableSessionPool.getSession();
            try {
                dataSet = session.executeQueryStatement("SHOW TABLES");
                try {
                    System.out.println(dataSet.getColumnNames());
                    System.out.println(dataSet.getColumnTypes());
                    while (dataSet.hasNext()) {
                        System.out.println(dataSet.next());
                    }
                }
                finally {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
                session.executeNonQueryStatement("use test2");
                dataSet = session.executeQueryStatement("SHOW TABLES");
                try {
                    System.out.println(dataSet.getColumnNames());
                    System.out.println(dataSet.getColumnTypes());
                    while (dataSet.hasNext()) {
                        System.out.println(dataSet.next());
                    }
                }
                finally {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        catch (IoTDBConnectionException e) {
            e.printStackTrace();
        }
        catch (StatementExecutionException e) {
            e.printStackTrace();
        }
        try {
            session = tableSessionPool.getSession();
            try {
                dataSet = session.executeQueryStatement("SHOW TABLES");
                try {
                    System.out.println(dataSet.getColumnNames());
                    System.out.println(dataSet.getColumnTypes());
                    while (dataSet.hasNext()) {
                        System.out.println(dataSet.next());
                    }
                }
                finally {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        catch (IoTDBConnectionException e) {
            e.printStackTrace();
        }
        catch (StatementExecutionException e) {
            e.printStackTrace();
        }
        finally {
            tableSessionPool.close();
        }
    }
}

