/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"strcmp"}, parameter="(String s1, String s2)", descriptions={"- Return \"\" if either argument is NULL;", "- Return 0 if the strings are the same;", "- Return -1 if 's1' is smaller than 's2' according to the current sort order;", "- Return 1 otherwise."}, examples={"strcmp('hello world','banana') = 1"})
public class StrcmpFunction
implements ValueParser {
    private final ValueParser leftStringParser;
    private final ValueParser rightStringParser;

    public StrcmpFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.leftStringParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.rightStringParser = OperatorTools.buildParser((Expression)expressions.get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        String rightString;
        Object leftStringObj = this.leftStringParser.parse(sourceData, rowIndex, context);
        Object rightStringObj = this.rightStringParser.parse(sourceData, rowIndex, context);
        if (leftStringObj == null || rightStringObj == null) {
            return null;
        }
        String leftString = OperatorTools.parseString(leftStringObj);
        int cmp = OperatorTools.compareValue((Comparable)((Object)leftString), (Comparable)((Object)(rightString = OperatorTools.parseString(rightStringObj))));
        if (cmp > 0) {
            return 1;
        }
        if (cmp < 0) {
            return -1;
        }
        return 0;
    }
}

