/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"regexp_count"}, parameter="(Integer INT1, [Integer INT2])", descriptions={"- Return \"\" if any of the arguments are NULL or 'regexp' is invalid;", "- Return the number of times 'str' matches the 'regexp' pattern.", "Note: 'regexp' must be a Java regular expression."}, examples={"regexp_count(\"The quick brown fox quick\", \"quick\") = 2"})
public class RegexpCountFunction
implements ValueParser {
    private ValueParser inputStringParser;
    private ValueParser patternStringParser;

    public RegexpCountFunction(Function expr) {
        List expressions;
        if (expr.getParameters() != null && (expressions = expr.getParameters().getExpressions()) != null && expressions.size() >= 2) {
            this.inputStringParser = OperatorTools.buildParser((Expression)expressions.get(0));
            this.patternStringParser = OperatorTools.buildParser((Expression)expressions.get(1));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        if (this.inputStringParser == null || this.patternStringParser == null) {
            return null;
        }
        String inputString = OperatorTools.parseString(this.inputStringParser.parse(sourceData, rowIndex, context));
        String patternString = OperatorTools.parseString(this.patternStringParser.parse(sourceData, rowIndex, context));
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(inputString);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }
}

