/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.parser;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Set;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import org.apache.inlong.sdk.transform.process.parser.ColumnParser;
import org.apache.inlong.sdk.transform.process.parser.TransformParser;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserTools {
    private static final Logger log = LoggerFactory.getLogger(ParserTools.class);
    private static final String PARSER_PATH = "org.apache.inlong.sdk.transform.process.parser";
    private static final Map<Class<? extends Expression>, Class<?>> parserMap = Maps.newConcurrentMap();

    private static void init() {
        Reflections reflections = new Reflections(PARSER_PATH, new Scanner[]{Scanners.TypesAnnotated});
        Set clazzSet = reflections.getTypesAnnotatedWith(TransformParser.class);
        for (Class clazz : clazzSet) {
            Class<? extends Expression>[] values;
            TransformParser annotation;
            if (!ValueParser.class.isAssignableFrom(clazz) || (annotation = clazz.getAnnotation(TransformParser.class)) == null) continue;
            for (Class<? extends Expression> value : values = annotation.values()) {
                parserMap.compute(value, (key, former) -> {
                    if (former != null) {
                        log.warn("find a conflict for parser class [{}], the former one is [{}], new one is [{}]", new Object[]{key, former.getName(), clazz.getName()});
                    }
                    return clazz;
                });
            }
        }
    }

    public static ValueParser getTransformParser(Expression expr) {
        if (expr == null) {
            return null;
        }
        Class<?> clazz = parserMap.get(expr.getClass());
        if (clazz == null) {
            return new ColumnParser((Column)expr);
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(expr.getClass());
            return (ValueParser)constructor.newInstance(expr);
        }
        catch (NoSuchMethodException e) {
            log.error("transform parser {} needs one constructor that accept one params whose type is {}", new Object[]{clazz.getName(), expr.getClass().getName(), e});
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ParserTools.init();
    }
}

