/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"unhex"}, parameter="(String str)", descriptions={"- Return \"\" if 'str' is NULL;", "- Return the result of interpreting each pair of characters in the argument as the character corresponding to its hexadecimal number."}, examples={"unhex(\"696E6C6F6E67\") = \"inlong\""})
public class UnHexFunction
implements ValueParser {
    private ValueParser valueParser;

    public UnHexFunction(Function expr) {
        this.valueParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object valueObj = this.valueParser.parse(sourceData, rowIndex, context);
        if (valueObj == null) {
            return null;
        }
        return UnHexFunction.hexToString(OperatorTools.parseString(valueObj));
    }

    public static String hexToString(String hex) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < hex.length(); i += 2) {
            String str = hex.substring(i, i + 2);
            char ch = (char)Integer.parseInt(str, 16);
            output.append(ch);
        }
        return output.toString();
    }
}

