/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.Arrays;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"map_entries"}, parameter="(Map map)", descriptions={"- Return \"\" if 'map' is NULL;", "- Return an array of all entries in the given 'map'."}, examples={"map_entries(Map('he',1,'xxd','cloud')) = [he=1, xxd=cloud]", "map_entries(Map(1,2,'cloud','xxd')) = [xxd=cloud, 1=2]"})
public class MapEntriesFunction
implements ValueParser {
    private final ValueParser mapParser;

    public MapEntriesFunction(Function expr) {
        this.mapParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object mapObj = this.mapParser.parse(sourceData, rowIndex, context);
        if (mapObj == null) {
            return null;
        }
        if (mapObj instanceof Map) {
            Map map = (Map)mapObj;
            return Arrays.toString(map.entrySet().toArray(new Map.Entry[0]));
        }
        return null;
    }
}

