/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.decode.SourceDecoder;
import org.apache.inlong.sdk.transform.decode.XmlNode;
import org.apache.inlong.sdk.transform.decode.XmlSourceData;
import org.apache.inlong.sdk.transform.pojo.XmlSourceInfo;
import org.apache.inlong.sdk.transform.process.Context;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlSourceDecoder
extends SourceDecoder<String> {
    private static final Logger log = LoggerFactory.getLogger(XmlSourceDecoder.class);
    protected XmlSourceInfo sourceInfo;
    private Charset srcCharset = Charset.defaultCharset();
    private String rowsNodePath;
    private List<String> childNodes;

    public XmlSourceDecoder(XmlSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
        if (!StringUtils.isBlank((CharSequence)sourceInfo.getCharset())) {
            this.srcCharset = Charset.forName(sourceInfo.getCharset());
        }
        this.rowsNodePath = sourceInfo.getRowsNodePath();
        if (!StringUtils.isBlank((CharSequence)this.rowsNodePath)) {
            this.childNodes = new ArrayList<String>();
            String[] nodeStrings = this.rowsNodePath.split("\\.");
            this.childNodes.addAll(Arrays.asList(nodeStrings));
        }
    }

    @Override
    public SourceData decode(byte[] srcBytes, Context context) {
        String srcString = new String(srcBytes, this.srcCharset);
        return this.decode(srcString, context);
    }

    @Override
    public SourceData decode(String srcString, Context context) {
        try {
            Document doc = DocumentHelper.parseText((String)srcString);
            Element root = doc.getRootElement();
            XmlNode rootObj = XmlSourceDecoder.parser(root).get(root.getName());
            Object cur = rootObj.getValue();
            XmlNode child = null;
            if (this.childNodes != null) {
                for (String node : this.childNodes) {
                    if (cur instanceof Map) {
                        child = (XmlNode)((Map)cur).get(node);
                    } else if (cur instanceof List) {
                        int start = node.indexOf(40) + 1;
                        int end = node.indexOf(41);
                        int idx = Integer.parseInt(node.substring(start, end));
                        child = (XmlNode)((List)cur).get(idx);
                    }
                    cur = child.getValue();
                }
            }
            return new XmlSourceData(rootObj, child);
        }
        catch (Exception e) {
            log.error("Data parsing failed", (Throwable)e);
            return null;
        }
    }

    public static Map<String, XmlNode> parser(Element root) {
        HashMap<String, XmlNode> xmlData = new HashMap<String, XmlNode>();
        if (root.isTextOnly()) {
            xmlData.put(root.getName(), new XmlNode(root.getName(), root.getText()));
        } else {
            ArrayList<Map<String, XmlNode>> childNodes = new ArrayList<Map<String, XmlNode>>();
            for (Object elementObj : root.elements()) {
                Element element = (Element)elementObj;
                childNodes.add(XmlSourceDecoder.parser(element));
            }
            HashMap<String, XmlNode> mergeMap = new HashMap<String, XmlNode>();
            for (Map map : childNodes) {
                for (String key : map.keySet()) {
                    XmlNode nowNode = (XmlNode)mergeMap.get(key);
                    XmlNode tarNode = (XmlNode)map.get(key);
                    if (nowNode == null) {
                        mergeMap.put(key, tarNode);
                        continue;
                    }
                    if (nowNode.getValue() instanceof List) {
                        ((List)nowNode.getValue()).add(tarNode);
                        continue;
                    }
                    ArrayList<XmlNode> list = new ArrayList<XmlNode>();
                    list.add(nowNode);
                    list.add(tarNode);
                    mergeMap.put(key, new XmlNode(key, list));
                }
            }
            if (mergeMap.size() == 1) {
                XmlNode childValue = (XmlNode)new ArrayList(mergeMap.values()).get(0);
                xmlData.put(root.getName(), new XmlNode(root.getName(), childValue));
            } else {
                xmlData.put(root.getName(), new XmlNode(root.getName(), mergeMap));
            }
        }
        return xmlData;
    }
}

