/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.transform.decode.PbNode;
import org.apache.inlong.sdk.transform.decode.PbSourceData;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.decode.SourceDecoder;
import org.apache.inlong.sdk.transform.decode.TransformException;
import org.apache.inlong.sdk.transform.pojo.PbSourceInfo;
import org.apache.inlong.sdk.transform.process.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PbSourceDecoder
extends SourceDecoder<byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(PbSourceDecoder.class);
    protected PbSourceInfo sourceInfo;
    private Charset srcCharset = Charset.defaultCharset();
    private String protoDescription;
    private String rootMessageType;
    private Descriptors.Descriptor rootDesc;
    private String rowsNodePath;
    private List<PbNode> childNodes;
    private Descriptors.Descriptor childDesc;
    private Map<String, List<PbNode>> columnNodeMap = new ConcurrentHashMap<String, List<PbNode>>();

    public PbSourceDecoder(PbSourceInfo sourceInfo) {
        try {
            this.sourceInfo = sourceInfo;
            if (!StringUtils.isBlank((CharSequence)sourceInfo.getCharset())) {
                this.srcCharset = Charset.forName(sourceInfo.getCharset());
            }
            this.protoDescription = sourceInfo.getProtoDescription();
            this.rootMessageType = sourceInfo.getRootMessageType();
            byte[] protoBytes = Base64.getDecoder().decode(this.protoDescription);
            DescriptorProtos.FileDescriptorSet descriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom((byte[])protoBytes);
            DescriptorProtos.FileDescriptorProto fileDesc = descriptorSet.getFile(0);
            Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDesc, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
            this.rootDesc = fileDescriptor.findMessageTypeByName(this.rootMessageType);
            this.rowsNodePath = sourceInfo.getRowsNodePath();
            this.childNodes = PbNode.parseNodePath(this.rootDesc, this.rowsNodePath);
            if (this.childNodes != null && this.childNodes.size() > 0) {
                this.childDesc = this.childNodes.get(this.childNodes.size() - 1).getMessageType();
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new TransformException(e.getMessage(), e);
        }
    }

    @Override
    public SourceData decode(byte[] srcBytes, Context context) {
        try {
            DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)this.rootDesc);
            DynamicMessage root = ((DynamicMessage.Builder)builder.mergeFrom(srcBytes)).build();
            List childRoot = null;
            if (this.childNodes != null && this.childNodes.size() > 0) {
                DynamicMessage current = root;
                for (PbNode node : this.childNodes) {
                    Object nodeValue = current.getField(node.getFieldDesc());
                    if (nodeValue == null) {
                        return new PbSourceData(root, this.rootDesc, this.columnNodeMap, this.srcCharset);
                    }
                    if (node.isLastNode()) {
                        if (!(nodeValue instanceof List)) {
                            return new PbSourceData(root, this.rootDesc, this.columnNodeMap, this.srcCharset);
                        }
                        childRoot = (List)nodeValue;
                        break;
                    }
                    if (!node.isArray()) {
                        if (!(nodeValue instanceof DynamicMessage)) {
                            return new PbSourceData(root, this.rootDesc, this.columnNodeMap, this.srcCharset);
                        }
                        current = (DynamicMessage)nodeValue;
                        continue;
                    }
                    if (!(nodeValue instanceof List)) {
                        return new PbSourceData(root, this.rootDesc, this.columnNodeMap, this.srcCharset);
                    }
                    List nodeList = (List)nodeValue;
                    if (node.getArrayIndex() >= nodeList.size()) {
                        return new PbSourceData(root, this.rootDesc, this.columnNodeMap, this.srcCharset);
                    }
                    Object nodeElement = nodeList.get(node.getArrayIndex());
                    if (!(nodeElement instanceof DynamicMessage)) {
                        return new PbSourceData(root, this.rootDesc, this.columnNodeMap, this.srcCharset);
                    }
                    current = (DynamicMessage)nodeElement;
                }
            }
            return new PbSourceData(root, childRoot, this.rootDesc, this.childDesc, this.columnNodeMap, this.srcCharset);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

