/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.transform.decode.KvSourceData;
import org.apache.inlong.sdk.transform.decode.KvUtils;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.decode.SourceDecoder;
import org.apache.inlong.sdk.transform.pojo.FieldInfo;
import org.apache.inlong.sdk.transform.pojo.KvSourceInfo;
import org.apache.inlong.sdk.transform.process.Context;

public class KvSourceDecoder
extends SourceDecoder<String> {
    protected KvSourceInfo sourceInfo;
    private Character entryDelimiter = Character.valueOf('&');
    private Character kvDelimiter = Character.valueOf('=');
    private Character escapeChar = Character.valueOf('\\');
    private Character quoteChar = Character.valueOf('\"');
    private Character lineDelimiter = Character.valueOf('\n');
    private Charset srcCharset = Charset.defaultCharset();

    public KvSourceDecoder(KvSourceInfo sourceInfo) {
        super(sourceInfo.getFields());
        this.sourceInfo = sourceInfo;
        if (!StringUtils.isBlank((CharSequence)sourceInfo.getCharset())) {
            this.srcCharset = Charset.forName(sourceInfo.getCharset());
        }
        if (sourceInfo.getEntryDelimiter() != null) {
            this.entryDelimiter = sourceInfo.getEntryDelimiter();
        }
        if (sourceInfo.getKvDelimiter() != null) {
            this.kvDelimiter = sourceInfo.getKvDelimiter();
        }
        if (sourceInfo.getEscapeChar() != null) {
            this.escapeChar = sourceInfo.getEscapeChar();
        }
        if (sourceInfo.getQuoteChar() != null) {
            this.quoteChar = sourceInfo.getQuoteChar();
        }
        if (sourceInfo.getLineDelimiter() != null) {
            this.lineDelimiter = sourceInfo.getLineDelimiter();
        }
    }

    @Override
    public SourceData decode(byte[] srcBytes, Context context) {
        String srcString = new String(srcBytes, this.srcCharset);
        return this.decode(srcString, context);
    }

    @Override
    public SourceData decode(String srcString, Context context) {
        List<Map<String, String>> rowValues = KvUtils.splitKv(srcString, this.entryDelimiter, this.kvDelimiter, this.escapeChar, this.quoteChar, this.lineDelimiter);
        KvSourceData sourceData = new KvSourceData();
        if (CollectionUtils.isEmpty((Collection)this.fields)) {
            for (Map<String, String> row : rowValues) {
                sourceData.addRow();
                row.forEach(sourceData::putField);
            }
            return sourceData;
        }
        for (Map<String, String> row : rowValues) {
            sourceData.addRow();
            for (FieldInfo field : this.fields) {
                String fieldName = field.getName();
                String fieldValue = row.get(fieldName);
                sourceData.putField(fieldName, fieldValue);
            }
        }
        return sourceData;
    }
}

