/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.transform.decode.JsonNode;
import org.apache.inlong.sdk.transform.decode.SourceData;

public class JsonSourceData
implements SourceData {
    public static final String ROOT_KEY = "$root";
    public static final String CHILD_KEY = "$child";
    private JsonObject root;
    private JsonArray childRoot;

    public JsonSourceData(JsonObject root, JsonArray childRoot) {
        this.root = root;
        this.childRoot = childRoot;
    }

    @Override
    public int getRowCount() {
        if (this.childRoot == null) {
            return 1;
        }
        return this.childRoot.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getField(int rowNum, String fieldName) {
        try {
            String[] nodeStrings;
            ArrayList<JsonNode> childNodes = new ArrayList<JsonNode>();
            for (String nodeString : nodeStrings = fieldName.split("\\.")) {
                childNodes.add(new JsonNode(nodeString));
            }
            if (childNodes.size() == 0) {
                return "";
            }
            JsonNode firstNode = (JsonNode)childNodes.get(0);
            JsonObject current = this.root;
            if (StringUtils.equals((CharSequence)ROOT_KEY, (CharSequence)firstNode.getName())) {
                current = this.root;
            } else {
                if (!StringUtils.equals((CharSequence)CHILD_KEY, (CharSequence)firstNode.getName())) return "";
                if (rowNum >= this.childRoot.size()) return "";
                current = this.childRoot.get(rowNum);
            }
            if (current == null) {
                return "";
            }
            for (int i = 1; i < childNodes.size(); ++i) {
                JsonNode node = (JsonNode)childNodes.get(i);
                if (!current.isJsonObject()) {
                    return "";
                }
                JsonElement newElement = current.getAsJsonObject().get(node.getName());
                if (newElement == null) {
                    return "";
                }
                if (!node.isArray()) {
                    current = newElement;
                    continue;
                }
                current = this.getElementFromArray(node, newElement);
                if (current != null) continue;
                return "";
            }
            return current.getAsString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private JsonElement getElementFromArray(JsonNode node, JsonElement curElement) {
        if (node.getArrayIndices().isEmpty()) {
            return null;
        }
        for (int index : node.getArrayIndices()) {
            if (!curElement.isJsonArray()) {
                return null;
            }
            JsonArray newArray = curElement.getAsJsonArray();
            if (index >= newArray.size()) {
                return null;
            }
            curElement = newArray.get(index);
        }
        return curElement;
    }
}

