/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.transform.decode.AvroNode;
import org.apache.inlong.sdk.transform.decode.AvroSourceData;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.decode.SourceDecoder;
import org.apache.inlong.sdk.transform.decode.TransformException;
import org.apache.inlong.sdk.transform.pojo.AvroSourceInfo;
import org.apache.inlong.sdk.transform.process.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSourceDecoder
extends SourceDecoder<byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(AvroSourceDecoder.class);
    protected AvroSourceInfo sourceInfo;
    private Charset srcCharset = Charset.defaultCharset();
    private String rowsNodePath;
    private List<AvroNode> childNodes;

    public AvroSourceDecoder(AvroSourceInfo sourceInfo) {
        try {
            this.sourceInfo = sourceInfo;
            if (!StringUtils.isBlank((CharSequence)sourceInfo.getCharset())) {
                this.srcCharset = Charset.forName(sourceInfo.getCharset());
            }
            this.rowsNodePath = sourceInfo.getRowsNodePath();
            if (!StringUtils.isBlank((CharSequence)this.rowsNodePath)) {
                String[] nodeStrings;
                this.childNodes = new ArrayList<AvroNode>();
                for (String nodeString : nodeStrings = this.rowsNodePath.split("\\.")) {
                    this.childNodes.add(new AvroNode(nodeString));
                }
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new TransformException(e.getMessage(), e);
        }
    }

    @Override
    public SourceData decode(byte[] srcBytes, Context context) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(srcBytes);
            DataFileStream dataFileStream = new DataFileStream((InputStream)inputStream, (DatumReader)new GenericDatumReader());
            GenericRecord root = (GenericRecord)dataFileStream.next();
            List childRoot = null;
            if (CollectionUtils.isEmpty(this.childNodes)) {
                return new AvroSourceData(root, null, this.srcCharset);
            }
            Object current = root;
            Schema curSchema = root.getSchema();
            for (AvroNode node : this.childNodes) {
                if (curSchema.getType() != Schema.Type.RECORD) {
                    return new AvroSourceData(root, null, this.srcCharset);
                }
                Object newElement = current.get(node.getName());
                if (newElement == null) {
                    return new AvroSourceData(root, null, this.srcCharset);
                }
                if (!node.isArray()) {
                    curSchema = curSchema.getField(node.getName()).schema();
                    current = newElement;
                    continue;
                }
                current = this.getElementFromArray(node, newElement, curSchema);
                if (current != null) continue;
                return new AvroSourceData(root, null, this.srcCharset);
            }
            if (curSchema.getType() != Schema.Type.ARRAY) {
                return new AvroSourceData(root, null, this.srcCharset);
            }
            childRoot = (List)current;
            return new AvroSourceData(root, childRoot, this.srcCharset);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Object getElementFromArray(AvroNode node, Object curElement, Schema curSchema) {
        if (node.getArrayIndices().isEmpty()) {
            return null;
        }
        for (int index : node.getArrayIndices()) {
            if (curSchema.getType() != Schema.Type.ARRAY) {
                return null;
            }
            List newArray = (List)curElement;
            if (index >= newArray.size()) {
                return null;
            }
            curSchema = curSchema.getElementType();
            curElement = newArray.get(index);
        }
        return curElement;
    }
}

