/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.auth.tenant;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.web.auth.tenant.TenantToken;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantAuthenticatingFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(TenantAuthenticatingFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        Subject subject = SecurityUtils.getSubject();
        if (!subject.isAuthenticated()) {
            log.error("The request should be authed before tenant authentication, user:{}, path:{}", subject.getPrincipal(), (Object)httpServletRequest.getServletPath());
            ((HttpServletResponse)response).sendError(500);
            return;
        }
        UserInfo loginUserInfo = (UserInfo)subject.getPrincipal();
        String tenant = httpServletRequest.getHeader("tenant");
        try {
            Preconditions.expectNotBlank((String)tenant, (String)"tenant should not be null or blank");
            subject.login((AuthenticationToken)new TenantToken(loginUserInfo.getName(), tenant));
        }
        catch (Exception ex) {
            log.error("tenant auth error: {}", (Object)ex.getMessage());
            ((HttpServletResponse)response).sendError(403, ex.getMessage());
            return;
        }
        if (!subject.isAuthenticated()) {
            log.error("Access denied for user:{}, tenant:{}, path:{} ", new Object[]{subject.getPrincipal(), tenant, httpServletRequest.getServletPath()});
            ((HttpServletResponse)response).sendError(403);
            return;
        }
        chain.doFilter(request, response);
    }
}

