/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow;

import java.util.List;
import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.pojo.workflow.ProcessCountRequest;
import org.apache.inlong.manager.pojo.workflow.ProcessCountResponse;
import org.apache.inlong.manager.pojo.workflow.ProcessDetailResponse;
import org.apache.inlong.manager.pojo.workflow.ProcessRequest;
import org.apache.inlong.manager.pojo.workflow.ProcessResponse;
import org.apache.inlong.manager.pojo.workflow.TaskCountRequest;
import org.apache.inlong.manager.pojo.workflow.TaskCountResponse;
import org.apache.inlong.manager.pojo.workflow.TaskLogRequest;
import org.apache.inlong.manager.pojo.workflow.TaskRequest;
import org.apache.inlong.manager.pojo.workflow.TaskResponse;
import org.apache.inlong.manager.pojo.workflow.WorkflowExecuteLog;
import org.apache.inlong.manager.pojo.workflow.WorkflowResult;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.task.TaskForm;

public interface WorkflowService {
    public WorkflowResult start(ProcessName var1, String var2, ProcessForm var3);

    default public WorkflowResult startAsync(ProcessName process, UserInfo userInfo, ProcessForm form) {
        LoginUserUtils.setUserLoginInfo((UserInfo)userInfo);
        WorkflowResult result = this.start(process, userInfo.getName(), form);
        LoginUserUtils.removeUserLoginInfo();
        return result;
    }

    public WorkflowResult continueProcess(Integer var1, String var2, String var3);

    default public WorkflowResult continueProcessAsync(Integer processId, UserInfo userInfo, String remark) {
        LoginUserUtils.setUserLoginInfo((UserInfo)userInfo);
        WorkflowResult result = this.continueProcess(processId, userInfo.getName(), remark);
        LoginUserUtils.removeUserLoginInfo();
        return result;
    }

    public WorkflowResult cancel(Integer var1, String var2, String var3);

    public WorkflowResult approve(Integer var1, String var2, TaskForm var3, String var4);

    public WorkflowResult reject(Integer var1, String var2, String var3);

    public WorkflowResult transfer(Integer var1, String var2, List<String> var3, String var4);

    public WorkflowResult complete(Integer var1, String var2, String var3);

    public ProcessDetailResponse detail(Integer var1, Integer var2, String var3);

    public PageResult<ProcessResponse> listProcess(ProcessRequest var1);

    public PageResult<TaskResponse> listTask(TaskRequest var1);

    public ProcessCountResponse countProcess(ProcessCountRequest var1);

    public TaskCountResponse countTask(TaskCountRequest var1);

    public PageResult<WorkflowExecuteLog> listTaskLogs(TaskLogRequest var1);
}

