/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.group;

import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.StreamStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamEntityMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupCheckService {
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private InlongStreamEntityMapper streamMapper;

    public InlongGroupEntity checkGroupStatus(String groupId, String operator) {
        InlongGroupEntity inlongGroupEntity = this.groupMapper.selectByGroupId(groupId);
        if (inlongGroupEntity == null) {
            throw new BusinessException(String.format("InlongGroup does not exist with InlongGroupId=%s", groupId));
        }
        GroupStatus status = GroupStatus.forCode((int)inlongGroupEntity.getStatus());
        if (GroupStatus.notAllowedUpdate((GroupStatus)status)) {
            throw new BusinessException(String.format(ErrorCodeEnum.OPT_NOT_ALLOWED_BY_STATUS.getMessage(), status));
        }
        return inlongGroupEntity;
    }

    public InlongStreamEntity checkStreamStatus(String groupId, String streamId, String operator) {
        InlongStreamEntity inlongStreamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        if (inlongStreamEntity == null) {
            throw new BusinessException(String.format("InlongStream does not exist with groupId=%s, streamId=%s", groupId, streamId));
        }
        StreamStatus status = StreamStatus.forCode((int)inlongStreamEntity.getStatus());
        if (StreamStatus.notAllowedUpdate((StreamStatus)status)) {
            throw new BusinessException(String.format(ErrorCodeEnum.OPT_NOT_ALLOWED_BY_STATUS.getMessage(), status));
        }
        return inlongStreamEntity;
    }
}

