/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster.node;

import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.NodeStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongClusterNodeEntity;
import org.apache.inlong.manager.dao.mapper.InlongClusterNodeEntityMapper;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeRequest;
import org.apache.inlong.manager.service.cluster.node.InlongClusterNodeOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractClusterNodeOperator
implements InlongClusterNodeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractClusterNodeOperator.class);
    @Autowired
    protected InlongClusterNodeEntityMapper clusterNodeMapper;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer saveOpt(ClusterNodeRequest request, String operator) {
        InlongClusterNodeEntity entity = (InlongClusterNodeEntity)CommonBeanUtils.copyProperties((Object)request, InlongClusterNodeEntity::new);
        this.setTargetEntity(request, entity);
        entity.setCreator(operator);
        entity.setModifier(operator);
        entity.setStatus(Integer.valueOf(NodeStatus.HEARTBEAT_TIMEOUT.getStatus()));
        this.clusterNodeMapper.insert(entity);
        return entity.getId();
    }

    protected abstract void setTargetEntity(ClusterNodeRequest var1, InlongClusterNodeEntity var2);

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void updateOpt(ClusterNodeRequest request, String operator) {
        InlongClusterNodeEntity entity = this.clusterNodeMapper.selectById(request.getId());
        this.setTargetEntity(request, entity);
        entity.setModifier(operator);
        if (InlongConstants.AFFECTED_ONE_ROW.intValue() != this.clusterNodeMapper.updateByIdSelective(entity)) {
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, String.format("cluster node has already updated with ip=%s, port=%s, protocolType=%s, type=%s, curVersion=%s", entity.getIp(), entity.getPort(), entity.getProtocolType(), entity.getType(), entity.getVersion()));
        }
        LOGGER.debug("success to update inlong cluster node={}", (Object)request);
    }
}

