/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.greenplum;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.pojo.sink.greenplum.GreenplumColumnInfo;
import org.apache.inlong.manager.pojo.sink.greenplum.GreenplumTableInfo;
import org.apache.inlong.manager.service.resource.sink.greenplum.GreenplumSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreenplumJdbcUtils {
    private static final String GREENPLUM_JDBC_PREFIX = "jdbc:postgresql";
    private static final String GREENPLUM_DRIVER_CLASS = "org.postgresql.Driver";
    public static final String GREENPLUM_DEFAULT_SCHEMA = "public";
    private static final Logger LOG = LoggerFactory.getLogger(GreenplumJdbcUtils.class);

    public static Connection getConnection(String url, String user, String password) throws Exception {
        Connection conn;
        if (StringUtils.isBlank((CharSequence)url) || !url.startsWith(GREENPLUM_JDBC_PREFIX)) {
            throw new Exception("Greenplum server URL was invalid, it should start with jdbc:postgresql");
        }
        try {
            Class.forName(GREENPLUM_DRIVER_CLASS);
            conn = DriverManager.getConnection(url, user, password);
        }
        catch (Exception e) {
            String errorMsg = "get Greenplum connection error, please check postgres jdbc url, username or password!";
            LOG.error("get Greenplum connection error, please check postgres jdbc url, username or password!", (Throwable)e);
            throw new Exception("get Greenplum connection error, please check postgres jdbc url, username or password! other error msg: " + e.getMessage());
        }
        if (conn == null) {
            throw new Exception("get Greenplum connection failed, please contact administrator");
        }
        LOG.info("get Greenplum connection success, url={}", (Object)url);
        return conn;
    }

    public static void executeSql(Connection conn, String sql) throws Exception {
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sql);
            LOG.info("execute sql [{}] success", (Object)sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSqlBatch(Connection conn, List<String> sqls) throws Exception {
        conn.setAutoCommit(false);
        try (Statement stmt = conn.createStatement();){
            for (String entry : sqls) {
                stmt.execute(entry);
            }
            conn.commit();
        }
        finally {
            conn.setAutoCommit(true);
        }
        LOG.info("execute batch sql [{}] success", sqls);
    }

    public static void createTable(Connection conn, GreenplumTableInfo tableInfo) throws Exception {
        if (GreenplumJdbcUtils.checkTablesExist(conn, tableInfo.getSchemaName(), tableInfo.getTableName())) {
            LOG.info("the table [{}] are exists", (Object)tableInfo.getTableName());
        } else {
            List<String> createTableSqls = GreenplumSqlBuilder.buildCreateTableSql(tableInfo);
            GreenplumJdbcUtils.executeSqlBatch(conn, createTableSqls);
            LOG.info("execute sql [{}] success", createTableSqls);
        }
    }

    public static void createSchema(Connection conn, String schemaName, String userName) throws Exception {
        if (GreenplumJdbcUtils.checkSchemaExist(conn, schemaName)) {
            LOG.info("the schema [{}] are exists", (Object)schemaName);
        } else {
            String sql = GreenplumSqlBuilder.buildCreateSchema(schemaName, userName);
            GreenplumJdbcUtils.executeSql(conn, sql);
            LOG.info("execute create schema sql [{}] success", (Object)sql);
        }
    }

    public static boolean checkTablesExist(Connection conn, String schemaName, String tableName) throws Exception {
        boolean result = false;
        String checkTableSql = GreenplumSqlBuilder.getCheckTable(schemaName, tableName);
        try (Statement statement = conn.createStatement();
             ResultSet resultSet = statement.executeQuery(checkTableSql);){
            int size;
            if (null != resultSet && resultSet.next() && (size = resultSet.getInt(1)) > 0) {
                result = true;
            }
        }
        LOG.info("check table exist for username={} table={}, result={}", new Object[]{schemaName, tableName, result});
        return result;
    }

    public static boolean checkColumnExist(Connection conn, String schemaName, String tableName, String column) throws Exception {
        boolean result = false;
        String checkColumnSql = GreenplumSqlBuilder.getCheckColumn(schemaName, tableName, column);
        try (Statement statement = conn.createStatement();
             ResultSet resultSet = statement.executeQuery(checkColumnSql);){
            int count;
            if (Objects.nonNull(resultSet) && resultSet.next() && (count = resultSet.getInt(1)) > 0) {
                result = true;
            }
        }
        LOG.info("check column exist for table={}, column={}, result={}", new Object[]{tableName, column, result});
        return result;
    }

    public static boolean checkSchemaExist(Connection conn, String schemaName) throws Exception {
        boolean result = false;
        if (GREENPLUM_DEFAULT_SCHEMA.equals(schemaName)) {
            result = true;
        } else {
            String checkColumnSql = GreenplumSqlBuilder.getCheckSchema(schemaName);
            try (Statement statement = conn.createStatement();
                 ResultSet resultSet = statement.executeQuery(checkColumnSql);){
                int count;
                if (Objects.nonNull(resultSet) && resultSet.next() && (count = resultSet.getInt(1)) > 0) {
                    result = true;
                }
            }
        }
        LOG.info("check schema exist for schema={}, result={}", (Object)schemaName, (Object)result);
        return result;
    }

    public static List<GreenplumColumnInfo> getColumns(Connection conn, String schemaName, String tableName) throws Exception {
        ArrayList<GreenplumColumnInfo> columnList = new ArrayList<GreenplumColumnInfo>();
        String querySql = GreenplumSqlBuilder.buildDescTableSql(schemaName, tableName);
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(querySql);){
            while (rs.next()) {
                columnList.add(new GreenplumColumnInfo(rs.getString(1), rs.getString(2), rs.getString(3)));
            }
        }
        return columnList;
    }

    public static void addColumns(Connection conn, String schemaName, String tableName, List<GreenplumColumnInfo> columns) throws Exception {
        ArrayList<GreenplumColumnInfo> columnInfos = new ArrayList<GreenplumColumnInfo>();
        for (GreenplumColumnInfo columnInfo : columns) {
            if (GreenplumJdbcUtils.checkColumnExist(conn, schemaName, tableName, columnInfo.getName())) continue;
            columnInfos.add(columnInfo);
        }
        List<String> addColumnSql = GreenplumSqlBuilder.buildAddColumnsSql(schemaName, tableName, columnInfos);
        GreenplumJdbcUtils.executeSqlBatch(conn, addColumnSql);
        LOG.info("execute add columns sql [{}] success", addColumnSql);
    }
}

