/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.transform;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;

@ApiModel(value="Delete request of stream transform")
public class DeleteTransformRequest {
    @ApiModelProperty(value="Inlong group id")
    @NotBlank(message="inlongGroupId cannot be blank")
    @Length(min=4, max=100, message="length must be between 4 and 100")
    @Pattern(regexp="^[a-z0-9_.-]{4,100}$", message="only supports lowercase letters, numbers, '-', or '_'")
    private @NotBlank(message="inlongGroupId cannot be blank") @Length(min=4, max=100, message="length must be between 4 and 100") @Pattern(regexp="^[a-z0-9_.-]{4,100}$", message="only supports lowercase letters, numbers, '-', or '_'") String inlongGroupId;
    @ApiModelProperty(value="Inlong stream id")
    @NotBlank(message="inlongStreamId cannot be blank")
    @Length(min=1, max=100, message="inlongStreamId length must be between 1 and 100")
    @Pattern(regexp="^[a-z0-9_.-]{1,100}$", message="inlongStreamId only supports lowercase letters, numbers, '-', or '_'")
    private @NotBlank(message="inlongStreamId cannot be blank") @Length(min=1, max=100, message="inlongStreamId length must be between 1 and 100") @Pattern(regexp="^[a-z0-9_.-]{1,100}$", message="inlongStreamId only supports lowercase letters, numbers, '-', or '_'") String inlongStreamId;
    @ApiModelProperty(value="Transform name, unique in one stream")
    @NotBlank(message="transformName cannot be blank")
    @Length(min=1, max=100, message="transformName length must be between 1 and 100")
    @Pattern(regexp="^[a-z0-9_-]{1,100}$", message="transformName only supports lowercase letters, numbers, '-', or '_'")
    private @NotBlank(message="transformName cannot be blank") @Length(min=1, max=100, message="transformName length must be between 1 and 100") @Pattern(regexp="^[a-z0-9_-]{1,100}$", message="transformName only supports lowercase letters, numbers, '-', or '_'") String transformName;

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public String getTransformName() {
        return this.transformName;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setTransformName(String transformName) {
        this.transformName = transformName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteTransformRequest)) {
            return false;
        }
        DeleteTransformRequest other = (DeleteTransformRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        String this$transformName = this.getTransformName();
        String other$transformName = other.getTransformName();
        return !(this$transformName == null ? other$transformName != null : !this$transformName.equals(other$transformName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteTransformRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        String $transformName = this.getTransformName();
        result = result * 59 + ($transformName == null ? 43 : $transformName.hashCode());
        return result;
    }

    public String toString() {
        return "DeleteTransformRequest(inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", transformName=" + this.getTransformName() + ")";
    }
}

