/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.standalone;

import com.google.gson.Gson;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortSourceStreamInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortSourceStreamInfo.class);
    private static final Gson GSON = new Gson();
    private String inlongGroupId;
    private String inlongStreamId;
    private String mqResource;
    String extParams;
    Map<String, String> extParamsMap = new ConcurrentHashMap<String, String>();

    public Map<String, String> getExtParamsMap() {
        if (this.extParamsMap.isEmpty() && StringUtils.isNotBlank((CharSequence)this.extParams)) {
            try {
                this.extParamsMap = (Map)GSON.fromJson(this.extParams, Map.class);
            }
            catch (Throwable t) {
                LOGGER.error("fail to parse group ext params", t);
            }
        }
        return this.extParamsMap;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public String getMqResource() {
        return this.mqResource;
    }

    public String getExtParams() {
        return this.extParams;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setMqResource(String mqResource) {
        this.mqResource = mqResource;
    }

    public void setExtParams(String extParams) {
        this.extParams = extParams;
    }

    public void setExtParamsMap(Map<String, String> extParamsMap) {
        this.extParamsMap = extParamsMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortSourceStreamInfo)) {
            return false;
        }
        SortSourceStreamInfo other = (SortSourceStreamInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        String this$mqResource = this.getMqResource();
        String other$mqResource = other.getMqResource();
        if (this$mqResource == null ? other$mqResource != null : !this$mqResource.equals(other$mqResource)) {
            return false;
        }
        String this$extParams = this.getExtParams();
        String other$extParams = other.getExtParams();
        if (this$extParams == null ? other$extParams != null : !this$extParams.equals(other$extParams)) {
            return false;
        }
        Map<String, String> this$extParamsMap = this.getExtParamsMap();
        Map<String, String> other$extParamsMap = other.getExtParamsMap();
        return !(this$extParamsMap == null ? other$extParamsMap != null : !((Object)this$extParamsMap).equals(other$extParamsMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SortSourceStreamInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        String $mqResource = this.getMqResource();
        result = result * 59 + ($mqResource == null ? 43 : $mqResource.hashCode());
        String $extParams = this.getExtParams();
        result = result * 59 + ($extParams == null ? 43 : $extParams.hashCode());
        Map<String, String> $extParamsMap = this.getExtParamsMap();
        result = result * 59 + ($extParamsMap == null ? 43 : ((Object)$extParamsMap).hashCode());
        return result;
    }

    public String toString() {
        return "SortSourceStreamInfo(inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", mqResource=" + this.getMqResource() + ", extParams=" + this.getExtParams() + ", extParamsMap=" + this.getExtParamsMap() + ")";
    }
}

